/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.console;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.appwork.console.AbstractConsole;

public class IDEConsole
extends AbstractConsole {
    private final OutputStreamWriter out;
    private final InputStreamReader in;
    private final PrintWriter writer;
    private final LineReader reader;
    private final Object readLock;
    private final Object writeLock;
    private char[] rcb;

    private char[] grow() {
        char[] t = new char[this.rcb.length * 2];
        System.arraycopy(this.rcb, 0, t, 0, this.rcb.length);
        this.rcb = t;
        return this.rcb;
    }

    public IDEConsole() {
        Charset cs = Charset.defaultCharset();
        this.out = new OutputStreamWriter((OutputStream)new FileOutputStream(FileDescriptor.out), cs);
        this.readLock = this.out;
        this.writer = new PrintWriter(this.out, true){

            @Override
            public void close() {
            }
        };
        this.in = new InputStreamReader((InputStream)new FileInputStream(FileDescriptor.in), cs);
        this.writeLock = this.in;
        this.reader = new LineReader(this.in);
        this.rcb = new char[1024];
    }

    @Override
    public void println(String string) {
        this.writer.println(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(String fmt, Object ... args) {
        String line = null;
        Object object = this.writeLock;
        synchronized (object) {
            Object object2 = this.readLock;
            synchronized (object2) {
                if (fmt.length() != 0) {
                    this.writer.format(fmt, args);
                }
                try {
                    char[] ca = this.readline(false);
                    if (ca != null) {
                        line = new String(ca);
                    }
                }
                catch (IOException x) {
                    throw new IOError(x);
                }
            }
        }
        return line;
    }

    @Override
    public String readLine() {
        return this.readLine("", new Object[0]);
    }

    private char[] readline(boolean zeroOut) throws IOException {
        int len = this.reader.read(this.rcb, 0, this.rcb.length);
        if (len < 0) {
            return null;
        }
        if (this.rcb[len - 1] == '\r') {
            --len;
        } else if (this.rcb[len - 1] == '\n' && --len > 0 && this.rcb[len - 1] == '\r') {
            --len;
        }
        char[] b = new char[len];
        if (len > 0) {
            System.arraycopy(this.rcb, 0, b, 0, len);
            if (zeroOut) {
                Arrays.fill(this.rcb, 0, len, ' ');
            }
        }
        return b;
    }

    @Override
    public void print(String string) {
        this.writer.print(string);
        try {
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String readPassword() {
        return this.readLine("", new Object[0]);
    }

    class LineReader
    extends Reader {
        private final Reader in;
        private char[] cb;
        private int nChars;
        private int nextChar;
        boolean leftoverLF;

        LineReader(Reader in) {
            this.in = in;
            this.cb = new char[1024];
            this.nChars = 0;
            this.nextChar = 0;
            this.leftoverLF = false;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean ready() throws IOException {
            return this.in.ready();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(char[] cbuf, int offset, int length) throws IOException {
            int off = offset;
            int end = offset + length;
            if (offset < 0 || offset > cbuf.length || length < 0 || end < 0 || end > cbuf.length) {
                throw new IndexOutOfBoundsException();
            }
            Object object = IDEConsole.this.readLock;
            synchronized (object) {
                boolean eof = false;
                char c = '\u0000';
                do {
                    if (this.nextChar >= this.nChars) {
                        int n = 0;
                        while ((n = this.in.read(this.cb, 0, this.cb.length)) == 0) {
                        }
                        if (n > 0) {
                            this.nChars = n;
                            this.nextChar = 0;
                            if (n < this.cb.length && this.cb[n - 1] != '\n' && this.cb[n - 1] != '\r') {
                                eof = true;
                            }
                        } else {
                            if (off - offset == 0) {
                                return -1;
                            }
                            return off - offset;
                        }
                    }
                    if (this.leftoverLF && cbuf == IDEConsole.this.rcb && this.cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                    this.leftoverLF = false;
                    while (this.nextChar < this.nChars) {
                        int n = off++;
                        char c2 = this.cb[this.nextChar];
                        cbuf[n] = c2;
                        c = c2;
                        this.cb[this.nextChar++] = '\u0000';
                        if (c == '\n') {
                            return off - offset;
                        }
                        if (c == '\r') {
                            if (off == end) {
                                if (cbuf == IDEConsole.this.rcb) {
                                    cbuf = IDEConsole.this.grow();
                                    end = cbuf.length;
                                } else {
                                    this.leftoverLF = true;
                                    return off - offset;
                                }
                            }
                            if (this.nextChar == this.nChars && this.in.ready()) {
                                this.nChars = this.in.read(this.cb, 0, this.cb.length);
                                this.nextChar = 0;
                            }
                            if (this.nextChar < this.nChars && this.cb[this.nextChar] == '\n') {
                                cbuf[off++] = 10;
                                ++this.nextChar;
                            }
                            return off - offset;
                        }
                        if (off != end) continue;
                        if (cbuf == IDEConsole.this.rcb) {
                            cbuf = IDEConsole.this.grow();
                            end = cbuf.length;
                            continue;
                        }
                        return off - offset;
                    }
                } while (!eof);
                return off - offset;
            }
        }
    }
}

