/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.console.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.appwork.console.table.Column;
import org.appwork.utils.StringUtils;

public class Table<Data> {
    private static final String PIPE = "|";
    ArrayList<Column<Data>> columns = new ArrayList();
    private List<Data> rows;
    private String[] sortIds;
    private boolean sortAsc;
    private HashMap<String, Column<Data>> colMap = new HashMap();
    private boolean subheader;
    private boolean footer;
    private boolean showHeader;

    public Table(boolean subheader, boolean footer, boolean showHeader) {
        this.subheader = subheader;
        this.footer = footer;
        this.showHeader = showHeader;
    }

    public Column<Data> addColumn(Column<Data> c) {
        this.columns.add(c);
        this.colMap.put(c.header, c);
        c.index = this.columns.size() - 1;
        return c;
    }

    public String toString() {
        Column<Data> c;
        int i;
        if (this.sortIds != null) {
            Collections.sort(this.rows, new Comparator<Data>(){

                @Override
                public int compare(Data o1, Data o2) {
                    int ret = 0;
                    for (String s : Table.this.sortIds) {
                        if (ret != 0) {
                            return ret;
                        }
                        Column c = (Column)Table.this.colMap.get(s);
                        ret = Table.this.sortAsc ? c.renderer.compare(o1, o2, c) : c.renderer.compare(o2, o1, c);
                    }
                    return ret;
                }
            });
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.columns.size(); ++i) {
            c = this.columns.get(i);
            c.width = this.width(c, i);
        }
        for (i = 0; i < this.columns.size(); ++i) {
            c = this.columns.get(i);
            if (!c.visible) continue;
            if (i > 0) {
                sb.append(" | ");
            } else {
                sb.append("| ");
            }
            if (this.sortIds != null && this.sortIds.length > 0 && this.sortIds[0].equals(c.header)) {
                sb.append(StringUtils.fillPost((this.sortAsc ? "\u25b2" : "\u25bc") + c.header, " ", c.width));
                continue;
            }
            sb.append(StringUtils.fillPost(" " + c.header, " ", c.width));
        }
        sb.append(" |\r\n");
        int totalWidth = sb.length() - 2;
        sb.append(StringUtils.fillPost("", "\u2500", totalWidth));
        sb.append("\r\n");
        if (!this.showHeader) {
            sb.setLength(0);
            sb.insert(0, StringUtils.fillPost("", "\u2500", totalWidth) + "\r\n");
        } else {
            sb.insert(0, StringUtils.fillPost("", "\u2500", totalWidth) + "\r\n");
        }
        if (this.subheader) {
            for (int i2 = 0; i2 < this.columns.size(); ++i2) {
                Column<Data> c2 = this.columns.get(i2);
                if (!c2.visible) continue;
                if (i2 > 0) {
                    sb.append(" | ");
                } else {
                    sb.append("| ");
                }
                if (c2.right) {
                    sb.append(StringUtils.fillPre(String.valueOf(c2.renderer.getSubHeader(this.rows, c2)), " ", c2.width));
                    continue;
                }
                sb.append(StringUtils.fillPost(String.valueOf(c2.renderer.getSubHeader(this.rows, c2)), " ", c2.width));
            }
            sb.append(" |\r\n");
            sb.append(StringUtils.fillPost("", "=", totalWidth) + "\r\n");
        }
        int row = 0;
        for (Data d : this.rows) {
            int maxLines = 1;
            for (int i3 = 0; i3 < this.columns.size(); ++i3) {
                Column<Data> c3 = this.columns.get(i3);
                maxLines = Math.max(maxLines, StringUtils.getLines(String.valueOf(c3.renderer.getString(d, row, c3))).length);
            }
            for (int l = 0; l < maxLines; ++l) {
                for (int i4 = 0; i4 < this.columns.size(); ++i4) {
                    String value;
                    Column<Data> c4 = this.columns.get(i4);
                    if (!c4.visible) continue;
                    String[] lines = StringUtils.getLines(String.valueOf(c4.renderer.getString(d, row, c4)));
                    String string = value = l < lines.length ? lines[l] : "";
                    if (i4 > 0) {
                        sb.append(" | ");
                    } else {
                        sb.append("| ");
                    }
                    if (c4.right) {
                        sb.append(StringUtils.fillPre(value, " ", c4.width));
                        continue;
                    }
                    sb.append(StringUtils.fillPost(value, " ", c4.width));
                }
                sb.append(" |\r\n");
            }
            ++row;
        }
        sb.append(StringUtils.fillPost("", "\u2500", totalWidth));
        if (this.footer) {
            sb.append("\r\n");
            for (int i5 = 0; i5 < this.columns.size(); ++i5) {
                Column<Data> c5 = this.columns.get(i5);
                if (!c5.visible) continue;
                if (i5 > 0) {
                    sb.append(" | ");
                } else {
                    sb.append("| ");
                }
                if (c5.right) {
                    sb.append(StringUtils.fillPre(String.valueOf(c5.renderer.getFooter(this.rows, c5)), " ", c5.width));
                    continue;
                }
                sb.append(StringUtils.fillPost(String.valueOf(c5.renderer.getFooter(this.rows, c5)), " ", c5.width));
            }
            sb.append(" |\r\n");
            sb.append(StringUtils.fillPost("", "=", totalWidth));
        }
        return sb.toString();
    }

    private int width(Column<Data> c, int cIndex) {
        int max;
        int n = max = this.showHeader ? c.header.length() + 1 : 0;
        if (this.footer) {
            max = Math.max(max, String.valueOf(c.renderer.getFooter(this.rows, c)).length());
        }
        if (this.subheader) {
            max = Math.max(max, String.valueOf(c.renderer.getSubHeader(this.rows, c)).length());
        }
        int i = 0;
        for (Data d : this.rows) {
            for (String line : StringUtils.getLines(String.valueOf(c.renderer.getString(d, i++, c)))) {
                max = Math.max(max, line.length());
            }
        }
        return Math.max(c.minWidth, max);
    }

    public void setData(List<Data> dataList) {
        this.rows = dataList;
    }

    public void sortOn(boolean b, String ... columIds) {
        this.sortAsc = b;
        this.sortIds = columIds;
    }
}

