/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.loggingv3.simple.sink;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.appwork.loggingv3.simple.LogRecord2;
import org.appwork.loggingv3.simple.sink.AbstractSink;
import org.appwork.loggingv3.simple.sink.SimpleFormatter;
import org.appwork.utils.StringUtils;

public class LogToStdOutSink
extends AbstractSink {
    protected final PrintStream errOut;
    protected final PrintStream stdOut;
    protected LogRecord2 lastErr;
    protected LogRecord2 lastOut;
    protected final SimpleFormatter.LocalTimeFormat dateOnly = new SimpleFormatter.LocalTimeFormat("dd.MM.yy");
    protected final SimpleFormatter.LocalTimeFormat timeOnly = new SimpleFormatter.LocalTimeFormat("HH:mm:ss.SSS");

    public LogToStdOutSink() {
        this(System.out, System.err);
        this.formatter = new SimpleFormatter(){
            {
                this.offsetForThrownAt = new SimpleFormatter.IntByReference(this, 40);
            }

            @Override
            protected String createPre(LogRecord2 record, String sourceString) {
                StackTraceElement source = record.getThrownAt();
                sourceString = "";
                if (StringUtils.isNotEmpty(source.getFileName()) && source.getLineNumber() >= 0) {
                    sourceString = " (" + source.getFileName() + ":" + source.getLineNumber() + ")";
                }
                sourceString = sourceString + "." + source.getMethodName();
                return 1.fillPre(((SimpleDateFormat)LogToStdOutSink.this.timeOnly.get()).format(new Date(record.timestamp)), " ", this.offsetForTimestamp) + " - " + 1.fillPost("" + this.abbr(String.valueOf(sourceString) + "", this.maxSourceStringLength), " ", this.offsetForThrownAt) + " > ";
            }
        };
    }

    private LogToStdOutSink(PrintStream out, PrintStream err) {
        this.errOut = System.err;
        this.stdOut = System.out;
    }

    @Override
    public synchronized void publish(LogRecord2 record) {
        switch (record.getLevel()) {
            case EXCEPTION: {
                if (this.switchIt(this.lastErr, record)) {
                    this.errOut.println("Err> Date: " + ((SimpleDateFormat)this.dateOnly.get()).format(record.timestamp) + "  Thread " + record.threadID + "/" + record.threadName + " - " + record.getThrownAt().getClassName());
                }
                this.errOut.println(this.format(record));
                this.lastErr = record;
                break;
            }
            default: {
                if (this.switchIt(this.lastOut, record)) {
                    this.stdOut.println("Std> Date: " + ((SimpleDateFormat)this.dateOnly.get()).format(record.timestamp) + "  Thread " + record.threadID + "/" + record.threadName + " - " + record.getThrownAt().getClassName());
                }
                this.stdOut.println(this.format(record));
                this.lastOut = record;
            }
        }
    }

    protected boolean switchIt(LogRecord2 last, LogRecord2 record) {
        if (last == null) {
            return true;
        }
        if (last.threadID != record.threadID) {
            return true;
        }
        SimpleDateFormat format = (SimpleDateFormat)this.dateOnly.get();
        if (!format.format(record.timestamp).equals(format.format(last.timestamp))) {
            return true;
        }
        return !record.getThrownAt().getClassName().equals(last.getThrownAt().getClassName());
    }
}

