/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.moncompare.fromjson;

import org.appwork.moncompare.BadFormatException;
import org.appwork.moncompare.Condition;
import org.appwork.moncompare.fromjson.FlexiConditionMapper;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.ParsingError;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;

public class FlexiCondition {
    public static Condition parse(String json) throws BadFormatException {
        return FlexiCondition.parse(json, false);
    }

    public static Condition parse(String json, boolean convertDollar) throws BadFormatException {
        Class<Condition> target = Condition.class;
        return FlexiCondition.parse(json, convertDollar, target);
    }

    public static <T extends Condition> T parse(String json, final boolean convertDollar, Class<T> target) throws BadFormatException {
        try {
            FlexiJSonNode jsonNode = new FlexiJSONParser(json){

                @Override
                protected void throwParserException(ParsingError error, Object path, Throwable cause, FlexiJSonNode parent, FlexiJSonNode value) throws FlexiParserException {
                    switch (error) {
                        case ERROR_NUMBERFORMAT_BINARY: 
                        case ERROR_NUMBERFORMAT_HEXADECIMAL: 
                        case ERROR_NUMBERFORMAT_LEADING_PLUS: 
                        case ERROR_NUMBERFORMAT_OCTAL: 
                        case ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES: 
                        case ERROR_STRING_VALUE_WITH_SINGLE_QUOTES: 
                        case ERROR_STRING_TOKEN_WITHOUT_QUOTES: 
                        case ERROR_STRING_VALUE_WITHOUT_QUOTES: 
                        case ERROR_KEY_WITHOUT_QUOTES: 
                        case ERROR_KEY_WITH_SINGLE_QUOTES: {
                            return;
                        }
                    }
                    super.throwParserException(error, path, cause, parent, value);
                }

                @Override
                protected String modifyKey(String keyString) {
                    if (convertDollar) {
                        keyString = keyString.replaceAll("^\\$\\$", "\u00a7\u00a7").replaceAll("^\\$", "\u00a7");
                    }
                    return super.modifyKey(keyString);
                }

                @Override
                public FlexiJSonValue createJSonValue(String value) {
                    if (value == null) {
                        return super.createJSonValue(value);
                    }
                    if (convertDollar) {
                        value = value.replaceAll("^\\$\\$", "\u00a7\u00a7").replaceAll("^\\$", "\u00a7");
                    }
                    return super.createJSonValue(value);
                }
            }.setDebug(new StringBuilder()).parse();
            return (T)((Condition)new FlexiConditionMapper(target).jsonToObject(jsonNode, new SimpleTypeRef(target)));
        }
        catch (FlexiParserException e) {
            throw new BadFormatException(e);
        }
        catch (FlexiMapperException e) {
            throw new BadFormatException(e);
        }
    }
}

