/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.remoteapi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.remoteapi.DefaultDocsPageFactory;
import org.appwork.remoteapi.HelpMethod;
import org.appwork.remoteapi.InterfaceHandler;
import org.appwork.remoteapi.ParseException;
import org.appwork.remoteapi.RemoteAPIInterface;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.RemoteAPIResponse;
import org.appwork.remoteapi.ResponseWrapper;
import org.appwork.remoteapi.annotations.AllowResponseAccess;
import org.appwork.remoteapi.annotations.ApiAuthLevel;
import org.appwork.remoteapi.annotations.ApiNamespace;
import org.appwork.remoteapi.annotations.ApiSessionRequired;
import org.appwork.remoteapi.exceptions.ApiCommandNotAvailable;
import org.appwork.remoteapi.exceptions.AuthException;
import org.appwork.remoteapi.exceptions.BadParameterException;
import org.appwork.remoteapi.exceptions.BasicRemoteAPIException;
import org.appwork.remoteapi.exceptions.InternalApiException;
import org.appwork.remoteapi.exceptions.RemoteAPIException;
import org.appwork.remoteapi.responsewrapper.DataObject;
import org.appwork.storage.JSonMapperException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.Regex;
import org.appwork.utils.net.ChunkedOutputStream;
import org.appwork.utils.net.CountingOutputStream;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.NullOutputStream;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.handler.HttpRequestHandler;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HTTPBridge;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.appwork.utils.reflection.Clazz;

public class RemoteAPI
implements HttpRequestHandler {
    static final Pattern INTF = Pattern.compile("/((.+)/)?(.+)$");
    private HashMap<String, InterfaceHandler<RemoteAPIInterface>> interfaces = new HashMap();
    private DefaultDocsPageFactory helpBuilder;

    public static Object convert(String stringValue, Type type) {
        boolean isQuotedStringValue;
        boolean bl = isQuotedStringValue = stringValue.startsWith("\"") && stringValue.endsWith("\"");
        if ((type == String.class || Clazz.isEnum(type)) && !isQuotedStringValue) {
            if ("null".equals(stringValue)) {
                return null;
            }
            String jsonStringValue = JSonStorage.serializeToJson(stringValue);
            return RemoteAPI.convert(jsonStringValue, type);
        }
        try {
            Object restoredValue = JSonStorage.restoreFromString(stringValue, new TypeRef(type){});
            if (Clazz.isPrimitive(type)) {
                return ReflectionUtils.cast(restoredValue, type);
            }
            return restoredValue;
        }
        catch (JSonMapperException e) {
            if (!isQuotedStringValue) {
                if (Clazz.isEnum(type)) {
                    String jsonStringValue = JSonStorage.serializeToJson(stringValue);
                    return RemoteAPI.convert(jsonStringValue, type);
                }
                if (type == String.class) {
                    String jsonStringValue = JSonStorage.serializeToJson(stringValue);
                    return RemoteAPI.convert(jsonStringValue, type);
                }
                if (type == Object.class) {
                    String jsonStringValue = JSonStorage.serializeToJson(stringValue);
                    return RemoteAPI.convert(jsonStringValue, type);
                }
            }
            throw e;
        }
    }

    protected HTTPBridge getHTTPBridge(RemoteAPIRequest request, RemoteAPIResponse response) {
        HttpRequest httpRequest;
        if (request != null && (httpRequest = request.getHttpRequest()) != null) {
            return httpRequest.getBridge();
        }
        return null;
    }

    @Deprecated
    public static OutputStream getOutputStream(RemoteAPIResponse response, final RemoteAPIRequest request, boolean gzip, final boolean wrapJQuery) throws IOException {
        OutputStream uos;
        GZIPOutputStream out;
        boolean chunked;
        response.getResponseHeaders().add(new HTTPHeader("Cache-Control", "no-store, no-cache"));
        response.getResponseHeaders().add(new HTTPHeader("Content-Type", "application/json"));
        HTTPBridge bridge = response.getRemoteAPI().getHTTPBridge(request, response);
        if (bridge == null || bridge.canHandleChunkedEncoding(request.getHttpRequest(), response.getHttpResponse())) {
            chunked = true;
            response.getResponseHeaders().add(new HTTPHeader("Transfer-Encoding", "chunked"));
        } else {
            chunked = false;
        }
        if (gzip) {
            response.getResponseHeaders().add(new HTTPHeader("Content-Encoding", "gzip"));
        }
        response.setResponseCode(HTTPConstants.ResponseCode.SUCCESS_OK);
        OutputStream os = chunked ? new ChunkedOutputStream(response.getOutputStream(true)) : response.getOutputStream(true);
        if (gzip) {
            out = new GZIPOutputStream(os);
            uos = out;
        } else {
            out = null;
            uos = os;
        }
        return new OutputStream(){
            boolean wrapperHeader;
            boolean wrapperEnd;
            {
                this.wrapperHeader = wrapJQuery && request != null && request.getJqueryCallback() != null;
                this.wrapperEnd = wrapJQuery && request != null && request.getJqueryCallback() != null;
            }

            @Override
            public void close() throws IOException {
                this.wrapperEnd();
                if (out != null) {
                    out.finish();
                    out.flush();
                }
                uos.close();
            }

            @Override
            public void flush() throws IOException {
                uos.flush();
            }

            private void wrapperEnd() throws UnsupportedEncodingException, IOException {
                if (this.wrapperEnd) {
                    uos.write(")".getBytes("UTF-8"));
                    this.wrapperEnd = false;
                }
            }

            private void wrapperHeader() throws UnsupportedEncodingException, IOException {
                if (this.wrapperHeader) {
                    uos.write(request.getJqueryCallback().getBytes("UTF-8"));
                    uos.write("(".getBytes("UTF-8"));
                    this.wrapperHeader = false;
                }
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.wrapperHeader();
                uos.write(b);
            }

            @Override
            public void write(int b) throws IOException {
                this.wrapperHeader();
                uos.write(b);
            }
        };
    }

    public static boolean gzip(HttpRequest request) {
        String value;
        HTTPHeader acceptEncoding = request.getRequestHeaders().get("Accept-Encoding");
        return acceptEncoding != null && (value = acceptEncoding.getValue()) != null && value.contains("gzip");
    }

    public static boolean deflate(HttpRequest request) {
        String value;
        HTTPHeader acceptEncoding = request.getRequestHeaders().get("Accept-Encoding");
        return acceptEncoding != null && (value = acceptEncoding.getValue()) != null && value.contains("deflate");
    }

    public static boolean deflate(RemoteAPIRequest request) {
        return RemoteAPI.deflate(request.getHttpRequest());
    }

    public static boolean gzip(RemoteAPIRequest request) {
        return RemoteAPI.gzip(request.getHttpRequest());
    }

    protected void _handleRemoteAPICall(RemoteAPIRequest request, RemoteAPIResponse response) throws BasicRemoteAPIException {
        block17: {
            Object responseData = null;
            Method method = request.getMethod();
            try {
                if (method == null) {
                    System.out.println("No API Method Found: " + request.getRequestedURL() + " Parameter: " + request.getParameters().length);
                    throw new ApiCommandNotAvailable(request.getRequestedURL());
                }
                this.authenticate(method, request, response);
                Object[] parameters = new Object[method.getParameterTypes().length];
                boolean methodHasReturnTypeAndAResponseParameter = false;
                boolean methodHasResponseParameter = false;
                int count = 0;
                for (int i = 0; i < parameters.length; ++i) {
                    if (RemoteAPIRequest.class.isAssignableFrom(method.getParameterTypes()[i])) {
                        parameters[i] = request;
                        continue;
                    }
                    if (RemoteAPIResponse.class.isAssignableFrom(method.getParameterTypes()[i])) {
                        methodHasResponseParameter = true;
                        if (method.getAnnotation(AllowResponseAccess.class) != null) {
                            methodHasReturnTypeAndAResponseParameter = true;
                        }
                        parameters[i] = response;
                        continue;
                    }
                    try {
                        String json = request.getParameters()[count];
                        Type type = method.getGenericParameterTypes()[i];
                        parameters[i] = this.jsonToParameterObject(json, type);
                    }
                    catch (BasicRemoteAPIException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new BadParameterException(e, request.getParameters()[count]);
                    }
                    ++count;
                }
                try {
                    responseData = request.getIface().invoke(method, parameters);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                if (methodHasResponseParameter && !methodHasReturnTypeAndAResponseParameter) {
                    return;
                }
                this.writeStringResponse(responseData, method, request, response);
            }
            catch (BasicRemoteAPIException e) {
                if (e.getRequest() == null) {
                    e.setRequest(request);
                }
                if (e.getResponse() == null) {
                    e.setResponse(response);
                }
                if ((e = this.preProcessBasicRemoteAPIException(request, response, e)) != null) {
                    throw e;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                InternalApiException internal = new InternalApiException(e);
                internal.setRequest(request);
                internal.setResponse(response);
                BasicRemoteAPIException ret = this.preProcessBasicRemoteAPIException(request, response, internal);
                if (ret == null) break block17;
                throw ret;
            }
        }
    }

    protected Object jsonToParameterObject(String json, Type type) throws RemoteAPIException {
        return RemoteAPI.convert(json, type);
    }

    protected void authenticate(Method method, RemoteAPIRequest request, RemoteAPIResponse response) throws BasicRemoteAPIException {
        if (request.getIface().getSignatureHandler() != null && request.getIface().isSignatureRequired(method)) {
            Object[] parameters = new Object[]{request, response};
            try {
                try {
                    Object responseData = request.getIface().invoke(request.getIface().getSignatureHandler(), parameters);
                    if (!Boolean.TRUE.equals(responseData)) {
                        throw new AuthException();
                    }
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (BasicRemoteAPIException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new InternalApiException(e);
            }
        }
    }

    public RemoteAPIRequest createRemoteAPIRequestObject(HttpRequest request) throws BasicRemoteAPIException {
        RemoteAPIRequest ret;
        Object preData = this.prepareRawRequest(request);
        this.validateRequest(request);
        RemoteAPIMethod remoteAPIMethod = this.getRemoteAPIMethod(request);
        if (remoteAPIMethod == null) {
            return null;
        }
        ParsedParameters parsedParameters = this.parseParameters(request);
        try {
            ret = this.createRemoteAPIRequestObject(request, preData, remoteAPIMethod.getMethodName(), remoteAPIMethod.getInterfaceHandler(), parsedParameters);
        }
        catch (IOException e) {
            throw new BasicRemoteAPIException(e);
        }
        this.validateRequest(ret);
        return ret;
    }

    public ParsedParameters parseParameters(HttpRequest request) throws BasicRemoteAPIException {
        ArrayList<String> parameters = new ArrayList<String>();
        String jqueryCallback = null;
        for (KeyValuePair param : request.getRequestedURLParameters()) {
            if (param.key != null) {
                if ("callback".equalsIgnoreCase(param.key)) {
                    jqueryCallback = param.value;
                    continue;
                }
                if ("signature".equalsIgnoreCase(param.key) || "rid".equalsIgnoreCase(param.key)) continue;
            }
            parameters.add(param.value);
        }
        if (request instanceof PostRequest) {
            try {
                List<KeyValuePair> ret = ((PostRequest)request).getPostParameter();
                if (ret != null) {
                    for (KeyValuePair param : ret) {
                        if (param.key != null && "callback".equalsIgnoreCase(param.key)) {
                            jqueryCallback = param.value;
                            continue;
                        }
                        parameters.add(param.value);
                    }
                }
            }
            catch (Throwable e) {
                if (e instanceof BasicRemoteAPIException) {
                    throw (BasicRemoteAPIException)e;
                }
                if (e.getCause() instanceof BasicRemoteAPIException) {
                    throw (BasicRemoteAPIException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }
        return new ParsedParameters(parameters, jqueryCallback);
    }

    protected Object prepareRawRequest(HttpRequest request) {
        return null;
    }

    public RemoteAPIRequest createRemoteAPIRequestObject(HttpRequest request, Object extractedData, String method, InterfaceHandler<?> interfaceHandler, ParsedParameters parsedParameters) throws IOException, BasicRemoteAPIException {
        return new RemoteAPIRequest(interfaceHandler, method, parsedParameters.parameters.toArray(new String[0]), request, parsedParameters.jqueryCallback);
    }

    protected RemoteAPIResponse createRemoteAPIResponseObject(RemoteAPIRequest request, HttpResponse response) throws IOException {
        return new RemoteAPIResponse(response, this);
    }

    public RemoteAPIMethod getRemoteAPIMethod(HttpRequest request) throws BasicRemoteAPIException {
        String path = this.getRequestPathWithoutNamespace(request);
        String[] intf = new Regex(path, INTF).getRow(0);
        if (intf == null || intf.length != 3) {
            if ("/".equals(path)) {
                intf = new String[]{"", "", ""};
            } else {
                return null;
            }
        }
        if (intf[2] != null && intf[2].endsWith("/")) {
            intf[1] = intf[2].substring(0, intf[2].length() - 1);
            intf[2] = "";
        }
        if (intf[1] == null) {
            intf[1] = "";
        }
        String namespace = intf[1];
        String methodName = intf[2];
        if (this.isHelpRequest(methodName)) {
            try {
                return new HelpMethod(this.getHelpBuilder());
            }
            catch (Throwable e) {
                throw new WTFException(e);
            }
        }
        InterfaceHandler<RemoteAPIInterface> ret = this.getInterfaceByNamespace(namespace);
        if (ret != null) {
            return new RemoteAPIMethod(namespace, ret, methodName);
        }
        return null;
    }

    protected String getRequestPathWithoutNamespace(HttpRequest request) {
        String requestPath = request.getRequestedPath();
        int index = requestPath.lastIndexOf("/", requestPath.lastIndexOf("/") - 1);
        if (index > 0) {
            for (String nameSpace : this.interfaces.keySet()) {
                if (!requestPath.startsWith("/" + nameSpace + "/")) continue;
                return requestPath;
            }
            return requestPath.substring(index);
        }
        return requestPath;
    }

    protected InterfaceHandler<RemoteAPIInterface> getInterfaceByNamespace(String namespace) {
        InterfaceHandler<RemoteAPIInterface> ret = this.interfaces.get(namespace);
        return ret;
    }

    public ArrayList<Class<? extends RemoteAPIInterface>> listInterfaces() {
        HashSet<Class<RemoteAPIInterface>> ret = new HashSet<Class<RemoteAPIInterface>>();
        for (Map.Entry<String, InterfaceHandler<RemoteAPIInterface>> es : this.interfaces.entrySet()) {
            for (Class<RemoteAPIInterface> iface : es.getValue().getInterfaceClasses()) {
                ret.add(iface);
            }
        }
        return new ArrayList<Class<? extends RemoteAPIInterface>>(ret);
    }

    public synchronized DefaultDocsPageFactory getHelpBuilder() {
        try {
            if (this.helpBuilder == null) {
                this.helpBuilder = this.createHelpBuilder();
            }
            return this.helpBuilder;
        }
        catch (NoSuchMethodException e) {
            throw new WTFException(e);
        }
    }

    protected DefaultDocsPageFactory createHelpBuilder() throws NoSuchMethodException {
        DefaultDocsPageFactory helpBuilder = new DefaultDocsPageFactory(this);
        return helpBuilder;
    }

    protected boolean isHelpRequest(String methodName) {
        return "help".equalsIgnoreCase(methodName);
    }

    protected Object handleVoidMethods(Object responseData, Method method) {
        if (Clazz.isVoid(method.getReturnType())) {
            responseData = "";
        }
        return responseData;
    }

    protected boolean isAllowed(RemoteAPIRequest request, RemoteAPIResponse response) {
        return true;
    }

    protected String jQueryWrap(RemoteAPIRequest request, String text) {
        if (request.getJqueryCallback() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(request.getJqueryCallback());
            sb.append("(");
            sb.append(text);
            sb.append(");");
            text = sb.toString();
        }
        return text;
    }

    @Override
    public boolean onGetRequest(GetRequest request, HttpResponse response) throws BasicRemoteAPIException {
        RemoteAPIRequest apiRequest = this.createRemoteAPIRequestObject(request);
        if (apiRequest == null) {
            return this.onUnknownRequest(request, response);
        }
        try {
            this._handleRemoteAPICall(apiRequest, this.createRemoteAPIResponseObject(apiRequest, response));
        }
        catch (IOException e) {
            throw new BasicRemoteAPIException(e);
        }
        return true;
    }

    @Override
    public boolean onPostRequest(PostRequest request, HttpResponse response) throws BasicRemoteAPIException {
        RemoteAPIRequest apiRequest = this.createRemoteAPIRequestObject(request);
        if (apiRequest == null) {
            return this.onUnknownRequest(request, response);
        }
        try {
            this._handleRemoteAPICall(apiRequest, this.createRemoteAPIResponseObject(apiRequest, response));
        }
        catch (IOException e) {
            throw new BasicRemoteAPIException(e);
        }
        return true;
    }

    protected boolean onUnknownRequest(HttpRequest request, HttpResponse response) {
        return false;
    }

    protected BasicRemoteAPIException preProcessBasicRemoteAPIException(RemoteAPIRequest request, RemoteAPIResponse response, BasicRemoteAPIException e) {
        return e;
    }

    protected HashMap<String, InterfaceHandler<RemoteAPIInterface>> getHandlerMap() {
        return new HashMap<String, InterfaceHandler<RemoteAPIInterface>>(this.interfaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RemoteAPIInterface x) throws ParseException {
        HashSet interfaces = new HashSet();
        RemoteAPI remoteAPI = this;
        synchronized (remoteAPI) {
            HashMap<String, InterfaceHandler<RemoteAPIInterface>> linterfaces = new HashMap<String, InterfaceHandler<RemoteAPIInterface>>(this.interfaces);
            for (Class<?> clazz = x.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                block12: for (Class<?> c : clazz.getInterfaces()) {
                    if (!RemoteAPIInterface.class.isAssignableFrom(c)) continue;
                    for (Class clazz2 : interfaces) {
                        if (!c.isAssignableFrom(clazz2)) continue;
                        continue block12;
                    }
                    interfaces.add(c);
                    String namespace = c.getName();
                    ApiNamespace apiNamespace = c.getAnnotation(ApiNamespace.class);
                    if (apiNamespace != null) {
                        namespace = apiNamespace.value();
                    }
                    try {
                        try {
                            Method method = x.getClass().getMethod("getAPINamespace", Class.class);
                            if (method != null) {
                                namespace = (String)method.invoke((Object)x, c);
                            }
                        }
                        catch (NoSuchMethodException method) {
                            // empty catch block
                        }
                        int defaultAuthLevel = 0;
                        ApiAuthLevel b = c.getAnnotation(ApiAuthLevel.class);
                        if (b != null) {
                            defaultAuthLevel = b.value();
                        }
                        LogV3.info("Try to register API namespace /" + namespace + " = " + c);
                        InterfaceHandler<RemoteAPIInterface> handler = linterfaces.get(namespace);
                        if (handler == null) {
                            handler = this.createHandler(x, c, defaultAuthLevel);
                            handler.setSessionRequired(c.getAnnotation(ApiSessionRequired.class) != null);
                            linterfaces.put(namespace, handler);
                            continue;
                        }
                        if (handler.isSessionRequired() != (c.getAnnotation(ApiSessionRequired.class) != null)) {
                            throw new WTFException("Session API Interface Mismatch");
                        }
                        handler.add(c, x, defaultAuthLevel);
                    }
                    catch (IllegalAccessException e) {
                        throw new ParseException(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParseException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ParseException(e);
                    }
                    catch (SecurityException e) {
                        throw new ParseException(e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new ParseException(e);
                    }
                }
                this.interfaces = linterfaces;
            }
        }
    }

    protected InterfaceHandler<RemoteAPIInterface> createHandler(RemoteAPIInterface x, Class<?> c, int defaultAuthLevel) throws ParseException, NoSuchMethodException {
        return InterfaceHandler.create(c, x, defaultAuthLevel);
    }

    public void sendText(RemoteAPIRequest request, RemoteAPIResponse response, String text) throws UnsupportedEncodingException, IOException {
        text = this.jQueryWrap(request, text);
        byte[] bytes = text.getBytes("UTF-8");
        response.setResponseCode(HTTPConstants.ResponseCode.SUCCESS_OK);
        response.sendBytes(request, bytes);
    }

    public String toString(RemoteAPIRequest request, RemoteAPIResponse response, Object responseData) {
        return JSonStorage.serializeToJson(new DataObject(responseData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(RemoteAPIInterface x) {
        HashSet interfaces = new HashSet();
        RemoteAPI remoteAPI = this;
        synchronized (remoteAPI) {
            HashMap<String, InterfaceHandler<RemoteAPIInterface>> linterfaces = new HashMap<String, InterfaceHandler<RemoteAPIInterface>>(this.interfaces);
            for (Class<?> clazz = x.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                block4: for (Class<?> c : clazz.getInterfaces()) {
                    if (!RemoteAPIInterface.class.isAssignableFrom(c)) continue;
                    for (Class clazz2 : interfaces) {
                        if (!c.isAssignableFrom(clazz2)) continue;
                        continue block4;
                    }
                    interfaces.add(c);
                    String namespace = c.getName();
                    ApiNamespace apiNamespace = c.getAnnotation(ApiNamespace.class);
                    if (apiNamespace != null) {
                        namespace = apiNamespace.value();
                    }
                    linterfaces.remove(namespace);
                }
            }
            this.interfaces = linterfaces;
        }
    }

    protected void validateRequest(HttpRequest request) throws BasicRemoteAPIException {
    }

    protected void validateRequest(RemoteAPIRequest ret) throws BasicRemoteAPIException {
    }

    public void writeStringResponse(Object responseData, Method method, RemoteAPIRequest request, RemoteAPIResponse response) throws BasicRemoteAPIException {
        try {
            String text = null;
            if (method != null) {
                responseData = this.handleVoidMethods(responseData, method);
            }
            text = method != null && method.getAnnotation(ResponseWrapper.class) != null ? method.getAnnotation(ResponseWrapper.class).value().newInstance().toString(responseData) : this.toString(request, response, responseData);
            this.sendText(request, response, text);
        }
        catch (Throwable e) {
            InternalApiException internal = new InternalApiException(e);
            internal.setRequest(request);
            internal.setResponse(response);
            throw internal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendBytesCompressed(HttpRequest request, HttpResponse response, InputStream is) throws IOException {
        OutputStream os;
        HTTPBridge bridge;
        boolean gzip = RemoteAPI.gzip(request);
        boolean deflate = RemoteAPI.deflate(request) && Application.getJavaVersion() >= 16000000L;
        boolean isHeadRequest = HttpConnection.HttpConnectionType.HEAD.equals((Object)request.getHttpConnectionType());
        if (deflate) {
            response.getResponseHeaders().add(new HTTPHeader("Content-Encoding", "deflate"));
        } else if (gzip) {
            response.getResponseHeaders().add(new HTTPHeader("Content-Encoding", "gzip"));
        }
        HTTPBridge hTTPBridge = bridge = request != null ? request.getBridge() : null;
        if (bridge == null || bridge.canHandleChunkedEncoding(request, response)) {
            response.getResponseHeaders().add(new HTTPHeader("Transfer-Encoding", "chunked"));
            os = new ChunkedOutputStream(response.getOutputStream(true));
        } else {
            os = response.getOutputStream(true);
        }
        if (!isHeadRequest && !isHeadRequest) {
            try {
                if (deflate) {
                    os = new DeflaterOutputStream(os, new Deflater(9, true), false);
                } else if (gzip) {
                    os = new GZIPOutputStream(os);
                }
                IO.readStreamToOutputStream(-1, is, os, false);
            }
            finally {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendBytesCompressed(HttpRequest request, HttpResponse response, byte[] bytes) throws IOException {
        boolean gzip = RemoteAPI.gzip(request);
        boolean deflate = RemoteAPI.deflate(request) && Application.getJavaVersion() >= 16000000L;
        boolean isHeadRequest = HttpConnection.HttpConnectionType.HEAD.equals((Object)request.getHttpConnectionType());
        long contentLength = bytes.length;
        if (!gzip && !deflate || contentLength == 0L) {
            response.getResponseHeaders().add(new HTTPHeader("Content-Length", String.valueOf(bytes.length)));
            OutputStream os = response.getOutputStream(true);
            if (!isHeadRequest) {
                os.write(bytes);
            }
        } else {
            OutputStream os;
            HTTPBridge bridge;
            boolean inMemoryCompressed = false;
            if (contentLength < 0x100000L && (gzip || deflate)) {
                CountingOutputStream cos;
                ByteArrayOutputStream bos;
                if (isHeadRequest) {
                    bos = null;
                    cos = new CountingOutputStream(new NullOutputStream());
                } else {
                    bos = new ByteArrayOutputStream();
                    cos = new CountingOutputStream(bos);
                }
                if (deflate) {
                    DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)cos, new Deflater(9, true), true);
                    out.write(bytes);
                    out.close();
                } else if (gzip) {
                    GZIPOutputStream out = new GZIPOutputStream(cos);
                    out.write(bytes);
                    out.close();
                }
                contentLength = cos.transferedBytes();
                inMemoryCompressed = true;
                if (bos != null && contentLength != (long)(bytes = bos.toByteArray()).length) {
                    throw new IOException("in memory compression failed:" + contentLength + "!=" + bytes.length);
                }
            }
            response.getResponseHeaders().add(new HTTPHeader("Content-Length", String.valueOf(contentLength)));
            if (deflate) {
                response.getResponseHeaders().add(new HTTPHeader("Content-Encoding", "deflate"));
            } else if (gzip) {
                response.getResponseHeaders().add(new HTTPHeader("Content-Encoding", "gzip"));
            }
            HTTPBridge hTTPBridge = bridge = request != null ? request.getBridge() : null;
            if (bridge == null || bridge.canHandleChunkedEncoding(request, response)) {
                response.getResponseHeaders().add(new HTTPHeader("Transfer-Encoding", "chunked"));
                os = new ChunkedOutputStream(response.getOutputStream(true));
            } else {
                os = response.getOutputStream(true);
            }
            if (!isHeadRequest) {
                try {
                    if (!inMemoryCompressed) {
                        if (deflate) {
                            os = new DeflaterOutputStream(os, new Deflater(9, true), false);
                        } else if (gzip) {
                            os = new GZIPOutputStream(os);
                        }
                    }
                    os.write(bytes);
                }
                finally {
                    os.close();
                }
            }
        }
    }

    public static class ParsedParameters {
        public final List<String> parameters;
        public final String jqueryCallback;

        public ParsedParameters(List<String> parameters, String jqueryCallback) {
            this.parameters = Collections.unmodifiableList(parameters);
            this.jqueryCallback = jqueryCallback;
        }
    }

    public static class RemoteAPIMethod {
        protected final InterfaceHandler<?> interfaceHandler;
        protected final String methodName;
        protected final String nameSpace;

        public RemoteAPIMethod(String nameSpace, InterfaceHandler<?> interfaceHandler, String methodName) {
            this.nameSpace = nameSpace;
            this.interfaceHandler = interfaceHandler;
            this.methodName = methodName;
        }

        public final InterfaceHandler<?> getInterfaceHandler() {
            return this.interfaceHandler;
        }

        public final String getMethodName() {
            return this.methodName;
        }

        public final String getNameSpace() {
            return this.nameSpace;
        }
    }
}

