/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.resources;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.config.MinTimeWeakReference;
import org.appwork.storage.config.MinTimeWeakReferenceCleanup;
import org.appwork.swing.components.CheckBoxIcon;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.StringUtils;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.images.Interpolation;

public class Theme
implements MinTimeWeakReferenceCleanup {
    private String path;
    protected final HashMap<String, MinTimeWeakReference<Icon>> imageIconCache = new HashMap();
    private long cacheLifetime = 20000L;
    private String theme;
    private String nameSpace;
    private final boolean doNotLogMissingIcons = "false".equals(System.getProperty("DO_NOT_LOG_MISSING_ICONS_EXCEPTION", "false"));
    private Theme delegate;
    private String defaultPath;
    public static File RESOURCE_HELPER_ROOT;

    public Theme(String namespace) {
        this.setNameSpace(namespace);
        this.setTheme("standard");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(Icon ret, String key) {
        HashMap<String, MinTimeWeakReference<Icon>> hashMap = this.imageIconCache;
        synchronized (hashMap) {
            this.imageIconCache.put(key, new MinTimeWeakReference<Icon>(ret, this.getCacheLifetime(), key, this));
        }
    }

    public void setDelegate(Theme i) {
        this.delegate = i == this ? null : i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        HashMap<String, MinTimeWeakReference<Icon>> hashMap = this.imageIconCache;
        synchronized (hashMap) {
            this.imageIconCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getCached(String key) {
        HashMap<String, MinTimeWeakReference<Icon>> hashMap = this.imageIconCache;
        synchronized (hashMap) {
            MinTimeWeakReference<Icon> cache = this.imageIconCache.get(key);
            if (cache != null) {
                return cache.get();
            }
            return null;
        }
    }

    protected String getCacheKey(Object ... objects) {
        if (objects.length == 1) {
            return objects[0].toString();
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : objects) {
            if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    public long getCacheLifetime() {
        return this.cacheLifetime;
    }

    public Icon getDisabledIcon(Icon _getIcon) {
        return this.getDisabledIcon(null, _getIcon);
    }

    protected Theme getDelegate() {
        return this.delegate;
    }

    public Icon getDisabledIcon(JComponent component, Icon _getIcon) {
        if (_getIcon != null) {
            String key;
            Icon ret = null;
            Theme delegate = this.getDelegate();
            if (delegate != null) {
                ret = delegate.getDisabledIcon(_getIcon);
            }
            if (ret == null && (ret = this.getCached(key = this.getCacheKey(_getIcon, "disabled"))) == null) {
                Icon ico;
                ret = ico = ImageProvider.getDisabledIcon(component, _getIcon);
                ret = this.modify(ret, key);
                this.cache(ret, key);
            }
            return ret;
        }
        return null;
    }

    public Icon getIcon(String relativePath, int size) {
        return this.getIcon(relativePath, size, true);
    }

    public Icon getIcon(String relativePath, int size, boolean useCache) {
        Icon ret = null;
        Theme delegate = this.getDelegate();
        if (delegate != null) {
            ret = delegate.getIcon(relativePath, size, useCache);
        }
        if (ret == null) {
            String key = null;
            if (useCache) {
                key = this.getCacheKey(relativePath, size);
                ret = this.getCached(key);
            }
            if (ret == null) {
                if (StringUtils.equalsIgnoreCase(relativePath, "disabled") || StringUtils.equalsIgnoreCase(relativePath, "checkbox_false")) {
                    ret = CheckBoxIcon.FALSE;
                    if (ret != null) {
                        ret = IconIO.getScaledInstance(ret, size, size);
                    }
                } else if (StringUtils.equalsIgnoreCase(relativePath, "enabled") || StringUtils.equalsIgnoreCase(relativePath, "checkbox_true")) {
                    ret = CheckBoxIcon.TRUE;
                    if (ret != null) {
                        ret = IconIO.getScaledInstance(ret, size, size);
                    }
                } else if (StringUtils.equalsIgnoreCase(relativePath, "checkbox_undefined") && (ret = CheckBoxIcon.UNDEFINED) != null) {
                    ret = IconIO.getScaledInstance(ret, size, size);
                }
                if (ret == null) {
                    URL url = this.lookupImageUrl(relativePath, size);
                    ret = IconIO.getImageIcon(url, size);
                    ret = this.modify(ret, relativePath);
                    if (url == null && this.doNotLogMissingIcons) {
                        LogV3.log(new Exception("Icon missing: " + this.getPath("images/", relativePath, ".png", false)));
                    }
                }
                if (useCache && ret != null) {
                    this.cache(ret, key);
                }
            }
        }
        return ret;
    }

    protected URL lookupImageUrl(String relativePath, int size) {
        URL url = this.getURL("images/", relativePath + "_" + size, ".png", false);
        if (url == null) {
            url = this.getURL("images/", relativePath, ".png", false);
        }
        if (url == null && (url = this.getURL("images/", relativePath, ".svg", false)) != null && IconIO.getSvgFactory() == null) {
            url = null;
        }
        if (url == null) {
            url = this.getURL("images/", relativePath + "_" + size, ".png", true);
        }
        if (url == null) {
            url = this.getURL("images/", relativePath, ".png", true);
        }
        if (url == null && (url = this.getURL("images/", relativePath, ".svg", true)) != null && IconIO.getSvgFactory() == null) {
            url = null;
        }
        return url;
    }

    protected void copy(File check, File to) throws IOException {
        to.getParentFile().mkdirs();
        IO.copyFile(check, to);
        this.copy(check, to, ".txt");
        this.copy(check, to, ".license");
        this.copy(check, to, ".info");
        this.copy(check, to, ".nfo");
    }

    protected void copy(File check, File to, String ext) throws IOException {
        File nfo = new File(check.getAbsolutePath() + ext);
        File t = new File(to.getAbsolutePath() + ext);
        if (nfo.exists() && !t.exists()) {
            t.getParentFile().mkdirs();
            IO.copyFile(nfo, t);
        }
    }

    protected Icon modify(Icon ret, String relativePath) {
        return ret;
    }

    public Image getImage(String relativePath, int size) {
        return this.getImage(relativePath, size, false);
    }

    public Image getImage(String key, int size, boolean useCache) {
        Image image = null;
        Theme delegate = this.getDelegate();
        if (delegate != null) {
            image = delegate.getImage(key, size, useCache);
        }
        if (image == null) {
            image = IconIO.toBufferedImage(this.getIcon(key, size, useCache));
        }
        return image;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getPath() {
        return this.path;
    }

    private String getPath(String pre, String path, String ext, boolean fallback) {
        StringBuilder sb = new StringBuilder();
        sb.append(fallback ? this.defaultPath : this.path);
        sb.append(pre);
        sb.append(path);
        sb.append(ext);
        return sb.toString();
    }

    public Icon getScaledInstance(Icon imageIcon, int size) {
        String key;
        Icon ret = null;
        Theme delegate = this.getDelegate();
        if (delegate != null) {
            ret = delegate.getScaledInstance(imageIcon, size);
        }
        if (ret == null && (ret = this.getCached(key = this.getCacheKey(imageIcon, size))) == null) {
            ret = IconIO.getScaledInstance(imageIcon, size, size, Interpolation.BILINEAR);
            this.cache(ret, key);
        }
        return ret;
    }

    public String getText(String string) {
        String ret = null;
        Theme delegate = this.getDelegate();
        if (delegate != null) {
            ret = delegate.getText(string);
        }
        if (ret == null) {
            try {
                URL url = this.getURL("", string, "");
                if (url != null) {
                    ret = IO.readURLToString(url);
                }
            }
            catch (IOException e) {
                LogV3.log(e);
            }
        }
        return ret;
    }

    public String getTheme() {
        return this.theme;
    }

    public URL getURL(String pre, String relativePath, String ext) {
        URL ret = this.getURL(pre, relativePath, ext, false);
        if (ret == null) {
            ret = this.getURL(pre, relativePath, ext, true);
        }
        return ret;
    }

    private URL getURL(String pre, String relativePath, String ext, boolean fallback) {
        URL url = null;
        Theme delegate = this.getDelegate();
        if (delegate != null) {
            url = delegate.getURL(pre, relativePath, ext, fallback);
        }
        if (url == null) {
            String path = this.getPath(pre, relativePath, ext, fallback);
            try {
                File file = Application.getResource(path);
                if (file.exists()) {
                    url = file.toURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (url == null) {
                url = Theme.class.getResource(path);
            }
        }
        return url;
    }

    public File getImagesDirectory() {
        File ret = null;
        Theme delegate = this.getDelegate();
        if (delegate != null) {
            ret = delegate.getImagesDirectory();
        }
        if (ret == null) {
            ret = Application.getResource(this.getPath("images/", "image", ".file", false)).getParentFile();
        }
        return ret;
    }

    public boolean hasIcon(String string) {
        boolean hasIcon = false;
        Theme delegate = this.getDelegate();
        if (delegate != null) {
            hasIcon = delegate.hasIcon(string);
        }
        if (!hasIcon) {
            hasIcon = this.lookupImageUrl(string, -1) != null;
        }
        return hasIcon;
    }

    public URL getIconURL(String string) {
        URL ret = null;
        Theme delegate = this.getDelegate();
        if (delegate != null) {
            ret = delegate.getIconURL(string);
        }
        if (ret == null) {
            ret = this.lookupImageUrl(string, -1);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMinTimeWeakReferenceCleanup(MinTimeWeakReference<?> minTimeWeakReference) {
        HashMap<String, MinTimeWeakReference<Icon>> hashMap = this.imageIconCache;
        synchronized (hashMap) {
            this.imageIconCache.remove(minTimeWeakReference.getID());
        }
    }

    public void setCacheLifetime(long cacheLifetime) {
        this.cacheLifetime = cacheLifetime;
    }

    public void setNameSpace(String nameSpace) {
        if (!StringUtils.equals(this.getNameSpace(), nameSpace) && StringUtils.isNotEmpty(nameSpace)) {
            this.nameSpace = nameSpace;
            this.updatePath();
            this.clearCache();
        }
    }

    private void updatePath() {
        this.path = "/themes/" + this.getTheme() + "/" + this.getNameSpace();
        this.defaultPath = "/themes/standard/" + this.getNameSpace();
    }

    public void setTheme(String theme) {
        if (!StringUtils.equals(this.getTheme(), theme) && StringUtils.isNotEmpty(theme)) {
            this.theme = theme;
            this.updatePath();
            this.clearCache();
        }
    }
}

