/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.shutdown;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.appwork.loggingv3.LogV3;
import org.appwork.shutdown.BasicShutdownRequest;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.shutdown.ShutdownVetoException;
import org.appwork.shutdown.ShutdownVetoListener;
import org.appwork.utils.Application;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.Exceptions;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.logging2.LogInterface;

public class ShutdownController
extends Thread {
    private static final ShutdownController INSTANCE = new ShutdownController();
    private final ArrayList<ShutdownEvent> hooks = new ArrayList();
    private final ArrayList<ShutdownEvent> originalShutdownHooks = new ArrayList();
    private final List<ShutdownVetoListener> vetoListeners = new ArrayList<ShutdownVetoListener>();
    private int exitCode = 0;
    private final AtomicInteger requestedShutDowns = new AtomicInteger(0);
    private volatile Thread exitThread = null;
    private final AtomicBoolean shutDown = new AtomicBoolean(false);
    private final AtomicBoolean shutDownHookRunning = new AtomicBoolean(false);
    protected volatile ShutdownRequest shutdownRequest;
    private final boolean hooksDelegatedFlag;
    private LogInterface logger;

    public static ShutdownController getInstance() {
        return INSTANCE;
    }

    public final boolean isHooksDelegated() {
        return this.hooksDelegatedFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShutdownController() {
        super(ShutdownController.class.getSimpleName());
        boolean hooksDelegatedFlag = false;
        try {
            Runtime.getRuntime().addShutdownHook(this);
            Class<?> clazz = Class.forName("java.lang.ApplicationShutdownHooks");
            synchronized (clazz) {
                Field field = ReflectionUtils.getField("java.lang.ApplicationShutdownHooks", "hooks", null, Map.class);
                field.setAccessible(true);
                Map hooks = (Map)field.get(null);
                if (hooks != null) {
                    IdentityHashMap<Thread, Thread> hookDelegater = new IdentityHashMap<Thread, Thread>(){
                        private static final long serialVersionUID = 8334628124340671103L;

                        @Override
                        public Thread put(Thread key, Thread value) {
                            ShutdownEventWrapper hook = new ShutdownEventWrapper(value);
                            ShutdownController.this.addShutdownEvent(hook);
                            return null;
                        }

                        @Override
                        public Thread remove(Object key) {
                            if (ShutdownController.this.removeShutdownEvent(new ShutdownEventWrapper((Thread)key))) {
                                return (Thread)key;
                            }
                            return null;
                        }
                    };
                    for (Thread hook : hooks.keySet()) {
                        if (this == hook) continue;
                        this.addShutdownEvent(new ShutdownEventWrapper(hook));
                    }
                    field.set(null, hookDelegater);
                    hooksDelegatedFlag = true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.hooksDelegatedFlag = hooksDelegatedFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownEvent(ShutdownEvent event) {
        if (this.isAlive()) {
            IllegalStateException e = new IllegalStateException("Cannot add hook during shutdown:" + event);
            if (event.supportsIllegalStateException()) {
                throw e;
            }
            LogV3.log(e);
            return;
        }
        if (event instanceof ShutdownEventWrapper) {
            ArrayList<ShutdownEvent> arrayList = this.originalShutdownHooks;
            synchronized (arrayList) {
                if (!this.originalShutdownHooks.contains(event)) {
                    this.originalShutdownHooks.add(event);
                }
            }
        }
        ArrayList<ShutdownEvent> arrayList = this.hooks;
        synchronized (arrayList) {
            int i = 0;
            for (ShutdownEvent next : this.hooks) {
                if (next.getHookPriority() <= event.getHookPriority()) {
                    this.hooks.add(i, event);
                    return;
                }
                ++i;
            }
            this.hooks.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownVetoListener(ShutdownVetoListener listener) {
        List<ShutdownVetoListener> list = this.vetoListeners;
        synchronized (list) {
            if (this.vetoListeners.contains(listener)) {
                this.log("Add ShutdownVetoListener:" + listener + ":" + false);
                return;
            }
            this.vetoListeners.add(listener);
            this.log("Add ShutdownVetoListener:" + listener + ":" + true);
            try {
                Collections.sort(this.vetoListeners, new Comparator<ShutdownVetoListener>(){

                    @Override
                    public int compare(ShutdownVetoListener o1, ShutdownVetoListener o2) {
                        return CompareUtils.compare(o1.getShutdownVetoPriority(), o2.getShutdownVetoPriority());
                    }
                });
            }
            catch (Throwable e) {
                LogV3.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShutdownRequest collectVetos(ShutdownRequest request) {
        ShutdownVetoListener[] shutdownVetoListenerArray = this.vetoListeners;
        synchronized (this.vetoListeners) {
            ShutdownVetoListener[] localList = this.vetoListeners.toArray(new ShutdownVetoListener[0]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (ShutdownVetoListener v : localList) {
                try {
                    if (request != null && !request.askForVeto(v)) continue;
                    v.onShutdownVetoRequest(request);
                }
                catch (ShutdownVetoException e) {
                    if (request == null) continue;
                    try {
                        request.addVeto(e);
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return request;
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public ShutdownRequest getShutdownRequest() {
        return this.shutdownRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShutdownVetoListener> getShutdownVetoListeners() {
        List<ShutdownVetoListener> list = this.vetoListeners;
        synchronized (list) {
            return new ArrayList<ShutdownVetoListener>(this.vetoListeners);
        }
    }

    private String getStackTrace(Thread thread) {
        try {
            StackTraceElement[] st = thread.getStackTrace();
            StringBuilder sb = new StringBuilder("");
            for (StackTraceElement element : st) {
                sb.append(element);
                sb.append("\r\n");
            }
            return sb.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasShutdownEvent(ShutdownEvent event) {
        if (event == null) {
            return false;
        }
        if (event instanceof ShutdownEventWrapper) {
            ArrayList<ShutdownEvent> arrayList = this.originalShutdownHooks;
            synchronized (arrayList) {
                return this.originalShutdownHooks.contains(event);
            }
        }
        ArrayList<ShutdownEvent> arrayList = this.hooks;
        synchronized (arrayList) {
            return this.hooks.contains(event);
        }
    }

    public boolean isShutDownRequested() {
        return this.requestedShutDowns.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeShutdownEvent(ShutdownEvent event) {
        if (event == null) {
            return false;
        }
        if (this.isAlive()) {
            IllegalStateException e = new IllegalStateException("Cannot remove hook during shutdown:" + event);
            if (event.supportsIllegalStateException()) {
                throw e;
            }
            LogV3.log(e);
            return false;
        }
        if (event instanceof ShutdownEventWrapper) {
            ArrayList<ShutdownEvent> e = this.originalShutdownHooks;
            synchronized (e) {
                return this.originalShutdownHooks.remove(event);
            }
        }
        boolean ret = false;
        ArrayList<ShutdownEvent> arrayList = this.hooks;
        synchronized (arrayList) {
            Iterator<ShutdownEvent> it = this.hooks.iterator();
            while (it.hasNext()) {
                ShutdownEvent next = it.next();
                if (next != event) continue;
                it.remove();
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownVetoListener(ShutdownVetoListener listener) {
        List<ShutdownVetoListener> list = this.vetoListeners;
        synchronized (list) {
            boolean ret = this.vetoListeners.remove(listener);
            this.log("Remove ShutdownVetoListener:" + listener + ":" + ret);
        }
    }

    public boolean requestShutdown() {
        return this.requestShutdown(false);
    }

    public boolean requestShutdown(boolean silent) {
        return this.requestShutdown(new BasicShutdownRequest(silent));
    }

    public boolean isShuttingDown() {
        return this.shutDown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestShutdown(final ShutdownRequest request) {
        if (request == null) {
            throw new NullPointerException();
        }
        if (!Application.isHeadless()) {
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    LogV3.log(new Exception("This call should be in an own thread - else the shutdown hooks may wait for the edt and create a 'deadlock'"));
                }
            }
            catch (Throwable e) {
                LogV3.log(e);
            }
        }
        this.log("Request Shutdown: " + request);
        this.requestedShutDowns.incrementAndGet();
        try {
            this.collectVetos(request);
            List<ShutdownVetoException> vetos = request.getVetos();
            if (vetos.size() == 0) {
                LogV3.info("No Vetos");
                ShutdownVetoListener[] shutdownVetoListenerArray = this.vetoListeners;
                synchronized (this.vetoListeners) {
                    ShutdownVetoListener[] localList = this.vetoListeners.toArray(new ShutdownVetoListener[0]);
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    LogV3.info("Fire onShutDownEvents:" + localList.length);
                    for (ShutdownVetoListener v : localList) {
                        try {
                            LogV3.info("Call onShutdown: " + v);
                            v.onShutdown(request);
                        }
                        catch (Throwable e) {
                            LogV3.log(e);
                        }
                        finally {
                            LogV3.info("Call onShutdown done: " + v);
                        }
                    }
                    if (this.shutDown.compareAndSet(false, true)) {
                        this.shutdownRequest = request;
                        LogV3.info("Create ExitThread");
                        try {
                            request.onShutdown();
                        }
                        catch (Throwable e) {
                            LogV3.severe(Exceptions.getStackTrace(e));
                        }
                        this.exitThread = new Thread("ShutdownThread:" + System.currentTimeMillis() + "|" + request){

                            @Override
                            public void run() {
                                Integer exitCode = request.getExitCode();
                                try {
                                    if (exitCode == null) {
                                        exitCode = ShutdownController.this.getExitCode();
                                        ShutdownController.this.log("Exit Now(Controller): Code: " + exitCode);
                                    } else {
                                        ShutdownController.this.log("Exit Now(Request): Code: " + exitCode);
                                    }
                                    ShutdownController.this.runHooks();
                                    System.exit(exitCode != null ? exitCode : -1);
                                }
                                catch (Throwable throwable) {
                                    System.exit(exitCode != null ? exitCode : -1);
                                    throw throwable;
                                }
                            }
                        };
                        this.exitThread.start();
                    }
                    long waitDuration = 0L;
                    while (this.exitThread.isAlive()) {
                        this.log("Wait for ShutdownThread:" + this.exitThread + "|waitDuration:" + waitDuration);
                        try {
                            Thread.sleep(500L);
                            waitDuration += 500L;
                        }
                        catch (InterruptedException e) {
                            this.log("Wait for ShutdownThread interrupted:" + this.exitThread + "|waitDuration:" + waitDuration);
                            boolean v = true;
                            this.requestedShutDowns.decrementAndGet();
                            return v;
                        }
                    }
                    this.log("ShutdownThread finished:" + this.exitThread + "|waitDuration:" + waitDuration);
                    int n = 1;
                    return n != 0;
                }
            }
            ShutdownVetoListener[] shutdownVetoListenerArray = this.vetoListeners;
            synchronized (this.vetoListeners) {
                ShutdownVetoListener[] localList = this.vetoListeners.toArray(new ShutdownVetoListener[0]);
                // ** MonitorExit[var4_7] (shouldn't be in output)
                LogV3.info("Vetos found:" + localList.length);
                for (ShutdownVetoListener v : localList) {
                    try {
                        v.onShutdownVeto(request);
                    }
                    catch (Throwable e) {
                        LogV3.log(e);
                    }
                }
                request.onShutdownVeto();
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.requestedShutDowns.decrementAndGet();
        }
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    public void setLogger(LogInterface logger) {
        this.logger = logger;
    }

    private void log(String string) {
        try {
            LogInterface logger = this.getLogger();
            if (logger != null) {
                logger.info(string);
            } else {
                System.out.println(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHooks() {
        if (this.shutDownHookRunning.compareAndSet(false, true)) {
            try {
                ArrayList<ShutdownEvent> list;
                ArrayList<ShutdownEvent> arrayList = this.hooks;
                synchronized (arrayList) {
                    list = new ArrayList<ShutdownEvent>(this.hooks);
                }
                arrayList = this.originalShutdownHooks;
                synchronized (arrayList) {
                    list.addAll(this.originalShutdownHooks);
                }
                final ShutdownRequest shutdownRequest = this.getShutdownRequest();
                int i = 0;
                for (final ShutdownEvent e : list) {
                    try {
                        long started = System.currentTimeMillis();
                        this.log("[" + ++i + "/" + list.size() + "|Priority: " + e.getHookPriority() + "]ShutdownController: start item->" + e);
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                e.onShutdown(shutdownRequest);
                            }
                        });
                        thread.setName("ShutdownHook [" + i + "/" + list.size() + "|Priority: " + e.getHookPriority() + "]");
                        thread.start();
                        try {
                            e.waitFor();
                            thread.join(Math.max(0L, e.getMaxDuration()));
                        }
                        catch (Throwable e1) {
                            e1.printStackTrace();
                        }
                        if (thread.isAlive()) {
                            this.log("[" + i + "/" + list.size() + "|Priority: " + e.getHookPriority() + "]ShutdownController: " + e + "->is still running after " + e.getMaxDuration() + " ms");
                            this.log("[" + i + "/" + list.size() + "|Priority: " + e.getHookPriority() + "]ShutdownController: " + e + "->StackTrace:\r\n" + this.getStackTrace(thread));
                        } else {
                            this.log("[" + i + "/" + list.size() + "|Priority: " + e.getHookPriority() + "]ShutdownController: item ended after->" + (System.currentTimeMillis() - started));
                        }
                        this.log("[Done:" + i + "/" + list.size() + "]");
                    }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                    }
                }
                this.log("Shutdown Hooks Finished");
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        this.runHooks();
    }

    public void setExitCode(int i) {
        this.exitCode = i;
    }

    static {
        Application.warnInit();
    }

    class ShutdownEventWrapper
    extends ShutdownEvent {
        private final Thread orgThread;

        public ShutdownEventWrapper(Thread value) {
            this.orgThread = value;
            this.setHookPriority(Integer.MIN_VALUE);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ShutdownEventWrapper) {
                return this.orgThread == ((ShutdownEventWrapper)obj).orgThread;
            }
            return false;
        }

        @Override
        public boolean supportsIllegalStateException() {
            return true;
        }

        public int hashCode() {
            return this.orgThread.hashCode();
        }

        @Override
        public void onShutdown(ShutdownRequest shutdownRequest) {
            this.orgThread.run();
        }

        @Override
        public String toString() {
            return "ShutdownEventWrapper " + this.orgThread + " - " + this.orgThread.getClass().getName() + " Priority: " + this.getHookPriority();
        }
    }
}

