/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.reflect.Type;
import java.util.ArrayList;
import org.appwork.storage.config.annotations.DefaultEnumArrayValue;
import org.appwork.storage.config.handler.ListHandler;
import org.appwork.storage.config.handler.StorageHandler;

public class EnumListHandler
extends ListHandler<Enum<?>[]> {
    public EnumListHandler(StorageHandler<?> storageHandler, String key, Type type) {
        super(storageHandler, key, type, DefaultEnumArrayValue.class);
    }

    @Override
    protected void initDefaults() throws Throwable {
        DefaultEnumArrayValue ann = this.getAnnotation(DefaultEnumArrayValue.class);
        if (ann != null) {
            ArrayList ret = new ArrayList();
            for (String value : ann.value()) {
                try {
                    int index = value.lastIndexOf(".");
                    String name = value.substring(index + 1);
                    String clazz = value.substring(0, index);
                    ret.add(Enum.valueOf(Class.forName(clazz), name));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            this.setDefaultValue(ret.toArray(new Enum[0]));
        } else {
            this.setDefaultValue(null);
        }
    }
}

