/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.swing.models;

import java.util.List;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.handler.ByteKeyHandler;
import org.appwork.storage.config.swing.ValueProvider;
import org.appwork.storage.config.swing.ValueProviderListener;
import org.appwork.storage.config.swing.models.KeyHandlerProviderBridge;
import org.appwork.utils.swing.EDTRunner;

public class ConfigByteSpinnerModel
extends SpinnerNumberModel
implements ValueProviderListener<Byte> {
    private static final long serialVersionUID = 8542048212034642953L;
    private final ValueProvider<Byte> provider;

    public ConfigByteSpinnerModel(ByteKeyHandler keyHandler) {
        this(new KeyHandlerProviderBridge<Byte>(keyHandler));
    }

    public ConfigByteSpinnerModel(ValueProvider<Byte> provider) {
        this.provider = provider;
        provider.register(this, true);
        List<SpinnerValidator> spinn = provider.getAnnotations(SpinnerValidator.class);
        if (spinn != null && spinn.size() > 0) {
            this.setMinimum((Comparable)Long.valueOf(spinn.get(0).min()));
            this.setMaximum((Comparable)Long.valueOf(spinn.get(0).max()));
            this.setStepSize(spinn.get(0).step());
        }
    }

    public void setMinimum(Comparable minimum) {
        super.setMinimum(Byte.valueOf(((Number)((Object)minimum)).byteValue()));
    }

    public void setMaximum(Comparable maximum) {
        super.setMaximum(Byte.valueOf(((Number)((Object)maximum)).byteValue()));
    }

    @Override
    public void setStepSize(Number stepSize) {
        super.setStepSize(stepSize.byteValue());
    }

    @Override
    public Number getNumber() {
        return this.provider.get();
    }

    @Override
    public Object getNextValue() {
        return this.incrValue(1);
    }

    @Override
    public Object getPreviousValue() {
        return this.incrValue(-1);
    }

    protected Number incrValue(int i) {
        return ((Number)this.getValue()).byteValue() + this.getStepSize().byteValue() * i;
    }

    @Override
    public Object getValue() {
        return this.provider.get();
    }

    @Override
    public void setValue(Object value) {
        try {
            if (value instanceof Number) {
                this.provider.set(((Number)value).byteValue());
            } else if (value instanceof String && ((String)value).matches("^-?\\d+$")) {
                this.provider.set(Byte.valueOf(String.valueOf(value)));
            }
        }
        catch (ValidationException e) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        }
    }

    @Override
    public void onValueModified(ValueProvider<Byte> owner, Byte newValue) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigByteSpinnerModel.this.fireStateChanged();
            }
        };
    }

    @Override
    public void onValueValidationError(ValueProvider<Byte> owner, Byte invalidValue, Exception exception) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigByteSpinnerModel.this.fireStateChanged();
            }
        };
    }
}

