/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.swing.models;

import java.awt.Toolkit;
import java.util.List;
import javax.swing.SpinnerNumberModel;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.handler.IntegerKeyHandler;
import org.appwork.storage.config.swing.ValueProvider;
import org.appwork.storage.config.swing.ValueProviderListener;
import org.appwork.storage.config.swing.models.KeyHandlerProviderBridge;
import org.appwork.utils.swing.EDTRunner;

public class ConfigIntSpinnerModel
extends SpinnerNumberModel
implements ValueProviderListener<Integer> {
    private static final long serialVersionUID = 1L;
    private final ValueProvider<Integer> provider;

    public ConfigIntSpinnerModel(IntegerKeyHandler keyHandler) {
        this(new KeyHandlerProviderBridge<Integer>(keyHandler));
    }

    public ConfigIntSpinnerModel(ValueProvider<Integer> provider) {
        this.provider = provider;
        provider.register(this, true);
        List<SpinnerValidator> spinn = provider.getAnnotations(SpinnerValidator.class);
        if (spinn != null && spinn.size() > 0) {
            this.setMinimum((Comparable)Long.valueOf(spinn.get(0).min()));
            this.setMaximum((Comparable)Long.valueOf(spinn.get(0).max()));
            this.setStepSize(spinn.get(0).step());
        }
    }

    public ValueProvider<Integer> getProvider() {
        return this.provider;
    }

    public void setMinimum(Comparable minimum) {
        super.setMinimum(Integer.valueOf(((Number)((Object)minimum)).intValue()));
    }

    public void setMaximum(Comparable maximum) {
        super.setMaximum(Integer.valueOf(((Number)((Object)maximum)).intValue()));
    }

    @Override
    public void setStepSize(Number stepSize) {
        super.setStepSize(stepSize.intValue());
    }

    @Override
    public Number getNumber() {
        return this.provider.get();
    }

    @Override
    public Object getNextValue() {
        return this.incrValue(1);
    }

    @Override
    public Object getPreviousValue() {
        return this.incrValue(-1);
    }

    protected Number incrValue(int i) {
        return ((Number)this.getValue()).intValue() + this.getStepSize().intValue() * i;
    }

    @Override
    public Object getValue() {
        return this.provider.get();
    }

    @Override
    public void setValue(Object value) {
        try {
            if (value instanceof Number) {
                this.provider.set(((Number)value).intValue());
            } else if (value instanceof String && ((String)value).matches("^-?\\d+$")) {
                this.provider.set(Integer.valueOf(String.valueOf(value)));
            }
        }
        catch (ValidationException e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public void onValueModified(ValueProvider<Integer> owner, Integer newValue) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigIntSpinnerModel.this.fireStateChanged();
            }
        };
    }

    @Override
    public void onValueValidationError(ValueProvider<Integer> owner, Integer invalidValue, Exception exception) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigIntSpinnerModel.this.fireStateChanged();
            }
        };
    }
}

