/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson.mapper;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.storage.StorableAllowProtectedAccessModifier;
import org.appwork.storage.StorableDontSerializeDeeper;
import org.appwork.storage.flexijson.mapper.FlexiJsonProperty;
import org.appwork.storage.simplejson.Ignore;
import org.appwork.storage.simplejson.Ignores;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.GetterOrSetter;
import org.appwork.storage.simplejson.mapper.Property;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.reflection.CompiledType;

public class ClassCache {
    public static final String ORG_APPWORK_STORAGE_FLEXIJSON_MAPPER_FLEXI_KEY_LOOKUP = "org.appwork.storage.flexijson.mapper.FlexiKeyLookup";
    public static final String ORG_APPWORK_STORAGE_CONFIG_ANNOTATIONS_LOOK_UP_KEYS = "org.appwork.storage.config.annotations.LookUpKeys";
    private static final WeakHashMap<Class<?>, ClassCache> CACHE = new WeakHashMap();
    private static final Object[] EMPTY_OBJECT = new Object[0];
    private static final Class<?>[] EMPTY_TYPES = new Class[0];
    private List<Type> typeHierarchy;
    protected Constructor<? extends Object> constructor;
    protected final WeakReference<Class<? extends Object>> clazz;
    protected final List<Getter> getter;
    protected final List<Setter> setter;
    protected final List<Getter> allGetter;
    protected final List<Setter> allSetter;
    protected final LinkedHashMap<String, Getter> getterMap;
    protected final LinkedHashMap<String, Setter> setterMap;
    private Map<Type, Type> extendedTypesMap;
    private Map<Class, ParameterizedType> parameterizedTypesMap;
    private HashMap<String, List<? extends Annotation>> annotationsCache = new HashMap();

    protected static ClassCache create(Class<? extends Object> clazz) throws SecurityException, NoSuchMethodException {
        return ClassCache.create(clazz, null);
    }

    public static String getGetterKey(Method m) {
        if (m == null) {
            return null;
        }
        if (m.getReturnType() == Void.TYPE) {
            return null;
        }
        if (ClassCache.getParameterCount(m) > 0) {
            return null;
        }
        String name = m.getName();
        if (name.startsWith("get")) {
            if (name.length() > 3) {
                return ClassCache.createKey(name.substring(3));
            }
            return null;
        }
        if (name.startsWith("is")) {
            if (name.length() > 2) {
                return ClassCache.createKey(name.substring(2));
            }
            return null;
        }
        return null;
    }

    public static int getParameterCount(Method method) {
        int ret = JVMVersion.isMinimum(18000000L) ? method.getParameterCount() : method.getParameterTypes().length;
        return ret;
    }

    public static String getSetterKey(Method m) {
        if (m == null) {
            return null;
        }
        if (ClassCache.getParameterCount(m) != 1) {
            return null;
        }
        String name = m.getName();
        if (name.startsWith("set")) {
            if (name.length() > 3) {
                return ClassCache.createKey(name.substring(3));
            }
            return null;
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     */
    public static ClassCache create(Class<? extends Object> clazz, Rules rules) throws SecurityException, NoSuchMethodException {
        ClassCache cc = new ClassCache(clazz);
        HashSet<String> ignores = new HashSet<String>();
        for (Type t : cc.getTypeHierarchy()) {
            if (t == Object.class) break;
            CompiledType ct = CompiledType.create(t);
            if (ct.raw == null) continue;
            if (rules != null && (rules.getBreakAtClass() == ct.raw || rules.isBreakAtClass(ct.raw))) break;
            Ignores ig = ct.raw.getAnnotation(Ignores.class);
            if (ig != null) {
                for (String i : ig.value()) {
                    ignores.add(i);
                }
            }
            HashMap<String, Method> proxyLookup = null;
            if (Proxy.isProxyClass(ct.raw)) {
                proxyLookup = new HashMap<String, Method>();
                for (Class<?> i : ct.raw.getInterfaces()) {
                    for (Method method : i.getDeclaredMethods()) {
                        String id = method.getName();
                        for (Class<?> pt : method.getParameterTypes()) {
                            id = id + "," + pt.getName();
                        }
                        proxyLookup.put(id, method);
                    }
                }
            }
            ArrayList<Method> methods = new ArrayList<Method>();
            for (Method m : ct.raw.getDeclaredMethods()) {
                if (proxyLookup != null) {
                    String id = m.getName();
                    for (Class<?> pt : m.getParameterTypes()) {
                        id = id + "," + pt.getName();
                    }
                    Method lookedUp = (Method)proxyLookup.get(id);
                    if (lookedUp != null) {
                        m = lookedUp;
                    }
                }
                if (m.getAnnotation(Ignore.class) != null || ignores.contains(m.toString()) || Modifier.isStatic(m.getModifiers()) || ClassCache.getGetterKey(m) == null && ClassCache.getSetterKey(m) == null) continue;
                methods.add(m);
            }
            Collections.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method o1, Method o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (Method m : methods) {
                Object field;
                int mods;
                ArrayList<String> alternativeKeys = new ArrayList<String>();
                String key = null;
                key = ClassCache.getGetterKey(m);
                if (key != null) {
                    mods = m.getModifiers();
                    if (Modifier.isPrivate(mods) && m.getAnnotation(StorableAllowPrivateAccessModifier.class) == null || !Modifier.isPrivate(mods) && !Modifier.isPublic(mods) && m.getAnnotation(StorableAllowProtectedAccessModifier.class) == null) continue;
                    for (Annotation a : m.getAnnotations()) {
                        ClassCache.addAlternativeKeyFromAnnotation(alternativeKeys, a, key);
                    }
                    field = ClassCache.addAlternativeKeyFromField(ct.raw, m, alternativeKeys, key);
                    Getter g = new Getter(cc, key, alternativeKeys, m, (Field)field);
                    cc.allGetter.add(g);
                    if (ClassCache.putMethod(cc.getterMap, g.getKey(), g)) {
                        cc.getter.add(g);
                    }
                    for (String aKey : alternativeKeys) {
                        ClassCache.putMethod(cc.getterMap, aKey, g);
                    }
                    continue;
                }
                key = ClassCache.getSetterKey(m);
                if (key == null || Modifier.isPrivate(mods = m.getModifiers()) && m.getAnnotation(StorableAllowPrivateAccessModifier.class) == null || !Modifier.isPrivate(mods) && !Modifier.isPublic(mods) && m.getAnnotation(StorableAllowProtectedAccessModifier.class) == null) continue;
                for (Annotation a : m.getAnnotations()) {
                    ClassCache.addAlternativeKeyFromAnnotation(alternativeKeys, a, key);
                }
                field = ClassCache.addAlternativeKeyFromField(ct.raw, m, alternativeKeys, key);
                Setter s = new Setter(cc, key, alternativeKeys, m, (Field)field);
                cc.allSetter.add(s);
                if (ClassCache.putMethod(cc.setterMap, s.getKey(), s)) {
                    cc.setter.add(s);
                }
                for (String aKey : alternativeKeys) {
                    ClassCache.putMethod(cc.setterMap, aKey, s);
                }
            }
            if (ct.raw.getAnnotation(StorableDontSerializeDeeper.class) == null) continue;
            break;
        }
        for (Constructor<?> c : clazz.getDeclaredConstructors()) {
            if (c.getParameterTypes().length != 0) continue;
            try {
                if (Modifier.isPrivate(c.getModifiers()) && c.getAnnotation(StorableAllowPrivateAccessModifier.class) == null || !Modifier.isPrivate(c.getModifiers()) && !Modifier.isPublic(c.getModifiers()) && c.getAnnotation(StorableAllowProtectedAccessModifier.class) == null) continue;
                c.setAccessible(true);
                cc.constructor = c;
            }
            catch (SecurityException e) {
                LogV3.log(e);
            }
            break;
        }
        if (cc.constructor == null && rules != null && !rules.ignoreMissingConstructor) {
            String pkg;
            int lastIndex = clazz.getName().lastIndexOf(".");
            String string = pkg = lastIndex > 0 ? clazz.getName().substring(0, lastIndex) : "";
            if (pkg.startsWith("java.") || pkg.startsWith("sun.")) {
                LogV3.warning("No Null Constructor in " + clazz + " found. De-Json-serial will fail");
            } else if (clazz.isAnonymousClass()) {
                LogV3.warning("No Null Constructor in inline-clazz " + clazz + " found. De-Json-serial will fail");
            } else {
                throw new NoSuchMethodException(" Class " + clazz + " requires a null constructor. please add private " + clazz.getSimpleName() + "(){}");
            }
        }
        return cc;
    }

    private static <T extends GetterOrSetter> boolean putMethod(HashMap<String, T> map, String key, T g) {
        GetterOrSetter exists = (GetterOrSetter)map.get(key);
        if (exists != null) {
            if (exists.getMethod().getName().equals(g.getMethod().getName())) {
                return false;
            }
            throw new WTFException("invalid Key Mapping: " + g + " vs. " + exists);
        }
        map.put(key, g);
        return true;
    }

    protected static Field addAlternativeKeyFromField(Class<? extends Object> cls, Method m, ArrayList<String> alternativeKeys, String key) {
        Field field = null;
        String methodName = m.getName();
        String searchField = ClassCache.createKey(m);
        boolean isSetMethod = methodName.startsWith("set");
        while (cls != null && cls != Object.class) {
            try {
                field = cls.getDeclaredField(key);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (field == null) {
                try {
                    field = cls.getDeclaredField(methodName);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            if (field == null && searchField != null) {
                try {
                    field = cls.getDeclaredField(searchField);
                }
                catch (NoSuchFieldException e) {
                    try {
                        field = isSetMethod ? cls.getDeclaredField("is" + searchField) : null;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
            }
            if (field != null) {
                if (!key.equals(field.getName()) && alternativeKeys.indexOf(field.getName()) < 0) {
                    alternativeKeys.add(field.getName());
                }
                for (Annotation a : field.getAnnotations()) {
                    ClassCache.addAlternativeKeyFromAnnotation(alternativeKeys, a, key);
                }
                return field;
            }
            cls = cls.getSuperclass();
        }
        return field;
    }

    protected static void addAlternativeKeyFromAnnotation(ArrayList<String> alternativeKeys, Annotation a, String key) {
        if (a instanceof FlexiJsonProperty) {
            ClassCache.add(alternativeKeys, key, ((FlexiJsonProperty)a).value());
        }
        Class<? extends Annotation> type = a.annotationType();
        try {
            if ("com.google.gson.annotations.SerializedName".equals(type.getName())) {
                Method valueMethod = type.getMethod("value", new Class[0]);
                Object value = valueMethod.invoke((Object)a, new Object[0]);
                ClassCache.add(alternativeKeys, key, value);
            } else if ("com.fasterxml.jackson.annotation.JsonProperty".equals(type.getName())) {
                Method valueMethod = type.getMethod("value", new Class[0]);
                Object value = valueMethod.invoke((Object)a, new Object[0]);
                ClassCache.add(alternativeKeys, key, value);
            } else if (ORG_APPWORK_STORAGE_FLEXIJSON_MAPPER_FLEXI_KEY_LOOKUP.equals(type.getName())) {
                Method valueMethod = type.getMethod("value", new Class[0]);
                Object value = valueMethod.invoke((Object)a, new Object[0]);
                ClassCache.add(alternativeKeys, key, value);
            } else if (ORG_APPWORK_STORAGE_CONFIG_ANNOTATIONS_LOOK_UP_KEYS.equals(type.getName())) {
                Method valueMethod = type.getMethod("value", new Class[0]);
                Object value = valueMethod.invoke((Object)a, new Object[0]);
                ClassCache.add(alternativeKeys, key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void add(ArrayList<String> alternativeKeys, String key, Object value) {
        if (value == null) {
            return;
        }
        if (value.getClass() == String[].class) {
            alternativeKeys.addAll(Arrays.asList((String[])value));
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        if (key.equals(value)) {
            return;
        }
        if (alternativeKeys.indexOf(value) >= 0) {
            return;
        }
        alternativeKeys.add((String)value);
    }

    public List<Type> getTypeHierarchy() {
        if (this.typeHierarchy == null) {
            this.initTypeHierarchy();
        }
        return this.typeHierarchy;
    }

    public Map<Class, ParameterizedType> getParameterizedTypesMap() {
        if (this.typeHierarchy == null) {
            this.initTypeHierarchy();
        }
        return this.parameterizedTypesMap;
    }

    private void initTypeHierarchy() {
        LinkedHashMap<Class, ParameterizedType> parameterizedTypesMap = new LinkedHashMap<Class, ParameterizedType>();
        LinkedHashMap<Type, Type> extendedTypesMap = new LinkedHashMap<Type, Type>();
        ArrayList<Type> types = new ArrayList<Type>();
        Type start = this.getCachedClass();
        if (start == null) {
            throw new WTFException();
        }
        types.add(start);
        while (true) {
            Type r;
            Type sClass = null;
            if (start instanceof Class) {
                sClass = start.getGenericSuperclass();
                if (sClass != null && extendedTypesMap.put(sClass, start) == null) {
                    types.add(sClass);
                }
                for (Type ifs : start.getGenericInterfaces()) {
                    if (extendedTypesMap.put(ifs, start) == null) {
                        types.add(ifs);
                    }
                    this.followInterfaces(types, extendedTypesMap, ifs);
                }
            } else if (start instanceof ParameterizedType) {
                r = ((ParameterizedType)start).getRawType();
                if (r instanceof Class) {
                    sClass = ((Class)r).getGenericSuperclass();
                    parameterizedTypesMap.put((Class)r, (ParameterizedType)start);
                    if (extendedTypesMap.put(sClass, start) == null) {
                        types.add(sClass);
                    }
                    for (Type ifs : ((Class)r).getGenericInterfaces()) {
                        if (extendedTypesMap.put(ifs, start) == null) {
                            types.add(ifs);
                        }
                        this.followInterfaces(types, extendedTypesMap, ifs);
                    }
                } else {
                    LogV3.I().getDefaultLogger().log(new Exception("This should not happen. " + this.clazz.get()));
                    extendedTypesMap.put(r, start);
                }
            }
            if (sClass != null && sClass instanceof ParameterizedType) {
                r = ((ParameterizedType)sClass).getRawType();
                if (extendedTypesMap.put(r, start) == null) {
                    types.add(r);
                }
                if (r instanceof Class) {
                    for (Type ifs : ((Class)r).getGenericInterfaces()) {
                        if (extendedTypesMap.put(ifs, start) == null) {
                            types.add(ifs);
                        }
                        this.followInterfaces(types, extendedTypesMap, ifs);
                    }
                }
            }
            if (sClass == null) break;
            start = sClass;
        }
        this.parameterizedTypesMap = Collections.unmodifiableMap(parameterizedTypesMap);
        this.extendedTypesMap = Collections.unmodifiableMap(extendedTypesMap);
        this.typeHierarchy = Collections.unmodifiableList(types);
    }

    private void followInterfaces(ArrayList<Type> types, HashMap<Type, Type> extendedTypesMap, Type start) {
        if (start instanceof Class) {
            for (Class<?> ifs : ((Class)start).getInterfaces()) {
                if (extendedTypesMap.put(ifs, start) == null) {
                    types.add(ifs);
                }
                this.followInterfaces(types, extendedTypesMap, ifs);
            }
        } else if (start instanceof ParameterizedType) {
            Type r = ((ParameterizedType)start).getRawType();
            if (r instanceof Class) {
                for (Class<?> ifs : ((Class)r).getInterfaces()) {
                    if (extendedTypesMap.put(ifs, start) == null) {
                        types.add(ifs);
                    }
                    this.followInterfaces(types, extendedTypesMap, ifs);
                }
            } else {
                throw new WTFException();
            }
        }
    }

    public static String createKey(String key) {
        if (key.length() == 0) {
            return null;
        }
        char[] ca = key.toCharArray();
        StringBuilder sb = new StringBuilder(ca.length);
        boolean starter = true;
        boolean lowerCase = false;
        for (int i = 0; i < ca.length; ++i) {
            if (starter && Character.isUpperCase(ca[i])) {
                lowerCase = true;
                sb.append(Character.toLowerCase(ca[i]));
                continue;
            }
            starter = false;
            sb.append(ca[i]);
        }
        if (lowerCase) {
            return sb.toString();
        }
        return key;
    }

    public static synchronized ClassCache getClassCache(Type type) throws SecurityException, NoSuchMethodException {
        Class<?> clazz = ReflectionUtils.getRaw(type);
        if (clazz == null) {
            throw new IllegalStateException(type + " has now raw Class.");
        }
        ClassCache cc = CACHE.get(clazz);
        if (cc == null) {
            cc = ClassCache.create(clazz);
            CACHE.put(clazz, cc);
        }
        return cc;
    }

    public List<Getter> getAllGetter() {
        return this.allGetter;
    }

    public List<Setter> getAllSetter() {
        return this.allSetter;
    }

    public Map<String, Getter> getGetterMap() {
        return this.getterMap;
    }

    public Map<String, Setter> getSetterMap() {
        return this.setterMap;
    }

    protected ClassCache(Class<? extends Object> clazz) {
        this.clazz = new WeakReference<Class<? extends Object>>(clazz);
        this.getter = new ArrayList<Getter>();
        this.setter = new ArrayList<Setter>();
        this.allSetter = new ArrayList<Setter>();
        this.allGetter = new ArrayList<Getter>();
        this.getterMap = new LinkedHashMap();
        this.setterMap = new LinkedHashMap();
    }

    public Class<? extends Object> getCachedClass() {
        return (Class)this.clazz.get();
    }

    private Map<Type, Type> getExtendedTypesMap() {
        if (this.typeHierarchy == null) {
            this.initTypeHierarchy();
        }
        return this.extendedTypesMap;
    }

    public List<Getter> getGetter() {
        return this.getter;
    }

    public Getter getGetter(String key) {
        return this.getterMap.get(key);
    }

    public Object getInstance() throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.constructor == null) {
            throw new IllegalStateException("The class " + this.getCachedClass() + " has no empty constructor");
        }
        return this.constructor.newInstance(EMPTY_OBJECT);
    }

    public List<Setter> getSetter() {
        return this.setter;
    }

    public Setter getSetter(String key) {
        return this.setterMap.get(key);
    }

    public Set<String> getKeys() {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        ret.addAll(this.getterMap.keySet());
        ret.addAll(this.setterMap.keySet());
        return ret;
    }

    public ParameterizedType getParameterizedType(Class cls) {
        return this.getParameterizedTypesMap().get(cls);
    }

    public Type getExtendedType(Class cls) {
        return this.getExtendedTypesMap().get(cls);
    }

    public <TT extends Annotation> List<TT> getMethodAnnotations(Method method, Class<TT> class1) {
        String key = ClassCache.createKey(method);
        if (key == null) {
            key = method.getName();
        }
        return this.getAnnotations(key, class1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TT extends Annotation> List<TT> getAnnotations(String key, Class<TT> class1) {
        String cacheKey = key + "_" + class1.getName();
        HashMap<String, List<? extends Annotation>> hashMap = this.annotationsCache;
        synchronized (hashMap) {
            List<? extends Annotation> ret = this.annotationsCache.get(cacheKey);
            if (ret != null) {
                return ret;
            }
        }
        this.getExtendedTypesMap();
        Getter g = key == null ? null : this.getGetter(key);
        Setter s = key == null ? null : this.getSetter(key);
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Type t : this.typeHierarchy) {
            Annotation an;
            TT an2;
            Method method2;
            if (!(t instanceof Class)) continue;
            Class c = (Class)t;
            if (g != null) {
                try {
                    method2 = c.getDeclaredMethod(g.getMethod().getName(), g.getMethod().getParameterTypes());
                    if (method2 != null && (an2 = method2.getAnnotation(class1)) != null) {
                        ret.add(an2);
                    }
                }
                catch (NoSuchMethodException method2) {
                }
                catch (SecurityException e) {
                    throw new WTFException();
                }
                if (g.field != null && g.field.getDeclaringClass() == t && (an = g.field.getAnnotation(class1)) != null) {
                    ret.add(an);
                }
            }
            if (s != null) {
                try {
                    method2 = c.getDeclaredMethod(s.getMethod().getName(), s.getMethod().getParameterTypes());
                    if (method2 != null && (an2 = method2.getAnnotation(class1)) != null) {
                        ret.add(an2);
                    }
                }
                catch (NoSuchMethodException method3) {
                }
                catch (SecurityException e) {
                    throw new WTFException();
                }
            }
            if (key != null || (an = (Annotation)ReflectionUtils.getAnnotation(t, class1)) == null) continue;
            ret.add(an);
        }
        HashMap<String, List<? extends Annotation>> hashMap2 = this.annotationsCache;
        synchronized (hashMap2) {
            this.annotationsCache.put(cacheKey, ret);
        }
        return ret;
    }

    public Type getType(String key) {
        Getter g = this.getGetter(key);
        if (g != null) {
            return g.getMethod().getGenericReturnType();
        }
        Setter s = this.getSetter(key);
        if (s != null) {
            return s.getMethod().getGenericParameterTypes()[0];
        }
        throw new WTFException(key);
    }

    public static String createKey(Method method) {
        String name = method.getName();
        if (name.length() > 3 && (name.startsWith("get") || name.startsWith("set"))) {
            return ClassCache.createKey(name.substring(3));
        }
        if (name.length() > 2 && name.startsWith("is")) {
            return ClassCache.createKey(name.substring(2));
        }
        return null;
    }

    public String toString() {
        return "ClassCache " + this.getCachedClass();
    }

    public Property getProperty(String key) {
        Getter g = this.getGetter(key);
        Setter s = this.getSetter(key);
        if (g == null && s == null) {
            return null;
        }
        return new Property(key, CompiledType.create(this.getType(key), (Type)this.clazz.get()), g, s);
    }

    public static class Rules {
        private Class<?> breakAtClass;
        private boolean ignoreMissingConstructor;

        public void setIgnoreMissingConstructor(boolean ignoreMissingConstructor) {
            this.ignoreMissingConstructor = ignoreMissingConstructor;
        }

        public Rules ignoreMissingConstructor(boolean ignoreMissingConstructor) {
            this.ignoreMissingConstructor = ignoreMissingConstructor;
            return this;
        }

        public Class<?> getBreakAtClass() {
            return this.breakAtClass;
        }

        public void setBreakAtClass(Class<?> breakAtClass) {
            this.breakAtClass = breakAtClass;
        }

        public Rules breakAtClass(Class<?> breakAtClass) {
            this.breakAtClass = breakAtClass;
            return this;
        }

        public boolean isBreakAtClass(Class<? extends Object> cls) {
            String name = cls.getName();
            if (name.startsWith("java.")) {
                return true;
            }
            return name.startsWith("sun.");
        }
    }
}

