/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.validator.classvalidator;

import java.util.ArrayList;
import java.util.List;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.FailLevel;
import org.appwork.storage.StorableValidator;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.validator.classvalidator.StorableAbstractValidator;
import org.appwork.utils.StringUtils;
import org.appwork.utils.reflection.CompiledType;

public class StorableNumberValidator
extends StorableAbstractValidator {
    @Override
    public List<? extends StorableValidator.ValidatorException> validate(StorableValidator validator, Object root, Object value, FlexiJSonNode node, JSPath path, CompiledType type, String parameter, FailLevel level, String message) {
        try {
            ArrayList<InvalidNumberException> ret = new ArrayList<InvalidNumberException>();
            if (value instanceof Number) {
                int comResult;
                FlexiJSonObject params = (FlexiJSonObject)new FlexiJSONParser(parameter).parse();
                Double gt = params.getNE(">", Double.class);
                if (gt != null && (comResult = gt.compareTo(((Number)value).doubleValue())) >= 0) {
                    ret.add(new InvalidNumberException(validator, null, path, node, type, StringUtils.isEmpty(message) ? "The value must be bigger than " + gt : message, level));
                }
            } else {
                ret.add(new InvalidNumberException(validator, null, path, node, type, StringUtils.isEmpty(message) ? "The value must be a number" : message, level));
            }
            return ret;
        }
        catch (FlexiParserException e) {
            throw new WTFException(e);
        }
    }

    @Override
    public String getDocsDescription(String parameter, Object anno) {
        try {
            FlexiJSonObject params = (FlexiJSonObject)new FlexiJSONParser(parameter).parse();
            Double gt = params.getNE(">", Double.class);
            if (gt != null) {
                return "Value must be greater than (>) " + gt;
            }
            return null;
        }
        catch (FlexiParserException e) {
            throw new WTFException(e);
        }
    }

    public static class InvalidNumberException
    extends StorableValidator.ValidatorException {
        public InvalidNumberException(StorableValidator validator, Throwable cause, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel failLevel) {
            super(validator, cause, path, value, targetType, message, failLevel);
        }
    }
}

