/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing;

import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import org.appwork.swing.ExtScreen;
import org.appwork.utils.swing.EDTHelper;

public class AutoScroller
extends Thread {
    private Window window;
    private Point lastPoint;
    private long lastMoveTime;
    private boolean editing;

    public AutoScroller(Window dialog) {
        this.window = dialog;
    }

    @Override
    public void run() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        final ArrayList<ExtScreen> screens = new ArrayList<ExtScreen>();
        for (GraphicsDevice gs : ge.getScreenDevices()) {
            screens.add(ExtScreen.create(gs.getDefaultConfiguration()));
        }
        this.lastPoint = new Point(0, 0);
        try {
            final Dimension dim = new Dimension();
            final Rectangle rec = new Rectangle();
            while (true) {
                Thread.sleep(50L);
                final Point m = MouseInfo.getPointerInfo().getLocation();
                if (!(this.editing || m.x == this.lastPoint.x && m.y == this.lastPoint.y)) {
                    this.lastMoveTime = System.currentTimeMillis();
                    this.lastPoint = m;
                }
                if (System.currentTimeMillis() - this.lastMoveTime < this.getDelay()) continue;
                this.editing = false;
                new EDTHelper<Object>(){

                    @Override
                    public Object edtRun() {
                        if (AutoScroller.this.window.isVisible()) {
                            Point wLoc = AutoScroller.this.window.getLocationOnScreen();
                            AutoScroller.this.window.getSize(dim);
                            Insets insets = AutoScroller.this.window.getInsets();
                            rec.x = wLoc.x;
                            rec.y = wLoc.y;
                            rec.width = dim.width;
                            rec.height = dim.height;
                            for (ExtScreen screen : screens) {
                                int dest;
                                int x = wLoc.x;
                                int y = wLoc.y;
                                if (screen.getX() + screen.getWidth() - m.x >= 0 && screen.getX() + screen.getWidth() - m.x < AutoScroller.this.getActiveBorder() + screen.getInsets().right) {
                                    if (rec.x + rec.width + insets.left + insets.right > screen.getX() + screen.getWidth() - screen.getInsets().right) {
                                        dest = screen.getX() + screen.getWidth() - screen.getInsets().right - rec.width;
                                        x = (dest - wLoc.x) / AutoScroller.this.getSpeed() != 0 ? wLoc.x + Math.min((AutoScroller.this.getActiveBorder() + screen.getInsets().right - (screen.getX() + screen.getWidth() - m.x)) / 2, (dest - wLoc.x) / AutoScroller.this.getSpeed()) : dest;
                                    }
                                } else if (m.x - screen.getX() >= 0 && m.x - screen.getX() < AutoScroller.this.getActiveBorder() + screen.getInsets().left && rec.x - insets.left < screen.getX() + screen.getInsets().left) {
                                    dest = screen.getX() + screen.getInsets().left;
                                    x = (dest - wLoc.x) / AutoScroller.this.getSpeed() != 0 ? wLoc.x + Math.min((AutoScroller.this.getActiveBorder() + screen.getInsets().left - (m.x - screen.getX())) / 2, (dest - wLoc.x) / AutoScroller.this.getSpeed()) : dest;
                                }
                                if (screen.getY() + screen.getHeight() - m.y >= 0 && screen.getY() + screen.getHeight() - m.y < AutoScroller.this.getActiveBorder() + screen.getInsets().bottom) {
                                    if (rec.y + rec.height > screen.getY() + screen.getHeight() - screen.getInsets().bottom) {
                                        dest = screen.getY() + screen.getHeight() - rec.height - screen.getInsets().bottom;
                                        y = (dest - wLoc.y) / AutoScroller.this.getSpeed() != 0 ? wLoc.y - Math.min((AutoScroller.this.getActiveBorder() + screen.getInsets().bottom - (screen.getY() + screen.getHeight() - m.y)) / 2, (wLoc.y - dest) / AutoScroller.this.getSpeed()) : dest;
                                    }
                                } else if (m.y - screen.getY() >= 0 && m.y - screen.getY() < AutoScroller.this.getActiveBorder() + screen.getInsets().top && rec.y < screen.getY() + screen.getInsets().top) {
                                    dest = screen.getY() + screen.getInsets().top;
                                    y = (dest - wLoc.y) / AutoScroller.this.getSpeed() != 0 ? wLoc.y + Math.min((AutoScroller.this.getActiveBorder() + screen.getInsets().top - (m.y - screen.getY())) / 2, (dest - wLoc.y) / AutoScroller.this.getSpeed()) : dest;
                                }
                                if (x == wLoc.x && y == wLoc.y) continue;
                                AutoScroller.this.window.setBounds(x, y, rec.width, rec.height);
                                AutoScroller.this.editing = true;
                                break;
                            }
                        }
                        return null;
                    }
                }.waitForEDT();
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    protected int getActiveBorder() {
        return 64;
    }

    private long getDelay() {
        return 200L;
    }

    protected int getSpeed() {
        return 4;
    }
}

