/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.appwork.loggingv3.LogV3;

public class SwingAnimator {
    private final int duration;
    private final int fps;
    private Timer timer;

    public SwingAnimator(int duratation, int fps) {
        this.duration = duratation;
        this.fps = fps;
    }

    public synchronized void run(Getter getter, Setter setter, Runnable finalizer) {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = new Timer(1000 / this.fps, new AnimatorListener(getter, setter, finalizer));
        this.timer.setInitialDelay(0);
        this.timer.setRepeats(true);
        this.timer.start();
    }

    public static abstract class Setter {
        public abstract void set(int var1);
    }

    public static abstract class Getter {
        public abstract int get(AnimatorListener var1, int var2);

        public abstract int getStartValue();
    }

    public class AnimatorListener
    implements ActionListener {
        private int step = 0;
        private final long startTime = System.currentTimeMillis();
        private final Getter getter;
        private final Setter setter;
        private final Runnable finalizer;
        private final int startValue;
        private final int steps;

        protected AnimatorListener(Getter getter, Setter setter, Runnable finalizer) {
            this.getter = getter;
            this.setter = setter;
            this.finalizer = finalizer;
            this.steps = SwingAnimator.this.duration / (1000 / SwingAnimator.this.fps);
            this.startValue = getter.getStartValue();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ++this.step;
                int cu = (int)(System.currentTimeMillis() - this.startTime);
                if (this.step <= this.steps) {
                    this.setter.set(this.getter.get(this, cu));
                } else {
                    SwingAnimator.this.timer.stop();
                    SwingAnimator.this.timer = null;
                    this.finalizer.run();
                }
            }
            catch (Throwable t) {
                LogV3.log(t);
                SwingAnimator.this.timer.stop();
                SwingAnimator.this.timer = null;
                this.finalizer.run();
            }
        }

        public int getDuration() {
            return SwingAnimator.this.duration;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public int getStartValue() {
            return this.startValue;
        }

        public int getStep() {
            return this.step;
        }

        public int getSteps() {
            return this.steps;
        }
    }
}

