/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.appwork.resources.AWUTheme;
import org.appwork.swing.components.HeadlessCheckboxIconRef;
import org.appwork.utils.Application;
import org.appwork.utils.ImageProvider.ImageProvider;

public final class CheckBoxIcon
implements Icon {
    public static final CheckBoxIcon FALSE = new CheckBoxIcon(false);
    public static final CheckBoxIcon TRUE = new CheckBoxIcon(true);
    public static final CheckBoxIcon UNDEFINED = new CheckBoxIcon(true, false);
    private final JCheckBox cb;
    private final JPanel panel;
    private final Icon internalIcon;
    private final int size;

    public CheckBoxIcon(final boolean selected, boolean enabled) {
        this.size = 14;
        if (Application.isHeadless()) {
            this.cb = null;
            this.panel = null;
            Icon icon = selected ? HeadlessCheckboxIconRef.HEADLESS_checkbox_true.get(this.size) : HeadlessCheckboxIconRef.HEADLESS_checkbox_false.get(this.size);
            this.internalIcon = !enabled ? AWUTheme.getInstance().getDisabledIcon(icon) : icon;
        } else {
            this.cb = new JCheckBox(){
                {
                    this.setSelected(selected);
                }

                @Override
                public int getWidth() {
                    return this.getPreferredSize().width;
                }

                @Override
                public int getHeight() {
                    return this.getPreferredSize().height;
                }

                @Override
                public boolean isVisible() {
                    return true;
                }
            };
            this.panel = new JPanel();
            this.panel.add(this.cb);
            this.internalIcon = !enabled ? AWUTheme.getInstance().getDisabledIcon(this) : ImageProvider.toImageIcon(this);
        }
    }

    public CheckBoxIcon(boolean selected) {
        this(selected, true);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.internalIcon != null) {
            this.internalIcon.paintIcon(c, g, x, y);
            return;
        }
        g = g.create(x, y, 14, 14);
        g.translate(-4, -4);
        this.cb.paint(g);
        g.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }
}

