/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Highlighter;
import org.appwork.app.gui.copycutpaste.ContextMenuAdapter;
import org.appwork.storage.config.swing.ValueProvider;
import org.appwork.storage.config.swing.ValueProviderListener;
import org.appwork.swing.components.ExtTextHighlighter;
import org.appwork.swing.components.TextComponentInterface;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;

public class ExtTextField
extends JTextField
implements CaretListener,
FocusListener,
DocumentListener,
ContextMenuAdapter,
TextComponentInterface,
ValueProviderListener<String> {
    private static final long serialVersionUID = -3625278218179478516L;
    protected Color defaultColor;
    protected Color helpColor;
    protected String helpText;
    private boolean setting;
    private boolean clearHelpTextOnFocus;
    private boolean helperEnabled;
    private String textSetBySetText;
    protected final CopyOnWriteArrayList<ExtTextHighlighter> highlighters;
    private final ValueProvider<String> provider;
    private final AtomicInteger onChange;

    public ExtTextField() {
        this((ValueProvider<String>)null);
    }

    public ExtTextField(ValueProvider<String> provider) {
        this.addCaretListener(this);
        this.addFocusListener(this);
        this.defaultColor = this.getForeground();
        this.helpColor = (Color)UIManager.get("TextField.disabledForeground");
        if (this.helpColor == null) {
            this.helpColor = Color.LIGHT_GRAY;
        }
        this.getDocument().addDocumentListener(this);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExtTextField.this.applyTextHighlighter(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExtTextField.this.applyTextHighlighter(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExtTextField.this.applyTextHighlighter(e);
            }
        });
        this.helpText = null;
        this.clearHelpTextOnFocus = true;
        this.helperEnabled = true;
        this.highlighters = new CopyOnWriteArrayList();
        this.onChange = new AtomicInteger(0);
        this.provider = provider;
        if (provider != null) {
            provider.register(this, true);
            this.setText(provider.get());
        }
    }

    @Override
    public void onValueModified(ValueProvider<String> owner, final String newValue) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                if (ExtTextField.this.onChange.get() == 0) {
                    ExtTextField.this.setText(newValue);
                }
            }
        };
    }

    @Override
    public void onValueValidationError(ValueProvider<String> owner, String invalidValue, Exception exception) {
    }

    @Override
    public void caretUpdate(CaretEvent arg0) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.isHelperEnabled()) {
            this.onChanged();
            return;
        }
        if (!this.setting) {
            this.onChanged();
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        if (!this.isHelperEnabled()) {
            return;
        }
        if (super.getText().equals(this.helpText)) {
            if (this.isClearHelpTextOnFocus()) {
                this.setText("");
            } else {
                this.selectAll();
            }
        }
        this.setForeground(this.defaultColor);
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        if (!this.isHelperEnabled()) {
            return;
        }
        if (this.getDocument().getLength() == 0 || super.getText().equals(this.helpText)) {
            this.setText(this.helpText);
            this.setForeground(this.helpColor);
        }
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    public Color getHelpColor() {
        return this.helpColor;
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }

    @Override
    public JPopupMenu getPopupMenu(MouseEvent event, AbstractAction cutAction, AbstractAction copyAction, AbstractAction pasteAction, AbstractAction deleteAction, AbstractAction selectAction) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(cutAction);
        menu.add(copyAction);
        menu.add(pasteAction);
        menu.add(deleteAction);
        menu.add(selectAction);
        return menu;
    }

    @Override
    public void replaceSelection(String content) {
        if (this.isHelperEnabled() && super.getText().equals(this.helpText) && StringUtils.isNotEmpty(content)) {
            super.setText("");
        }
        super.replaceSelection(content);
        this.setForeground(this.defaultColor);
    }

    @Override
    public String getText() {
        String ret = super.getText();
        if (!this.isHelperEnabled()) {
            return ret;
        }
        if (ret.equals(this.helpText) && this.getForeground() == this.helpColor) {
            ret = "";
        }
        return ret;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.isHelperEnabled()) {
            this.onChanged();
            return;
        }
        if (!this.setting) {
            this.onChanged();
        }
    }

    public boolean isClearHelpTextOnFocus() {
        return this.clearHelpTextOnFocus;
    }

    public boolean isHelperEnabled() {
        return this.helperEnabled;
    }

    protected void applyTextHighlighter(DocumentEvent e) {
        this.refreshTextHighlighter();
    }

    public void refreshTextHighlighter() {
        Highlighter highlighter = this.getHighlighter();
        highlighter.removeAllHighlights();
        for (ExtTextHighlighter textHighlighter : this.getTextHighlighter()) {
            textHighlighter.highlight(highlighter, this.getText());
        }
    }

    public List<ExtTextHighlighter> getTextHighlighter() {
        return this.highlighters;
    }

    public boolean addTextHighlighter(ExtTextHighlighter highlighter) {
        return highlighter != null && this.highlighters.addIfAbsent(highlighter);
    }

    public boolean removeTextHighlighter(ExtTextHighlighter highlighter) {
        return highlighter != null && this.highlighters.remove(highlighter);
    }

    @Override
    public void onChanged() {
        if (this.provider != null) {
            this.onChange.incrementAndGet();
            try {
                this.provider.set(this.getText());
            }
            finally {
                this.onChange.decrementAndGet();
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.isHelperEnabled()) {
            this.onChanged();
            return;
        }
        if (!this.setting) {
            this.onChanged();
        }
    }

    public void setClearHelpTextOnFocus(boolean b) {
        this.clearHelpTextOnFocus = b;
    }

    @Override
    public void setHelpColor(Color helpColor) {
        this.helpColor = helpColor;
    }

    public void setHelperEnabled(boolean helperEnabled) {
        this.helperEnabled = helperEnabled;
    }

    @Override
    public void setHelpText(String helpText) {
        String old = this.helpText;
        this.helpText = helpText;
        if (this.getText().length() == 0 || this.getText().equals(old)) {
            this.setText(this.helpText);
            this.setToolTipText(this.helpText);
            this.setForeground(this.helpColor);
        }
    }

    public ExtTextField setLabelMode(boolean b) {
        this.setEditable(!b);
        this.setFocusable(!b);
        this.setBorder(b ? null : new JTextArea().getBorder());
        SwingUtils.setOpaque(this, !b);
        return this;
    }

    public ExtTextField text(String text) {
        this.setText(text);
        return this;
    }

    @Override
    public void setText(String t) {
        if (StringUtils.equals(t, this.getText())) {
            return;
        }
        if (!this.isHelperEnabled()) {
            if (StringUtils.equals(t == null ? "" : t, this.getText())) {
                return;
            }
            this.textSetBySetText = t;
            super.setText(t);
            return;
        }
        if (!this.setting) {
            this.setting = true;
            try {
                if (!(this.hasFocus() || this.helpText == null || t != null && t.length() != 0)) {
                    t = this.helpText;
                }
                if (StringUtils.equals(t == null ? "" : t, super.getText())) {
                    return;
                }
                this.textSetBySetText = t;
                super.setText(t);
                if (this.helpText != null) {
                    if (this.helpText.equals(t)) {
                        this.setForeground(this.helpColor);
                    } else {
                        this.setForeground(this.defaultColor);
                    }
                }
            }
            finally {
                this.setting = false;
                this.onChanged();
            }
        }
    }

    public String getTextSetBySetText() {
        return this.textSetBySetText;
    }

    public boolean isUnchangedSetText() {
        return StringUtils.equals(this.textSetBySetText, this.getText());
    }

    public ExtTextField focusable(boolean b) {
        this.setFocusable(b);
        return this;
    }
}

