/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components.pathchooser;

import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.JSonStorage;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.swing.components.ExtTextField;
import org.appwork.swing.components.searchcombo.SearchComboBox;
import org.appwork.utils.StringUtils;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.dialog.ExtFileChooserDialog;
import org.appwork.utils.swing.dialog.FileChooserSelectionMode;
import org.appwork.utils.swing.dialog.FileChooserType;

public class PathChooser
extends MigPanel {
    private static final long serialVersionUID = -3651657642011425583L;
    protected ExtTextField txt;
    protected ExtButton bt;
    private String id;
    protected SearchComboBox<String> destination;

    public PathChooser(String id) {
        this(id, false);
    }

    public PathChooser(String id, boolean useQuickLIst) {
        super("ins 0", "[fill,grow][]", "[fill]");
        this.id = id;
        this.setOpaque(false);
        this.txt = new ExtTextField(){
            private static final long serialVersionUID = 3243788323043431841L;

            @Override
            public String getText() {
                String ret = super.getText();
                if (ret.equals(this.helpText) && this.getForeground() == this.helpColor) {
                    ret = "";
                }
                return ret;
            }

            @Override
            public JPopupMenu getPopupMenu(MouseEvent event, AbstractAction cutAction, AbstractAction copyAction, AbstractAction pasteAction, AbstractAction deleteAction, AbstractAction selectAction) {
                JPopupMenu self = PathChooser.this.getPopupMenu(PathChooser.this.txt, cutAction, copyAction, pasteAction, deleteAction, selectAction);
                if (self == null) {
                    return super.getPopupMenu(event, cutAction, copyAction, pasteAction, deleteAction, selectAction);
                }
                return self;
            }

            @Override
            public void onChanged() {
                PathChooser.this.onChanged(PathChooser.this.txt);
            }
        };
        this.txt.setHelpText(this.getHelpText());
        this.bt = new ExtButton(new BrowseAction());
        if (useQuickLIst) {
            this.txt.setHelperEnabled(false);
            this.destination = new SearchComboBox<String>(){

                @Override
                public JTextField createTextField() {
                    return PathChooser.this.txt;
                }

                @Override
                public String getProtoType(List<String> model) {
                    return PathChooser.this.getProtoType(this, model);
                }

                @Override
                protected Icon getIconForValue(String value) {
                    return null;
                }

                @Override
                protected String getTextForValue(String value) {
                    return value;
                }

                @Override
                public boolean isAutoCompletionEnabled() {
                    return false;
                }

                @Override
                public void onChanged() {
                    PathChooser.this.onChanged(PathChooser.this.txt);
                }

                @Override
                protected void sortFound(String search, List<String> found) {
                    Collections.sort(found, new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.compareTo(o2);
                        }
                    });
                }
            };
            this.destination.getTextField().getInputMap().put(KeyStroke.getKeyStroke("pressed TAB"), "auto");
            this.destination.getTextField().setFocusTraversalKeysEnabled(false);
            this.destination.getTextField().getActionMap().put("auto", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!PathChooser.this.auto(PathChooser.this.txt)) {
                        System.out.println("NExt Fpcus");
                        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                        manager.focusNextComponent();
                    }
                }
            });
            this.destination.setUnkownTextInputAllowed(true);
            this.destination.setBadColor(null);
            this.destination.setSelectedItem(null);
            this.add(this.destination);
        } else {
            this.txt.setHelperEnabled(true);
            this.add(this.txt);
        }
        this.add(this.bt);
        String preSelection = JSonStorage.getStorage("FILECHOOSER").get("LASTSELECTION_" + id, this.getDefaultPreSelection());
        if (preSelection != null) {
            this.setFile(new File(preSelection));
        }
    }

    protected String getProtoType(SearchComboBox<String> comboBox, List<String> model) {
        if (comboBox.usePrototype() && model != null && model.size() > 0) {
            return model.get(0);
        }
        return null;
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.txt.addMouseListener(l);
        this.bt.addMouseListener(l);
        super.addMouseListener(l);
    }

    protected boolean auto(JTextField oldTextField) {
        File root;
        String txt = oldTextField.getText();
        int selstart = oldTextField.getSelectionStart();
        int selend = oldTextField.getSelectionEnd();
        if (selend != txt.length()) {
            return false;
        }
        String sel = txt.substring(selstart, selend);
        String bef = txt.substring(0, selstart);
        String name = bef.endsWith("/") || bef.endsWith("\\") ? "" : new File(bef).getName();
        String findName = txt.endsWith("/") || txt.endsWith("\\") ? "" : new File(txt).getName();
        boolean found = sel.length() == 0;
        for (root = new File(bef); root != null && !root.exists(); root = root.getParentFile()) {
            if (root.getParentFile() != root) continue;
            return false;
        }
        if (root == null) {
            return false;
        }
        for (File f : root.listFiles()) {
            if (f.isFile() || f.isHidden()) continue;
            if (this.equals(f.getName(), findName)) {
                found = true;
                continue;
            }
            if (!found || !this.startsWith(f.getName(), name)) continue;
            oldTextField.setText(f.getAbsolutePath());
            oldTextField.setSelectionStart(selstart);
            oldTextField.setSelectionEnd(oldTextField.getText().length());
            return true;
        }
        oldTextField.setText(bef);
        return false;
    }

    public File doFileChooser() {
        ExtFileChooserDialog d = new ExtFileChooserDialog(0, this.getDialogTitle(), null, null);
        d.setStorageID(this.getID());
        d.setFileSelectionMode(this.getSelectionMode());
        d.setFileFilter(this.getFileFilter());
        d.setType(this.getType());
        d.setMultiSelection(false);
        d.setPreSelection(this.getFile());
        try {
            Dialog.I().showDialog(d);
            return d.getSelectedFile();
        }
        catch (DialogNoAnswerException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean equals(String name, String findName) {
        if (CrossSystem.isWindows()) {
            return name.equalsIgnoreCase(findName);
        }
        return name.equals(findName);
    }

    protected String fileToText(File file2) {
        return file2.getAbsolutePath();
    }

    public String getBrowseLabel() {
        return _AWU.T.pathchooser_browselabel();
    }

    public JButton getButton() {
        this.remove(this.bt);
        this.setLayout(new MigLayout("ins 0", "[grow,fill]", "[grow,fill]"));
        return this.bt;
    }

    protected String getDefaultPreSelection() {
        return null;
    }

    public SearchComboBox<String> getDestination() {
        return this.destination;
    }

    public String getDialogTitle() {
        return _AWU.T.pathchooser_dialog_title();
    }

    public File getFile() {
        if (StringUtils.isEmpty(this.txt.getText())) {
            return null;
        }
        return this.textToFile(this.txt.getText());
    }

    public FileFilter getFileFilter() {
        return null;
    }

    protected String getHelpText() {
        return _AWU.T.pathchooser_helptext();
    }

    public String getID() {
        return this.id;
    }

    public String getPath() {
        return new File(this.txt.getText()).getAbsolutePath();
    }

    public JPopupMenu getPopupMenu(ExtTextField txt, AbstractAction cutAction, AbstractAction copyAction, AbstractAction pasteAction, AbstractAction deleteAction, AbstractAction selectAction) {
        return null;
    }

    public FileChooserSelectionMode getSelectionMode() {
        return FileChooserSelectionMode.DIRECTORIES_ONLY;
    }

    public ExtTextField getTxt() {
        return this.txt;
    }

    public FileChooserType getType() {
        return FileChooserType.SAVE_DIALOG;
    }

    protected void onChanged(ExtTextField txt2) {
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.txt.removeMouseListener(l);
        this.bt.removeMouseListener(l);
        super.removeMouseListener(l);
    }

    @Override
    public void setEnabled(boolean b) {
        this.txt.setEnabled(b);
        this.bt.setEnabled(b);
        if (this.destination != null) {
            this.destination.setEnabled(b);
        }
    }

    public void setFile(File file) {
        String text = this.fileToText(file);
        if (this.destination != null) {
            this.destination.setText(text);
        } else {
            this.txt.setText(text);
        }
    }

    public void setHelpText(String helpText) {
        this.txt.setHelpText(helpText);
        if (this.destination != null) {
            this.destination.setHelpText(helpText);
        }
    }

    public void setPath(String downloadDestination) {
        if (this.destination != null) {
            this.destination.setText(downloadDestination);
        } else {
            this.txt.setText(downloadDestination);
        }
    }

    public void setQuickSelectionList(List<String> quickSelectionList) {
        this.destination.setList(quickSelectionList);
    }

    private boolean startsWith(String name, String name2) {
        if (CrossSystem.isWindows()) {
            return name.toLowerCase(Locale.ENGLISH).startsWith(name2.toLowerCase(Locale.ENGLISH));
        }
        return name.startsWith(name2);
    }

    protected File textToFile(String text) {
        return new File(text);
    }

    private class BrowseAction
    extends AbstractAction {
        private static final long serialVersionUID = -4350861121298607806L;

        BrowseAction() {
            this.putValue("Name", PathChooser.this.getBrowseLabel());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = PathChooser.this.doFileChooser();
            if (file == null) {
                return;
            }
            PathChooser.this.setFile(file);
        }
    }
}

