/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components.tooltips;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.PanelToolTip;
import org.appwork.swing.components.tooltips.TooltipFactory;
import org.appwork.swing.components.tooltips.TooltipPanel;
import org.appwork.utils.swing.SwingUtils;

public class BasicTooltipFactory
implements TooltipFactory {
    private String header;
    private String text;
    private Icon icon;

    public BasicTooltipFactory(String name, String tooltip, Icon icon2) {
        this.header = name;
        this.text = tooltip;
        this.icon = icon2;
    }

    @Override
    public ExtTooltip createTooltip() {
        TooltipPanel p = new TooltipPanel("ins 3", "[][grow,fill]", "[][grow,fill]");
        Color fg = new Color(ExtTooltip.createConfig("default").getForegroundColor());
        JLabel headerLbl = SwingUtils.toBold(new JLabel(this.getHeader()));
        headerLbl.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, fg));
        headerLbl.setForeground(fg);
        JLabel iconLbl = new JLabel(this.getIcon());
        JLabel txt = new JLabel();
        txt.setForeground(fg);
        txt.setText("<html>" + this.getText().replaceAll("[\r\n]+", "<br>") + "</html>");
        p.add((Component)headerLbl, "hidemode 2,spanx,pushx,growx");
        p.add((Component)iconLbl, "hidemode 2");
        p.add(txt);
        return new PanelToolTip(p);
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }
}

