/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components.tooltips;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.tooltips.TooltipPanel;
import org.appwork.swing.components.tooltips.config.ExtTooltipSettings;
import org.appwork.utils.Application;

public abstract class ExtTooltip
extends JToolTip
implements AncestorListener {
    private static final long serialVersionUID = -2212735987320956801L;
    public static final String DEFAULT = "default";
    private final ExtTooltipSettings config;
    protected MigPanel panel;
    private int w = 0;
    private int h = 0;
    private long lastResize;
    private long lastResizeH;
    private final int test = 0;

    public static ExtTooltipSettings createConfig(String id) {
        return JsonConfig.create(Application.getResource("cfg/ExtTooltipSettings_" + id), ExtTooltipSettings.class);
    }

    public static void setForgroundColor(Color black) {
        ExtTooltip.createConfig(DEFAULT).setForegroundColor(black.getRGB());
    }

    public ExtTooltip() {
        this.setLayout(new MigLayout("ins 0", "[grow,fill]", "[grow,fill]"));
        this.config = ExtTooltip.createConfig(this.getID());
        this.panel = this.createContent();
        this.setTipText("");
        if (this.panel != null) {
            this.add(this.panel);
        }
        this.addAncestorListener(this);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        super.addMouseListener(l);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.h = 0;
        this.w = 0;
        this.lastResize = 0L;
        this.lastResizeH = 0L;
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    public abstract TooltipPanel createContent();

    @Override
    public Rectangle getBounds() {
        return super.getBounds();
    }

    @Override
    public Rectangle getBounds(Rectangle rv) {
        return super.getBounds(rv);
    }

    public ExtTooltipSettings getConfig() {
        return this.config;
    }

    @Override
    public int getHeight() {
        if (this.panel == null) {
            return 0;
        }
        Insets insets = this.getInsets();
        int th = this.panel.getPreferredSize().height + insets.top + insets.bottom;
        if (th > this.h) {
            this.h = th;
            Container parent = this.getParent();
            if (parent != null) {
                Rectangle b = parent.getBounds();
                parent.setBounds(b.x, b.y, this.w, this.h);
            }
        } else if (th < this.h && System.currentTimeMillis() - this.lastResizeH > 1000L) {
            this.h = (int)((long)this.h - (long)(this.h - th) * (System.currentTimeMillis() - this.lastResizeH - 1000L) / 10000L);
            Container parent = this.getParent();
            if (parent != null) {
                Rectangle b = parent.getBounds();
                parent.setBounds(b.x, b.y, this.w, this.h);
            }
        }
        return this.h;
    }

    protected String getID() {
        return DEFAULT;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.panel == null) {
            return new Dimension(0, 0);
        }
        Dimension dim = this.panel.getPreferredSize();
        Insets insets = this.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    @Override
    public int getWidth() {
        if (this.panel == null) {
            return 0;
        }
        Insets insets = this.getInsets();
        int tw = this.panel.getPreferredSize().width + insets.left + insets.right;
        if (tw > this.w) {
            this.w = tw;
            Container parent = this.getParent();
            if (parent != null) {
                Rectangle b = parent.getBounds();
                parent.setBounds(b.x, b.y, this.w, this.h);
            }
            this.lastResize = System.currentTimeMillis();
        } else if (tw < this.w && System.currentTimeMillis() - this.lastResize > 1000L) {
            this.w = (int)((long)this.w - (long)(this.w - tw) * (System.currentTimeMillis() - this.lastResize - 1000L) / 10000L);
            Container parent = this.getParent();
            if (parent != null) {
                Rectangle b = parent.getBounds();
                parent.setBounds(b.x, b.y, this.w, this.h);
            }
        }
        return this.w;
    }

    public boolean isLastHiddenEnabled() {
        return true;
    }

    public void onHide() {
    }

    public void onShow() {
    }

    @Override
    public void setMaximumSize(Dimension maximumSize) {
        this.panel.setMaximumSize(maximumSize);
    }

    @Override
    public void paint(Graphics g) {
        if (this.panel != null) {
            this.panel.setSize(this.panel.getPreferredSize());
            Insets insets = this.getInsets();
            this.panel.setLocation(insets.left, insets.top);
        }
        super.paint(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public void paintComponents(Graphics g) {
        super.paintComponents(g);
    }

    public abstract String toText();

    public Point getDesiredLocation(JComponent activeComponent, Point ttPosition) {
        return ttPosition;
    }
}

