/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components.tooltips;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.TooltipPanel;
import org.appwork.utils.swing.SwingUtils;

public class MultiLineLabelTooltip
extends ExtTooltip {
    public MultiLineLabelTooltip(LabelInfo ... labels) {
        this.panel = new TooltipPanel("ins 3,wrap 1", "[grow,fill]", "[grow,fill]");
        for (LabelInfo link : labels) {
            JLabel lbl = new JLabel(link.getText(), link.getIcon(), link.getConstrains());
            this.panel.add(lbl);
            SwingUtils.setOpaque(lbl, false);
            lbl.setForeground(new Color(this.getConfig().getForegroundColor()));
        }
        this.panel.setOpaque(false);
        this.add(this.panel);
    }

    public MultiLineLabelTooltip(ArrayList<LabelInfo> lbls) {
        this(lbls.toArray(new LabelInfo[0]));
    }

    @Override
    public TooltipPanel createContent() {
        return null;
    }

    @Override
    public String toText() {
        return null;
    }

    public static class LabelInfo {
        private String text;
        private Icon icon;
        private int constrains = 10;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public int getConstrains() {
            return this.constrains;
        }

        public void setConstrains(int constrains) {
            this.constrains = constrains;
        }

        public LabelInfo(String text, Icon icon, int constrains) {
            this.text = text;
            this.icon = icon;
            this.constrains = constrains;
        }

        public LabelInfo(String text, Icon icon) {
            this(text, icon, 10);
        }
    }
}

