/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components.tooltips;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.appwork.loggingv3.LogV3;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.ToolTipDelayer;
import org.appwork.swing.components.tooltips.ToolTipHandler;
import org.appwork.swing.components.tooltips.ToolTipPainter;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.swing.EDTRunner;

public class ToolTipController
implements MouseListener,
MouseMotionListener,
WindowFocusListener,
PropertyChangeListener,
AWTEventListener {
    public static final ScheduledExecutorService EXECUTER = Executors.newSingleThreadScheduledExecutor();
    private static final ToolTipController INSTANCE = ToolTipController.create();
    private static final int MEDIUM_WEIGHT_POPUP = 1;
    private ToolTipDelayer delayer;
    private JComponent activeComponent;
    private Point mousePosition;
    private long lastHidden = 0L;
    private int changeDelay = 500;
    private Popup activePopup;
    private ExtTooltip activeToolTipPanel;
    private ToolTipPainter handler;
    protected ToolTipDelayer defaultDelayer;
    private boolean classicToolstipsEnabled = true;
    private static boolean setPopupType = true;

    public static ToolTipController getInstance() {
        return INSTANCE;
    }

    private static ToolTipController create() {
        return new ToolTipController();
    }

    private ToolTipController() {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ToolTipController.this.setDelay(2500);
                Toolkit.getDefaultToolkit().addAWTEventListener(ToolTipController.this, 16L);
            }
        };
    }

    protected ExtTooltip getActiveToolTipPanel() {
        return this.activeToolTipPanel;
    }

    public int getChangeDelay() {
        return this.changeDelay;
    }

    public ToolTipPainter getHandler() {
        return this.handler;
    }

    public void hideTooltip() {
        this.delayer.stop();
        if (this.handler != null) {
            this.handler.hideTooltip();
        }
        if (this.activePopup != null) {
            this.activeToolTipPanel.onHide();
            if (this.activeToolTipPanel.isLastHiddenEnabled()) {
                this.lastHidden = System.currentTimeMillis();
            }
            this.activeToolTipPanel = null;
            this.activePopup.hide();
            this.activePopup = null;
            if (this.activeComponent != null) {
                Window ownerWindow = SwingUtilities.getWindowAncestor(this.activeComponent);
                if (ownerWindow != null) {
                    ownerWindow.removeWindowFocusListener(this);
                }
                if (((ToolTipHandler)((Object)this.activeComponent)).isTooltipDisabledUntilNextRefocus()) {
                    this.activeComponent = null;
                }
            }
        }
    }

    public boolean isTooltipActive() {
        return this.activeToolTipPanel != null;
    }

    private boolean isTooltipVisible() {
        return this.activePopup != null;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event instanceof MouseEvent) {
            switch (event.getID()) {
                case 501: {
                    Container parent;
                    if (event.getSource() instanceof Component && (parent = SwingUtilities.getAncestorOfClass(ExtTooltip.class, (Component)event.getSource())) == this.activeToolTipPanel && parent != null) {
                        return;
                    }
                    this.hideTooltip();
                    this.lastHidden = 0L;
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource() instanceof ToolTipHandler) {
            if (e.getSource() == this.activeComponent) {
                return;
            }
            if (this.activeComponent instanceof JComponent) {
                ToolTipManager.sharedInstance().unregisterComponent(this.activeComponent);
            }
            this.activeComponent = (JComponent)e.getSource();
            if (System.currentTimeMillis() - this.lastHidden < (long)this.getChangeDelay()) {
                this.mousePosition = e.getLocationOnScreen();
                this.showTooltip();
                return;
            }
            this.hideTooltip();
        } else if (!this.mouseOverComponent(e.getLocationOnScreen()) && !this.mouseOverTooltip(e.getLocationOnScreen())) {
            this.hideTooltip();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.mouseOverComponent(e.getLocationOnScreen()) && !this.mouseOverTooltip(e.getLocationOnScreen())) {
            this.hideTooltip();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        JComponent ac = this.activeComponent;
        if (!this.isTooltipVisible() && ac != null) {
            this.mousePosition = e.getLocationOnScreen();
            if (System.currentTimeMillis() - this.lastHidden < (long)this.getChangeDelay()) {
                this.showTooltip();
            } else {
                this.restartDelayer(ac, this.mousePosition);
            }
        } else if (ac != null && ((ToolTipHandler)((Object)ac)).updateTooltip(this.activeToolTipPanel, e)) {
            if (this.activeToolTipPanel == null || this.activeToolTipPanel.isLastHiddenEnabled()) {
                this.mousePosition = e.getLocationOnScreen();
                this.showTooltip();
            } else {
                this.hideTooltip();
            }
        }
    }

    private void restartDelayer(JComponent ac, Point mousePosition2) {
        int newDelayer = ((ToolTipHandler)((Object)ac)).getTooltipDelay(new Point(mousePosition2.x, mousePosition2.y));
        if (newDelayer > 0 && (long)newDelayer != this.delayer.getDelay()) {
            this.delayer.stop();
            this.delayer = new ToolTipDelayer(newDelayer);
        } else if (this.defaultDelayer != this.delayer && newDelayer <= 0) {
            this.delayer.stop();
            this.delayer = this.defaultDelayer;
        }
        this.delayer.resetAndStart();
    }

    private boolean mouseOverComponent(Point point) {
        try {
            if (point != null && this.activeComponent != null && this.activeComponent instanceof JComponent && this.activeComponent.isShowing() && this.activeComponent.getParent() != null) {
                Rectangle bounds = this.activeComponent.getBounds();
                SwingUtilities.convertPointFromScreen(point, this.activeComponent.getParent());
                return bounds.contains(point);
            }
        }
        catch (Exception e) {
            LogV3.log(e);
        }
        return false;
    }

    private boolean mouseOverTooltip(Point locationOnScreen) {
        try {
            if (locationOnScreen != null && this.activeToolTipPanel != null && this.activeToolTipPanel.isShowing()) {
                Dimension d = this.activeToolTipPanel.getSize();
                Point loc = this.activeToolTipPanel.getLocationOnScreen();
                Rectangle bounds = new Rectangle(loc.x, loc.y, d.width, d.height);
                return bounds.contains(locationOnScreen);
            }
        }
        catch (Exception e) {
            LogV3.log(e);
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.hideTooltip();
    }

    public void register(ToolTipHandler component) {
        this.unregister(component);
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        if (component instanceof JComponent) {
            JComponent jC = (JComponent)((Object)component);
            ToolTipManager.sharedInstance().unregisterComponent(jC);
            jC.addPropertyChangeListener("dropLocation", this);
        }
    }

    public void setChangeDelay(int changeDelay) {
        this.changeDelay = changeDelay;
    }

    public synchronized void setDelay(final int delay) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                if (ToolTipController.this.delayer != null) {
                    ToolTipController.this.delayer.stop();
                }
                ToolTipController.this.delayer = new ToolTipDelayer(delay);
                ToolTipController.this.defaultDelayer = ToolTipController.this.delayer;
            }
        }.waitForEDT();
    }

    public void setHandler(ToolTipPainter handler) {
        this.handler = handler;
    }

    public boolean isClassicToolstipsEnabled() {
        return this.classicToolstipsEnabled;
    }

    public void setClassicToolstipsEnabled(boolean classicToolstipsEnabled) {
        this.classicToolstipsEnabled = classicToolstipsEnabled;
    }

    public void show(ExtTooltip tt) {
        this.hideTooltip();
        if (tt != null) {
            if (this.handler != null && this.handler.showToolTip(tt)) {
                return;
            }
            if (this.mousePosition == null) {
                this.mousePosition = MouseInfo.getPointerInfo().getLocation();
            }
            if (this.isClassicToolstipsEnabled()) {
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                GraphicsConfiguration gc = null;
                if (this.activeComponent != null) {
                    gc = this.activeComponent.getGraphicsConfiguration();
                } else {
                    for (GraphicsDevice screen : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                        if (!screen.getDefaultConfiguration().getBounds().contains(this.mousePosition)) continue;
                        gc = screen.getDefaultConfiguration();
                        break;
                    }
                }
                if (gc == null) {
                    return;
                }
                Rectangle screenBounds = gc.getBounds();
                Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
                Point ttPosition = new Point(this.mousePosition.x, this.mousePosition.y);
                screenBounds.x += screenInsets.left;
                screenBounds.y += screenInsets.top;
                screenBounds.width -= screenInsets.left + screenInsets.right;
                screenBounds.height -= screenInsets.top + screenInsets.bottom;
                ttPosition.x = ttPosition.x > screenBounds.x + screenBounds.width / 2 ? this.mousePosition.x - tt.getPreferredSize().width : this.mousePosition.x + 15;
                ttPosition.y = ttPosition.y > screenBounds.y + screenBounds.height / 2 ? this.mousePosition.y - tt.getPreferredSize().height : this.mousePosition.y + 15;
                if (setPopupType) {
                    try {
                        ReflectionUtils.invoke("javax.swing.PopupFactory", "setPopupType", (Object)popupFactory, Void.TYPE, 1);
                    }
                    catch (InvocationTargetException exception) {
                        exception.printStackTrace();
                        setPopupType = false;
                    }
                }
                screenBounds.x += screenInsets.left;
                screenBounds.y += screenInsets.top;
                screenBounds.width -= screenInsets.left + screenInsets.right;
                screenBounds.height -= screenInsets.top + screenInsets.bottom;
                if (ttPosition.x + tt.getPreferredSize().width > screenBounds.x + screenBounds.width) {
                    ttPosition.x = screenBounds.x + screenBounds.width - tt.getPreferredSize().width;
                }
                if (ttPosition.x < screenBounds.x) {
                    ttPosition.x = screenBounds.x;
                }
                int maxWidth = screenBounds.x + screenBounds.width - ttPosition.x;
                int maxHeight = ttPosition.y + tt.getPreferredSize().height - screenBounds.y;
                tt.setMaximumSize(new Dimension(maxWidth, maxHeight));
                tt.setPreferredSize(new Dimension(maxWidth, maxHeight));
                this.activeToolTipPanel = tt;
                tt.addMouseListener(this);
                ttPosition = this.activeToolTipPanel.getDesiredLocation(this.activeComponent, ttPosition);
                this.activePopup = popupFactory.getPopup(this.activeComponent, this.activeToolTipPanel, ttPosition.x, ttPosition.y);
                Window ownerWindow = this.activeComponent != null ? SwingUtilities.getWindowAncestor(this.activeComponent) : null;
                if (ownerWindow != null) {
                    ownerWindow.removeWindowFocusListener(this);
                    ownerWindow.addWindowFocusListener(this);
                }
                tt.onShow();
                this.activePopup.show();
            }
        }
    }

    public void show(ToolTipHandler handler) {
        this.activeComponent = (JComponent)((Object)handler);
        this.mousePosition = MouseInfo.getPointerInfo().getLocation();
        this.showTooltip();
    }

    protected void showTooltip() {
        this.hideTooltip();
        JComponent aC = this.activeComponent;
        boolean focusable = aC != null && aC.isFocusable();
        boolean hasFocus = aC != null && aC.hasFocus();
        boolean tooltipWithoutFocusEnabled = aC != null && ((ToolTipHandler)((Object)aC)).isTooltipWithoutFocusEnabled();
        boolean tooltipVisible = this.isTooltipVisible();
        boolean mouseOverComponent = this.mouseOverComponent(MouseInfo.getPointerInfo().getLocation());
        if (aC != null && (!focusable || hasFocus || tooltipWithoutFocusEnabled) && !tooltipVisible && mouseOverComponent) {
            if (aC instanceof JTable && ((JTable)aC).getDropLocation() != null) {
                System.out.println("drop is going on");
                return;
            }
            Window ownerWindow = SwingUtilities.getWindowAncestor(aC);
            if (ownerWindow.isActive()) {
                Point p = new Point(this.mousePosition);
                SwingUtilities.convertPointFromScreen(p, aC);
                this.show(((ToolTipHandler)((Object)aC)).createExtTooltip(p));
            }
        }
    }

    public void unregister(ToolTipHandler circledProgressBar) {
        if (this.activeComponent == circledProgressBar) {
            this.delayer.stop();
            this.activeComponent = null;
        }
        circledProgressBar.removeMouseListener(this);
        circledProgressBar.removeMouseMotionListener(this);
        if (circledProgressBar instanceof JComponent) {
            JComponent jC = (JComponent)((Object)circledProgressBar);
            jC.removePropertyChangeListener("dropLocation", this);
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.hideTooltip();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

