/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.text.DecimalFormat;
import javax.swing.JComponent;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.formatter.SizeFormatter;

public abstract class ExtFileSizeColumn<E>
extends ExtTextColumn<E> {
    private static final long serialVersionUID = -5812486934156037376L;
    protected final String ltZero = "~";
    protected final DecimalFormat formatter = new DecimalFormat("0.00"){
        private static final long serialVersionUID = 1L;
    };

    public ExtFileSizeColumn(String name) {
        this(name, null);
    }

    public ExtFileSizeColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.rendererField.setHorizontalAlignment(4);
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                long s2;
                long s1 = ExtFileSizeColumn.this.getBytes(o1);
                if (s1 == (s2 = ExtFileSizeColumn.this.getBytes(o2))) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() != "ASC") {
                    return s1 > s2 ? -1 : 1;
                }
                return s1 < s2 ? -1 : 1;
            }
        });
    }

    @Override
    public void configureEditorComponent(E value, boolean isSelected, int row, int column) {
    }

    @Override
    public String getStringValue(E value) {
        long sizeValue = this.getBytes(value);
        if (sizeValue < 0L) {
            return this.getInvalidValue();
        }
        return this.getSizeString(sizeValue);
    }

    protected abstract long getBytes(E var1);

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public JComponent getEditorComponent(E value, boolean isSelected, int row, int column) {
        return null;
    }

    protected String getInvalidValue() {
        return "";
    }

    @Override
    public JComponent getRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.renderer;
    }

    protected String getSizeString(long fileSize) {
        if (fileSize < 0L) {
            return "~";
        }
        return SizeFormatter.formatBytes(this.formatter, fileSize);
    }

    @Override
    protected String getTooltipText(E value) {
        long sizeValue = this.getBytes(value);
        if (sizeValue < 0L) {
            return this.getInvalidValue();
        }
        return this.getSizeString(sizeValue);
    }

    @Override
    public final boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    @Override
    public final void resetEditor() {
    }

    @Override
    public void resetRenderer() {
        this.renderer.setBorder(ExtColumn.DEFAULT_BORDER);
    }

    @Override
    public final void setValue(Object value, E object) {
    }
}

