/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.utils.swing.renderer.RenderLabel;

public abstract class ExtTextAreaColumn<E>
extends ExtColumn<E>
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 2114805529462086691L;
    protected RenderLabel renderer;
    protected JScrollPane editor;
    private final Border defaultBorder = BorderFactory.createEmptyBorder(0, 5, 0, 5);
    private Color rendererForeground;
    private Color editorForeground;
    private Font rendererFont;
    private Font editorFont;
    protected JTextArea txt;
    private int oldRowHeight;
    private int oldRowNum;
    protected final AtomicInteger noSet = new AtomicInteger(0);

    public void setNoSet(boolean b) {
        if (b) {
            this.noSet.incrementAndGet();
        } else if (this.noSet.get() > 0) {
            this.noSet.decrementAndGet();
        }
    }

    public ExtTextAreaColumn(String name) {
        this(name, null);
    }

    public ExtTextAreaColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.txt = new JTextArea();
        InputMap input = this.txt.getInputMap();
        KeyStroke enter = KeyStroke.getKeyStroke("ENTER");
        KeyStroke shiftEnter = KeyStroke.getKeyStroke("shift ENTER");
        Object oldEnter = input.get(enter);
        input.put(enter, "STOP_EDIT");
        input.put(shiftEnter, oldEnter);
        input.put(KeyStroke.getKeyStroke("ESCAPE"), "RESET_EDIT");
        ActionMap actions = this.txt.getActionMap();
        actions.put("RESET_EDIT", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtTextAreaColumn.this.setNoSet(true);
                try {
                    ExtTextAreaColumn.this.stopCellEditing();
                }
                finally {
                    ExtTextAreaColumn.this.setNoSet(false);
                }
            }
        });
        this.txt.setFocusTraversalKeysEnabled(false);
        this.editor = new JScrollPane(this.txt);
        this.txt.addFocusListener(this);
        this.renderer = new RenderLabel(){
            private static final long serialVersionUID = 1856757784567522988L;

            @Override
            public boolean isVisible() {
                return false;
            }
        };
        this.rendererForeground = this.txt.getForeground();
        this.editorForeground = this.txt.getForeground();
        this.rendererFont = this.renderer.getFont();
        this.editorFont = this.txt.getFont();
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                String o1s = ExtTextAreaColumn.this.getStringValue(o1);
                String o2s = ExtTextAreaColumn.this.getStringValue(o2);
                if (o1s == null) {
                    o1s = "";
                }
                if (o2s == null) {
                    o2s = "";
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return o1s.compareTo(o2s);
                }
                return o2s.compareTo(o1s);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireEditingStopped();
    }

    @Override
    public void configureEditorComponent(E value, boolean isSelected, int row, int column) {
        String str = this.getStringValue(value);
        if (str == null) {
            str = "";
        }
        this.txt.setText(str);
        int prefSize = Math.min(this.getMaxHeight(value), Math.max(this.getModel().getTable().getRowHeight(row) + 20, this.txt.getPreferredSize().height));
        if (prefSize != this.getModel().getTable().getRowHeight(row)) {
            this.oldRowHeight = this.getModel().getTable().getRowHeight(row);
            this.oldRowNum = row;
            this.getModel().getTable().setRowHeight(row, prefSize);
        }
    }

    @Override
    public void configureRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        String str = this.getStringValue(value);
        if (str == null) {
            str = "";
        }
        this.renderer.setText(str);
        this.renderer.setIcon(this.getIcon(value));
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!e.isTemporary() || e.getOppositeComponent() == null) {
            this.setNoSet(true);
            try {
                this.stopCellEditing();
            }
            finally {
                this.setNoSet(false);
            }
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.txt.getText();
    }

    @Override
    public JComponent getEditorComponent(E value, boolean isSelected, int row, int column) {
        return this.editor;
    }

    protected Icon getIcon(E value) {
        return null;
    }

    private int getMaxHeight(E value) {
        return 300;
    }

    @Override
    public JComponent getRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.renderer;
    }

    public abstract String getStringValue(E var1);

    @Override
    protected String getTooltipText(E obj) {
        String v = this.getStringValue(obj);
        if (v != null && v.length() > 0) {
            return v;
        }
        return null;
    }

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    @Override
    public boolean matchSearch(E object, Pattern pattern) {
        String value = this.getStringValue(object);
        if (value == null) {
            return false;
        }
        return pattern.matcher(value).matches();
    }

    @Override
    public boolean onRenameClick(MouseEvent e, E obj) {
        if (this.isEditable(obj)) {
            this.startEditing(obj);
            return true;
        }
        return super.onRenameClick(e, obj);
    }

    @Override
    public void resetEditor() {
        this.txt.setFont(this.editorFont);
        this.txt.setForeground(this.editorForeground);
        this.editor.setOpaque(false);
        this.editor.setBackground(null);
        this.editor.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.txt.setOpaque(false);
        this.txt.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.txt.setBackground(null);
    }

    @Override
    public void resetRenderer() {
        this.renderer.setBorder(this.defaultBorder);
        this.renderer.setOpaque(false);
        this.renderer.setBackground(null);
        this.renderer.setFont(this.rendererFont);
        this.renderer.setForeground(this.rendererForeground);
    }

    protected void setStringValue(String value, E object) {
    }

    protected boolean noSet() {
        return this.noSet.get() > 0;
    }

    @Override
    public void setValue(Object value, E object) {
        this.getModel().getTable().setRowHeight(this.oldRowNum, this.oldRowHeight);
        if (!this.noSet()) {
            this.setStringValue((String)value, object);
        }
    }
}

