/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.synthetica;

import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultFactory;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.defaults.AbstractDefaultFactory;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.JVMVersion;

public interface SyntheticaSettings
extends ConfigInterface {
    @RequiresRestart(value="an application Restart is Required")
    @AboutConfig
    public void setLanguage(String var1);

    public String getLanguage();

    @AboutConfig
    @DescriptionForConfigEntry(value="Font to be used. Default value is default. For foreign chars use e.g. Dialog")
    @DefaultStringValue(value="default")
    @RequiresRestart(value="an application Restart is Required")
    public String getFontName();

    @AboutConfig
    @DescriptionForConfigEntry(value="Font scale factor in percent. Default value is 100 which means no font scaling.")
    @DefaultIntValue(value=100)
    @RequiresRestart(value="an application Restart is Required")
    public int getFontScaleFactor();

    @AboutConfig
    @DescriptionForConfigEntry(value="Disable animation and all animation threads. Optional value. Default value is true.")
    @DefaultBooleanValue(value=true)
    @RequiresRestart(value="an application Restart is Required")
    public boolean isAnimationEnabled();

    @AboutConfig
    @DescriptionForConfigEntry(value="Enable/disable support for system DPI settings. Default value is true.")
    @RequiresRestart(value="an application Restart is Required")
    @DefaultFactory(value=DefaultFontRespectsSystemDPI.class)
    public boolean isFontRespectsSystemDPI();

    @AboutConfig
    @DescriptionForConfigEntry(value="Enable/disable window opacity on Java 6u10 and above. A value of 'false' disables window opacity which means that the window corner background which is visible for non-rectangular windows disappear. Furthermore the shadow for popupMenus makes use of real translucent window. Some themes like SyntheticaSimple2D support translucent titlePanes if opacity is disabled. The property is ignored on JRE's below 6u10. Note: It is recommended to activate this feature only if your graphics hardware acceleration is supported by the JVM - a value of 'false' can affect application performance. Default value is false which means the translucency feature is enabled")
    @DefaultBooleanValue(value=true)
    @RequiresRestart(value="an application Restart is Required")
    public boolean isWindowOpaque();

    public void setAnimationEnabled(boolean var1);

    public void setWindowOpaque(boolean var1);

    public void setFontName(String var1);

    public void setFontRespectsSystemDPI(boolean var1);

    public void setFontScaleFactor(int var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Paint all labels/text with or without antialias. Default value is false.")
    @DefaultBooleanValue(value=false)
    @RequiresRestart(value="an application Restart is Required")
    public boolean isTextAntiAliasEnabled();

    public void setTextAntiAliasEnabled(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="(JD09 style)Paint the window title bar.")
    @DefaultBooleanValue(value=false)
    @RequiresRestart(value="an application Restart is Required")
    public boolean isWindowDecorationEnabled();

    public void setWindowDecorationEnabled(boolean var1);

    public static class DefaultFontRespectsSystemDPI
    extends AbstractDefaultFactory<Boolean> {
        @Override
        public Boolean getDefaultValue(KeyHandler<Boolean> keyHandler) {
            if (JVMVersion.isMinimum(9000000000000L)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }
}

