/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.testframework;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.ParameterizedType;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.loggingv3.simple.LogRecord2;
import org.appwork.loggingv3.simple.LoggerToSink;
import org.appwork.loggingv3.simple.SimpleLoggerFactory;
import org.appwork.loggingv3.simple.sink.AbstractSink;
import org.appwork.loggingv3.simple.sink.LogToFileSink;
import org.appwork.loggingv3.simple.sink.LogToStdOutSink;
import org.appwork.loggingv3.simple.sink.SimpleFormatter;
import org.appwork.loggingv3.simple.sink.Sink;
import org.appwork.testframework.IDETestRunner;
import org.appwork.testframework.PostBuildTestInterface;
import org.appwork.testframework.TestInterface;
import org.appwork.utils.Application;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.Exceptions;
import org.appwork.utils.IO;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.net.LineParsingOutputStream;
import org.appwork.utils.reflection.CompiledType;

public abstract class AWTest
implements PostBuildTestInterface,
TestInterface {
    private static volatile boolean TOOLS_JAR_INIT_DONE = false;
    static SimpleFormatter LOG_FORMATER;
    static LogCache CACHE;
    static volatile boolean SILENT;
    static LogToStdOutSink CONSOLE_LOGGER;
    static SimpleLoggerFactory LOGGER;
    private static boolean SINK_ACCESS_GRANTED;

    @Override
    public void runPostBuildTest(String[] args, File workingDirectory) throws Exception {
        this.runTest();
    }

    public static AssertThat assertThat(Object o) {
        return new AssertThat(o);
    }

    public static void assertEqualsDeep(Object a, Object b) throws Exception {
        if (!CompareUtils.equalsDeep(a, b)) {
            throw new Exception("a does not equal b. " + a + "!=" + b);
        }
    }

    public static void assertNull(Object b) throws Exception {
        AWTest.assertEquals(null, b);
    }

    public static void assertEquals(Object a, Object b) throws Exception {
        if (!Objects.equals(a, b)) {
            throw new Exception("a does not equal b. \r\n" + a + " != \r\n" + b);
        }
        if (a != null && b != null && a.hashCode() != b.hashCode()) {
            throw new Exception("a equals b but hashCode is different");
        }
    }

    public static void assertEqualsNot(Object a, Object b) throws Exception {
        if (Objects.equals(a, b)) {
            throw new Exception("a equals b. " + a + "==" + b);
        }
    }

    public void assertEqualsDeepNot(Object a, Object b) throws Exception {
        if (CompareUtils.equalsDeep(a, b)) {
            throw new Exception("Test Failed. 'a' and 'b'  equal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateZipOrJar(String path, InputStream is) throws IOException {
        is = new FilterInputStream(is){

            @Override
            public void close() throws IOException {
            }
        };
        ZipInputStream zipStream = path.toLowerCase(Locale.ROOT).endsWith(".jar") ? new JarInputStream(is, true) : new ZipInputStream(is);
        try {
            ZipEntry e;
            is = null;
            byte[] buffer = new byte[Short.MAX_VALUE];
            if (path.length() > 0) {
                path = path + "!";
            }
            HashSet<String> dupes = new HashSet<String>();
            while ((e = zipStream.getNextEntry()) != null) {
                if (!dupes.add(e.getName())) {
                    throw new IOException("Path Dupe in " + path + e.getName());
                }
                if (!e.isDirectory()) {
                    if (e.getName().toLowerCase(Locale.ROOT).endsWith(".jar") || e.getName().toLowerCase(Locale.ROOT).endsWith(".zip")) {
                        AWTest.validateZipOrJar(path + e.getName(), zipStream);
                    } else {
                        int len;
                        while ((len = zipStream.read(buffer)) != -1) {
                            if (len <= 0) continue;
                        }
                    }
                }
                zipStream.closeEntry();
            }
        }
        finally {
            zipStream.close();
        }
    }

    public static void clearLoggerCache() {
        LogCache cache = CACHE;
        if (cache != null) {
            cache.clear();
        }
    }

    public static void initLogger(SimpleFormatter formater) {
        LogV3.setFactory(new SimpleLoggerFactory(){

            @Override
            public synchronized boolean removeSink(Sink sink) {
                if (!SINK_ACCESS_GRANTED) {
                    return false;
                }
                return super.removeSink(sink);
            }

            @Override
            public void setSinkToConsole(LogToStdOutSink sinkToConsole) {
                if (!SINK_ACCESS_GRANTED) {
                    return;
                }
                super.setSinkToConsole(sinkToConsole);
            }

            @Override
            public void setSinkToFile(LogToFileSink sinkToFile) {
                if (!SINK_ACCESS_GRANTED) {
                    return;
                }
                super.setSinkToFile(sinkToFile);
            }

            @Override
            public boolean addSink(Sink sink) {
                if (!SINK_ACCESS_GRANTED) {
                    return false;
                }
                return super.addSink(sink);
            }

            @Override
            protected LoggerToSink createLogger(Object name) {
                return new LoggerToSink(this){

                    @Override
                    public StackTraceElement getThrownAt() {
                        StackTraceElement last = null;
                        String string = Exceptions.getStackTrace(new Exception());
                        String filterAllUntil = null;
                        if (string.contains("java.lang.Throwable.printStackTrace")) {
                            filterAllUntil = "java.lang.Throwable.printStackTrace";
                        } else if (string.contains("java.io.PrintStream.println")) {
                            filterAllUntil = "java.io.PrintStream.println";
                        }
                        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
                        int n = stackTraceElementArray.length;
                        for (int i = 0; i < n; ++i) {
                            StackTraceElement es;
                            last = es = stackTraceElementArray[i];
                            if (filterAllUntil != null) {
                                if (!(es.getClassName() + "." + es.getMethodName()).equals(filterAllUntil)) continue;
                                filterAllUntil = null;
                                continue;
                            }
                            if (this.filterThrownAtEntries(es)) continue;
                            return es;
                        }
                        return last;
                    }

                    @Override
                    protected boolean filterThrownAtEntries(StackTraceElement es) {
                        if (super.filterThrownAtEntries(es)) {
                            return true;
                        }
                        if (es.getClassName().equals(AWTest.class.getName())) {
                            return true;
                        }
                        return es.getClassName().startsWith(AWTest.class.getPackage().getName() + ".");
                    }
                };
            }
        });
        LOGGER = (SimpleLoggerFactory)LogV3.getFactory();
        AWTest.removeSink(LOGGER.getSinkToFile());
        CONSOLE_LOGGER = new LogToStdOutSink();
        LOG_FORMATER = formater;
        CONSOLE_LOGGER.setFormatter(LOG_FORMATER);
        AWTest.setSinkToConsole(CONSOLE_LOGGER);
    }

    private static void setSinkToConsole(LogToStdOutSink sink) {
        try {
            SINK_ACCESS_GRANTED = true;
            LOGGER.setSinkToConsole(sink);
        }
        finally {
            SINK_ACCESS_GRANTED = false;
        }
    }

    private static synchronized void removeSink(Sink sink) {
        try {
            SINK_ACCESS_GRANTED = true;
            LOGGER.removeSink(sink);
        }
        finally {
            SINK_ACCESS_GRANTED = false;
        }
    }

    public static void releaseLogger() {
        AWTest.setLoggerSilent(false, false);
    }

    public static boolean pauseLogger() {
        return AWTest.setLoggerSilent(true, true);
    }

    public static synchronized boolean setLoggerSilent(boolean silent, boolean cache) {
        if (SILENT == silent) {
            return false;
        }
        if (LOGGER == null) {
            return false;
        }
        SILENT = silent;
        if (silent) {
            AWTest.removeSink(CONSOLE_LOGGER);
            if (cache) {
                CACHE = new LogCache();
                CACHE.setFormatter(LOG_FORMATER);
                AWTest.addSink(CACHE);
            }
        } else {
            AWTest.setSinkToConsole(CONSOLE_LOGGER);
            if (CACHE != null) {
                AWTest.removeSink(CACHE);
                if (cache) {
                    for (LogRecord2 record : CACHE.getBuffer()) {
                        CONSOLE_LOGGER.publish(record);
                    }
                }
                CACHE = null;
            }
        }
        return true;
    }

    public static synchronized List<LogRecord2> getCachedLogRecords() {
        if (CACHE != null) {
            return new ArrayList<LogRecord2>(CACHE.getBuffer());
        }
        return new ArrayList<LogRecord2>();
    }

    private static void addSink(Sink sink) {
        try {
            SINK_ACCESS_GRANTED = true;
            LOGGER.addSink(sink);
        }
        finally {
            SINK_ACCESS_GRANTED = false;
        }
    }

    public static void assertTrue(Boolean b, String message) throws Exception {
        if (!Boolean.TRUE.equals(b)) {
            throw new Exception(message);
        }
    }

    public static void assertFalse(Boolean b, String message) throws Exception {
        if (!Boolean.FALSE.equals(b)) {
            throw new Exception(message);
        }
    }

    public static void assertFalse(Boolean b) throws Exception {
        AWTest.assertFalse(b, "Value=" + b + " Expected=false");
    }

    public static void assertTrue(Boolean b) throws Exception {
        AWTest.assertTrue(b, "Value=" + b + " Expected=true");
    }

    public static File assertFileExists(File file) throws Exception {
        if (!file.exists()) {
            throw new Exception("File/Folder does not exist: " + file);
        }
        return file;
    }

    public static void assertLt(long length, long i) throws Exception {
        if (length >= i) {
            throw new Exception(length + " <= " + i);
        }
    }

    public static void assertPathExistsInZip(File zip, String path) throws Exception {
        ZipFile zipFile = new ZipFile(zip);
        try {
            if (zipFile.getEntry(path) == null) {
                throw new Exception("Path in Zip is missing: " + zip + "!" + path);
            }
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertImageDimension(File zip, String path, int w, int h) throws Exception {
        ZipFile zipFile = new ZipFile(zip);
        try {
            ZipEntry entry = zipFile.getEntry(path);
            if (entry == null) {
                throw new Exception("Path in Zip is missing: " + zip + "!" + path);
            }
            BufferedImage image = ImageIO.read(zipFile.getInputStream(entry));
            if (w != image.getWidth() || h != image.getHeight()) {
                throw new Exception("Image " + zip + "!" + path + " has wrong dimensions: " + image.getWidth() + "/" + image.getHeight() + " (Expected: " + w + "/" + h + ")");
            }
        }
        finally {
            zipFile.close();
        }
    }

    public static void assertPathExistsNotInZip(File zip, String path) throws Exception {
        ZipFile zipFile = new ZipFile(zip);
        try {
            if (zipFile.getEntry(path) != null) {
                throw new Exception("Path in Zip exists: " + zip + "!" + path);
            }
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFromZip(File zip, String path) throws Exception {
        ZipFile zipFile = new ZipFile(zip);
        try {
            ZipEntry entry = zipFile.getEntry(path);
            if (entry == null) {
                throw new Exception("Path in Zip is missing: " + zip + "!" + path);
            }
            String string = IO.readStreamToString(zipFile.getInputStream(entry), -1);
            return string;
        }
        finally {
            zipFile.close();
        }
    }

    public static void assertGt(long length, long i) throws Exception {
        if (length <= i) {
            throw new Exception(length + " <= " + i);
        }
    }

    public static void run() {
        IDETestRunner.run(AWTest.getTestClass());
        LogV3.disableSysout();
    }

    public static Class<? extends TestInterface> getTestClass() {
        StackTraceElement[] st;
        for (StackTraceElement e : st = new Exception().getStackTrace()) {
            if (e.getClassName().startsWith(AWTest.class.getName())) continue;
            try {
                Class<?> cls = Class.forName(e.getClassName());
                if (!TestInterface.class.isAssignableFrom(cls)) continue;
                return cls;
            }
            catch (ClassNotFoundException ex) {
                throw new WTFException(ex);
            }
        }
        throw new WTFException("TestClass not found");
    }

    public static void assertNotNull(Object obj) throws Exception {
        if (obj == null) {
            throw new Exception("Object is null");
        }
    }

    public static void asswertCachedLogsRecordMatches(String pattern) throws Exception {
        for (LogRecord2 lr : AWTest.getCachedLogRecords()) {
            if (!LOG_FORMATER.format(lr).matches(pattern)) continue;
            return;
        }
        AWTest.setLoggerSilent(false, true);
        throw new Exception("Cached Logs do not contain the pattern " + pattern);
    }

    public static void assertType(Object obj, Class<?> cls) throws Exception {
        if (obj == null) {
            throw new Exception("Object " + obj + " is null");
        }
        if (!cls.isAssignableFrom(obj.getClass())) {
            throw new Exception("Object " + obj + " is not of type " + cls.getName());
        }
    }

    public static synchronized void logInfoAnyway(String string) {
        boolean wasSilent = SILENT;
        if (wasSilent) {
            LogCache keepCache = CACHE;
            if (keepCache != null) {
                AWTest.removeSink(keepCache);
            }
            CACHE = null;
            AWTest.releaseLogger();
            LogV3.info(string);
            AWTest.setLoggerSilent(true, false);
            if (keepCache != null) {
                CACHE = keepCache;
                AWTest.addSink(keepCache);
            }
        } else {
            LogV3.info(string);
        }
    }

    public static String verifyJar(File f) throws Exception {
        AWTest.ensureToolsJar();
        PrintStream out = System.out;
        PrintStream err = System.err;
        final StringBuilder outBuffer = new StringBuilder();
        final StringBuilder errBuffer = new StringBuilder();
        System.setOut(new PrintStream(new LineParsingOutputStream(Charset.forName("UTF-8")){

            @Override
            protected void onNextLine(LineParsingOutputStream.NEWLINE newLine, long line, StringBuilder sb, int startIndex, int endIndex) {
                outBuffer.append(sb.substring(startIndex, endIndex) + "\r\n");
            }
        }));
        System.setErr(new PrintStream(new LineParsingOutputStream(Charset.forName("UTF-8")){

            @Override
            protected void onNextLine(LineParsingOutputStream.NEWLINE newLine, long line, StringBuilder sb, int startIndex, int endIndex) {
                errBuffer.append(sb.substring(startIndex, endIndex) + "\r\n");
            }
        }));
        SecurityManager securityManager = null;
        try {
            if (JVMVersion.isMinimum(17000000L) && JVMVersion.get() < 18000000000000L) {
                securityManager = System.getSecurityManager();
                System.setSecurityManager(new SecurityManager(){

                    @Override
                    public void checkExit(int status) {
                        throw new WTFException("Unexpected Exit with code " + status);
                    }

                    @Override
                    public void checkPermission(Permission perm) {
                    }

                    @Override
                    public void checkPackageAccess(String pkg) {
                    }

                    @Override
                    public void checkPermission(Permission perm, Object context) {
                    }
                });
            }
            Class<?> cls = Class.forName("sun.security.tools.jarsigner.Main");
            cls.getDeclaredMethod("main", String[].class).invoke(null, new Object[]{new String[]{"-verify", f.getAbsolutePath()}});
        }
        catch (Exception e) {
            throw new Exception(errBuffer + "\r\n" + outBuffer, e);
        }
        finally {
            if (JVMVersion.isMinimum(17000000L) && JVMVersion.get() < 18000000000000L) {
                System.setSecurityManager(securityManager);
            }
            System.setOut(out);
            System.setErr(err);
        }
        if (errBuffer.length() > 0) {
            throw new Exception("Jar Verify failed: " + errBuffer + "\r\n+" + outBuffer);
        }
        return outBuffer.toString().trim();
    }

    public static synchronized void ensureToolsJar() throws MalformedURLException, IOException {
        if (TOOLS_JAR_INIT_DONE) {
            return;
        }
        if (Application.getJavaVersion() >= 9000000000000L) {
            TOOLS_JAR_INIT_DONE = true;
            return;
        }
        String jvm = Application.getJarFile(String.class).getParentFile().getParentFile().getParentFile().getAbsolutePath();
        File tools = new File(jvm, "lib/tools.jar");
        if (tools.exists()) {
            Application.addUrlToClassPath(tools.toURI().toURL(), AWTest.class.getClassLoader());
            TOOLS_JAR_INIT_DONE = true;
        }
    }

    public static void validateZipOrJar(File zip) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(zip));
        try {
            AWTest.validateZipOrJar(zip.getAbsolutePath(), is);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    static {
        SILENT = false;
        SINK_ACCESS_GRANTED = false;
    }

    public static class AssertThat {
        private Object object;

        public AssertThat(Object o) {
            this.object = o;
        }

        public void is(Object d) throws Exception {
            AWTest.assertEquals(this.object, d);
        }

        public void isNumber(Number n) throws Exception {
            if (this.object instanceof Number) {
                if (!CompareUtils.equalsNumber((Number)this.object, n)) {
                    throw new Exception("a does not equal b. " + this.object + "!=" + n);
                }
            } else {
                throw new Exception("a is not a number " + this.object);
            }
        }

        public void equalsDeep(Object other) throws Exception {
            AWTest.assertEqualsDeep(this.object, other);
        }

        public void isHigherThan(Comparable other) throws Exception {
            if (this.object instanceof Number) {
                AWTest.assertTrue(CompareUtils.compareNumber((Number)this.object, (Number)((Object)other)) > 0);
            } else if (this.object instanceof Comparable) {
                AWTest.assertTrue(((Comparable)this.object).compareTo(other) > 0);
            } else {
                throw new Exception("object is not a comparable");
            }
        }

        public void isLowerThan(Comparable other) throws Exception {
            if (this.object instanceof Number) {
                AWTest.assertTrue(CompareUtils.compareNumber((Number)this.object, (Number)((Object)other)) < 0);
            } else if (this.object instanceof Comparable) {
                AWTest.assertTrue(((Comparable)this.object).compareTo(other) < 0);
            } else {
                throw new Exception("object is not a comparable");
            }
        }

        public void isSameAs(Comparable other) throws Exception {
            if (this.object instanceof Number) {
                AWTest.assertTrue(CompareUtils.compareNumber((Number)this.object, (Number)((Object)other)) == 0);
            } else if (this.object instanceof Comparable) {
                AWTest.assertTrue(((Comparable)this.object).compareTo(other) == 0);
            } else {
                throw new Exception("object is not a comparable");
            }
        }
    }

    public static abstract class AssertAnException<ExceptionType extends Exception> {
        private CompiledType expectedExceptionType = CompiledType.create(((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);

        public abstract void run() throws Exception;

        public void start() throws Exception {
            try {
                this.run();
                throw new Exception("Expected an Exception : " + this.expectedExceptionType);
            }
            catch (Exception e) {
                if (!this.expectedExceptionType.isInstanceOf(e.getClass())) {
                    throw e;
                }
                return;
            }
        }
    }

    public static class LogCache
    extends AbstractSink {
        private final CopyOnWriteArrayList<LogRecord2> buffer = new CopyOnWriteArrayList();

        public List<LogRecord2> getBuffer() {
            return this.buffer;
        }

        @Override
        public void publish(LogRecord2 record) {
            if (record != null) {
                this.buffer.add(record);
            }
        }

        public void clear() {
            this.buffer.clear();
        }
    }
}

