/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.txtresource;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.appwork.storage.FailLevel;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableExample;
import org.appwork.storage.StorableValidateCondition;
import org.appwork.storage.StorableValidateCondition2;
import org.appwork.storage.StorableValidateCondition3;
import org.appwork.storage.StorableValidationLogic;
import org.appwork.storage.TypeRef;
import org.appwork.txtresource.TranslationFactory;

@StorableDoc(value="Localised text map. {\"en\":\"...\"} is the default and fallback language, and must always be set!")
@StorableValidateCondition(value="{en:{\u00a7exists:true,\u00a7ne:null}}", description="At least an english translation is required")
@StorableValidateCondition2(value="{\u00a7keys:{\u00a7each:{\u00a7or:[{\u00a7regex:\"\\\\p{Lower}{2}\"},{\u00a7regex:\"\\\\p{Lower}{2}_\\\\p{Upper}{2}\"},{\u00a7regex:\"\\\\p{Lower}{2}_\\\\p{Upper}{2}_\\\\S+\"}]}}}", description="All keys must match the format \r\n<2 char language code lower case>_<2 char country code upper case>_<Variant id>, \r\nwhile country code and variant id are optional.")
@StorableValidateCondition3(value="{\u00a7node.\u00a7type:STRING}", description="You should use the format {\"en\":\"...\"} instead", level=FailLevel.WARNING, logic=StorableValidationLogic.FAIL_ON_MATCH)
@StorableExample(value="{\"en\":\"Changelog\",\"de\":\"\u00c4nderungen\"}")
public class LocaleMap
extends LinkedHashMap<String, String>
implements Storable {
    private static final long serialVersionUID = 1L;
    public static final TypeRef<LocaleMap> TYPE = new SimpleTypeRef<LocaleMap>((Type)((Object)LocaleMap.class));

    public LocaleMap(String locale, String msg) {
        this.put(locale, msg);
    }

    public LocaleMap append(String locale, String msg) {
        this.put(locale, msg);
        return this;
    }

    public LocaleMap() {
    }

    public LocaleMap(String def) {
        this("en", def);
    }

    public LocaleMap(HashMap<String, String> message) {
        this.putAll(message);
    }

    public static String getBestMatch(HashMap<String, String> message) {
        if (message == null) {
            return null;
        }
        return LocaleMap.getBestMatch(message, TranslationFactory.getDesiredLanguage());
    }

    public static String getBestMatch(HashMap<String, String> message, String localeID) {
        if (message == null || message.size() == 0) {
            return null;
        }
        String ret = message.get(localeID);
        if (ret == null) {
            HashSet<String> variants = new HashSet<String>(TranslationFactory.getVariantsOf(localeID));
            String best = null;
            String lng = null;
            String first = null;
            for (Map.Entry<String, String> es : message.entrySet()) {
                if (es.getValue() != null && first == null) {
                    first = es.getValue();
                }
                for (String v : TranslationFactory.getVariantsOf(es.getKey())) {
                    if (!variants.contains(v) || best != null && v.length() <= best.length()) continue;
                    best = v;
                    lng = es.getKey();
                }
            }
            if (lng != null) {
                ret = message.get(lng);
            }
            if (ret == null) {
                ret = message.get("en");
            }
            if (ret == null) {
                ret = first;
            }
        }
        if (ret == null) {
            return null;
        }
        ret = ret.trim();
        return ret;
    }

    public String resolve() {
        return TranslationFactory.handleLocaleMap(this);
    }
}

