/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.txtresource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import org.appwork.loggingv3.LogV3;
import org.appwork.txtresource.Default;
import org.appwork.txtresource.TranslateData;
import org.appwork.txtresource.TranslatedEntry;
import org.appwork.txtresource.TranslationSource;
import org.appwork.txtresource.TranslationUtils;
import org.appwork.utils.URLStream;

public class TranslateResource {
    private TranslateData data;
    private final String name;
    private URL primaryUrl;
    private URL fallbackURL;
    private boolean fallbackRead;

    public String toString() {
        if (this.primaryUrl == null) {
            return "TranslateResource " + this.name + " (Interface Fallback)";
        }
        return "TranslateResource " + this.name + " (" + this.primaryUrl + "/" + this.fallbackURL + ")";
    }

    public TranslateResource(URL urlFileSystem, URL urlClassPath, String name) {
        if (urlFileSystem != null) {
            this.primaryUrl = urlFileSystem;
            if (urlClassPath != null) {
                this.fallbackURL = urlClassPath;
            }
        } else {
            this.primaryUrl = urlClassPath;
        }
        this.name = name;
    }

    public TranslateData getData() {
        if (this.data == null && this.primaryUrl != null) {
            try {
                String txt = this.read(this.primaryUrl);
                this.data = TranslationUtils.restoreFromString(txt, TranslateData.class);
            }
            catch (Throwable e) {
                LogV3.severe("Error in Translation File: " + this.primaryUrl);
                LogV3.log(e);
                this.data = new TranslateData();
            }
        }
        return this.data;
    }

    public TranslatedEntry getEntry(Method method) throws UnsupportedEncodingException, IOException {
        if (this.primaryUrl == null) {
            return this.readDefaults(method);
        }
        TranslatedEntry ret = this.getEntryFromFile(method);
        if (ret == null) {
            return this.readDefaults(method);
        }
        return ret;
    }

    protected TranslatedEntry getEntryFromFile(Method method) {
        TranslatedEntry ret = null;
        ret = (TranslatedEntry)this.getData().get(method.getName());
        if (ret == null && this.fallbackURL != null && !this.fallbackRead) {
            this.fallbackRead = true;
            try {
                String txt = this.read(this.fallbackURL);
                this.data.merge(TranslationUtils.restoreFromString(txt, TranslateData.class));
            }
            catch (Throwable e) {
                LogV3.severe("Error in Translation File: " + this.fallbackURL);
                LogV3.log(e);
            }
        }
        return ret;
    }

    public TranslationSource getSource(Method method) {
        if (this.primaryUrl == null) {
            Default lngAn = method.getAnnotation(Default.class);
            if (lngAn != null) {
                for (int i = 0; i < lngAn.lngs().length; ++i) {
                    if (!lngAn.lngs()[i].equals(this.name)) continue;
                    return new TranslationSource(this, method, false);
                }
            }
            return null;
        }
        if (this.getEntryFromFile(method) != null) {
            return new TranslationSource(this, method, true);
        }
        Default lngAn = method.getAnnotation(Default.class);
        if (lngAn != null) {
            for (int i = 0; i < lngAn.lngs().length; ++i) {
                if (!lngAn.lngs()[i].equals(this.name)) continue;
                return new TranslationSource(this, method, false);
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read(URL url) throws UnsupportedEncodingException, IOException {
        BufferedReader f = null;
        InputStreamReader isr = null;
        InputStream is = null;
        try {
            String line;
            is = URLStream.openStream(url);
            isr = new InputStreamReader(is, "UTF8");
            f = new BufferedReader(isr);
            StringBuilder ret = new StringBuilder();
            String sep = System.getProperty("line.separator");
            while ((line = f.readLine()) != null) {
                if (ret.length() == 0 && line.startsWith("\ufeff")) {
                    LogV3.warning(url + " is UTF-8 with BOM. Please remove BOM");
                    line = line.substring(1);
                }
                if (line.trim().startsWith("//")) continue;
                if (ret.length() > 0) {
                    ret.append(sep);
                }
                ret.append(line);
            }
            String string = ret.toString();
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
            try {
                f.close();
            }
            catch (Throwable throwable) {}
            try {
                isr.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public TranslatedEntry readDefaults(Method method) {
        Default lngAn = method.getAnnotation(Default.class);
        if (lngAn == null) {
            LogV3.warning("Default missing for: " + method);
            return null;
        }
        for (int i = 0; i < lngAn.lngs().length; ++i) {
            if (!lngAn.lngs()[i].equals(this.name)) continue;
            return new TranslatedEntry(lngAn.values()[i]);
        }
        return null;
    }

    public URL getUrl() {
        return this.primaryUrl;
    }
}

