/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.txtresource;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.appwork.loggingv3.LogV3;
import org.appwork.txtresource.Defaults;
import org.appwork.txtresource.LocaleMap;
import org.appwork.txtresource.TranslateInterface;
import org.appwork.txtresource.TranslationHandler;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Files;
import org.appwork.utils.StringUtils;

public class TranslationFactory {
    private static final HashMap<String, TranslateInterface> CACHE = new HashMap();
    private static String LANGUAGE = "en";

    private static void collectByPath(File path, HashSet<String> ret) {
        List<File> files = Files.getFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".lng");
            }
        }, path);
        if (files != null) {
            for (File file : files) {
                try {
                    String name = file.getName();
                    int index = name.indexOf(".");
                    if (index < 0 || index >= name.length() - 4 || !ret.add(name = name.substring(index + 1, name.length() - 4))) continue;
                    LogV3.info(name + " found in " + file);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static <T extends TranslateInterface> T create(Class<T> class1) {
        return TranslationFactory.create(class1, TranslationFactory.getDesiredLanguage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TranslateInterface> T create(Class<T> class1, String ... lookup) {
        HashMap<String, TranslateInterface> hashMap = CACHE;
        synchronized (hashMap) {
            StringBuilder sb = new StringBuilder();
            sb.append(class1.getName());
            for (String c : lookup) {
                sb.append(c + ";");
            }
            String id = sb.toString();
            TranslateInterface ret = CACHE.get(id);
            if (ret == null) {
                ret = (TranslateInterface)Proxy.newProxyInstance(class1.getClassLoader(), new Class[]{class1}, (InvocationHandler)new TranslationHandler(class1, lookup));
                CACHE.put(id, ret);
            }
            return (T)ret;
        }
    }

    private static void findInClassPath(String path, HashSet<String> ret) {
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(path);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (url.getProtocol().equalsIgnoreCase("jar")) {
                    JarEntry e;
                    String p = url.getPath();
                    int index = p.lastIndexOf(33);
                    String jarPath = p.substring(0, index);
                    String internPath = p.substring(index + 2);
                    JarInputStream jarFile = new JarInputStream(new FileInputStream(new File(new URL(jarPath).toURI())));
                    while ((e = jarFile.getNextJarEntry()) != null) {
                        String name;
                        String jarName = e.getName();
                        if (!jarName.startsWith(internPath) || !jarName.endsWith(".lng") || (index = (name = new File(jarName).getName()).indexOf(".")) < 0 || index >= name.length() - 4 || !ret.add(name = name.substring(index + 1, name.length() - 4))) continue;
                        LogV3.finer(name + " found in " + new File(jarName));
                    }
                    continue;
                }
                TranslationFactory.collectByPath(new File(url.toURI()), ret);
            }
        }
        catch (Exception e) {
            LogV3.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TranslateInterface> getCachedInterfaces() {
        LinkedHashSet<TranslateInterface> ret = new LinkedHashSet<TranslateInterface>();
        HashMap<String, TranslateInterface> hashMap = CACHE;
        synchronized (hashMap) {
            for (TranslateInterface intf : CACHE.values()) {
                if (intf == null) continue;
                ret.add(intf);
            }
        }
        return new ArrayList<TranslateInterface>(ret);
    }

    public static String getDesiredLanguage() {
        return LANGUAGE;
    }

    public static Locale getDesiredLocale() {
        String lng = TranslationFactory.getDesiredLanguage();
        return TranslationFactory.stringToLocale(lng);
    }

    public static String handleLocaleMap(LocaleMap message) {
        if (message == null) {
            return null;
        }
        return TranslationFactory.handleLocaleMap(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String handleLocaleMap(LocaleMap message, Class<? extends TranslateInterface> ... classes) {
        if (message == null) {
            return null;
        }
        String bestmatch = LocaleMap.getBestMatch(message, TranslationFactory.getDesiredLanguage());
        if (bestmatch == null) {
            DebugMode.logInfoInIDEOnly("No Value in LocaleMap");
            return "";
        }
        if (!bestmatch.contains("%")) {
            return bestmatch;
        }
        if (classes != null && classes.length > 0 && classes[0] != null) {
            for (Class<? extends TranslateInterface> t : classes) {
                if (t == null) continue;
                TranslateInterface handler = TranslationFactory.create(t);
                bestmatch = handler._getHandler().replaceWildCards(bestmatch);
            }
        } else {
            HashMap<String, TranslateInterface> hashMap = CACHE;
            synchronized (hashMap) {
                for (Map.Entry<String, TranslateInterface> es : CACHE.entrySet()) {
                    bestmatch = es.getValue()._getHandler().replaceWildCards(bestmatch);
                }
            }
        }
        return bestmatch;
    }

    public static List<String> listAvailableTranslations(Class<? extends TranslateInterface> ... classes) {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        TranslationFactory.collectByPath(Application.getResource("translations"), ret);
        TranslationFactory.findInClassPath("translations", ret);
        for (Class<? extends TranslateInterface> clazz : classes) {
            TranslationFactory.collectByPath(Application.getResource(clazz.getPackage().getName().replace(".", "/")), ret);
            TranslationFactory.findInClassPath(clazz.getPackage().getName().replace(".", "/"), ret);
            Defaults defs = clazz.getAnnotation(Defaults.class);
            if (defs == null) continue;
            for (String s : defs.lngs()) {
                if (!ret.add(s)) continue;
                LogV3.finer(s + " src: " + clazz + " Defaults");
            }
        }
        return new ArrayList<String>(ret);
    }

    public static String localeToString(Locale l) {
        return TranslationFactory.localeToString(l.getLanguage(), l.getCountry(), l.getVariant());
    }

    public static String localeToString(String language, String country, String variant) {
        StringBuilder sb = new StringBuilder();
        sb.append(language);
        String c = country;
        boolean hasCountry = false;
        if (c != null && c.trim().length() > 0) {
            sb.append("_");
            sb.append(c.toUpperCase(Locale.ENGLISH));
            hasCountry = true;
        }
        if ((c = variant) != null && c.trim().length() > 0) {
            if (!hasCountry) {
                sb.append("_");
            }
            sb.append("_");
            sb.append(c);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(TranslationFactory.getVariantsOf("he_IL"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setDesiredLanguage(String loc) {
        if (TranslationFactory.getDesiredLanguage().equals(loc)) {
            return false;
        }
        LANGUAGE = loc;
        ArrayList<String> lst = new ArrayList<String>();
        HashSet<String> dupe = new HashSet<String>();
        if (loc != null && dupe.add(loc)) {
            lst.add(loc);
        }
        HashMap<String, TranslateInterface> hashMap = CACHE;
        synchronized (hashMap) {
            for (TranslateInterface i : CACHE.values()) {
                i._getHandler().setLanguage(loc);
            }
        }
        return true;
    }

    public static Locale stringToLocale(String lng) {
        String[] split = lng.split("[\\-\\_]");
        switch (split.length) {
            case 1: {
                return new Locale(split[0]);
            }
            case 2: {
                return new Locale(split[0], split[1]);
            }
        }
        return new Locale(split[0], split[1], split[2]);
    }

    public static List<String> getVariantsOf(String lng) {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        Locale loc = TranslationFactory.stringToLocale(lng);
        ret.add(TranslationFactory.localeToString(loc.getLanguage(), loc.getCountry(), loc.getVariant()));
        ret.add(TranslationFactory.localeToString(loc.getLanguage(), loc.getCountry(), null));
        ret.add(TranslationFactory.localeToString(loc.getLanguage(), null, loc.getVariant()));
        ret.add(TranslationFactory.localeToString(loc.getLanguage(), null, null));
        if (StringUtils.equalsIgnoreCase("he", lng) || StringUtils.equalsIgnoreCase("yi", lng) || StringUtils.equalsIgnoreCase("id", lng)) {
            ret.add(lng);
        } else if (StringUtils.equalsIgnoreCase("iw", lng)) {
            ret.add("he");
        } else if (StringUtils.equalsIgnoreCase("ji", lng)) {
            ret.add("yi");
        } else if (StringUtils.equalsIgnoreCase("in", lng)) {
            ret.add("id");
        }
        return new ArrayList<String>(ret);
    }

    public static ArrayList<String> localesFromAcceptLanguageHeader(String value) {
        String[] values;
        ArrayList<String> ret = new ArrayList<String>();
        value = value.replace("-", "_");
        for (String v : values = value.split("[,;]+")) {
            if (v.startsWith("q=")) continue;
            Locale l = TranslationFactory.stringToLocale(v);
            String lS = TranslationFactory.localeToString(l);
            if (lS.matches("^[a-zA-Z_]+$")) {
                ret.add(lS);
            }
            ret.add(l.getLanguage());
        }
        return ret;
    }

    static {
        try {
            String v;
            String c;
            String l = Locale.getDefault().getLanguage();
            if (StringUtils.isEmpty(l) && StringUtils.isEmpty(l = Locale.getDefault().getLanguage())) {
                l = "en";
            }
            if (StringUtils.isEmpty(c = System.getProperty("user.country"))) {
                c = Locale.getDefault().getCountry();
            }
            if (StringUtils.isEmpty(v = System.getProperty("user.variant"))) {
                v = Locale.getDefault().getVariant();
            }
            TranslationFactory.setDesiredLanguage(TranslationFactory.localeToString(l, c, v));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

