/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client;

import java.io.File;
import org.appwork.updatesys.transport.exchange.DeduplicationMode;
import org.appwork.updatesys.transport.exchange.DeduplicationSignature;

public class DeduplicationException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected final DeduplicationSignature signature;
    protected final File file;

    public DeduplicationSignature getSignature() {
        return this.signature;
    }

    public DeduplicationMode getMode() {
        DeduplicationSignature signature = this.getSignature();
        if (signature != null) {
            return signature.getMode();
        }
        return null;
    }

    public String getRelPath() {
        DeduplicationSignature signature = this.getSignature();
        if (signature != null) {
            return signature.getRel();
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }

    private static String buildDeduplicationException(DeduplicationSignature signature) {
        if (signature == null) {
            return null;
        }
        return signature.getMode().name() + "|" + signature.getRel();
    }

    public DeduplicationException(DeduplicationSignature signature, File file, Throwable e) {
        super(DeduplicationException.buildDeduplicationException(signature), e);
        this.signature = signature;
        this.file = file;
    }
}

