/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.jardelta;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.updatesys.client.LogAndIgnoreException;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.jardelta.UpdateNotifyInterface;
import org.appwork.updatesys.transport.exchange.RemovedJarFile;
import org.appwork.utils.ByteArrayWrapper;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.logging2.LogInterface;

public class JarDeltaMerge {
    private final File diffFile;
    private final File localFile;
    private final File resultFile;
    private final byte[] buffer = new byte[Short.MAX_VALUE];
    private int outputBufferSize = 0x100000;
    private final HashSet<ByteArrayWrapper> removeFile = new HashSet();
    private final HashSet<ByteArrayWrapper> removeDirectory = new HashSet();
    private final List<byte[]> removeRecursive = new ArrayList<byte[]>();
    private final HashSet<ByteArrayWrapper> modifiedFiles = new HashSet();
    private final HashSet<ByteArrayWrapper> modifiedFolders = new HashSet();
    private boolean logUpdates;
    private final UpdateNotifyInterface callback;
    private final Charset UTF8 = Charset.forName("UTF-8");

    public JarDeltaMerge(File diffFile, File localFile, File resultFile) {
        this(diffFile, localFile, resultFile, null);
    }

    public JarDeltaMerge(File diffFile, File localFile, File resultFile, UpdateNotifyInterface i) {
        this.diffFile = diffFile;
        this.localFile = localFile;
        this.resultFile = resultFile;
        this.callback = i;
    }

    public static final boolean startsWith(byte[] data, byte[] startsWith) {
        if (startsWith.length == 0 || startsWith.length > data.length) {
            return false;
        }
        for (int index = 0; index < startsWith.length; ++index) {
            if (data[index] == startsWith[index]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyJarEntries(UpdateClient updateClient, File sourceFile, JarOutputStream dest, boolean sourceIsDiff) throws IOException {
        int ret;
        block32: {
            LogInterface logger = updateClient.getLogger();
            ret = 0;
            FileAccessHandler fileSystem = updateClient.getFileSystem();
            FileInputStream fis = fileSystem.openFileInputStream(sourceFile);
            ZipInputStream zis = new ZipInputStream(fis);
            block17: while (true) {
                block18: while (true) {
                    boolean isFileEntry;
                    Object pathBytes;
                    ZipEntry sourceEntry;
                    if ((sourceEntry = zis.getNextEntry()) == null) {
                        break block32;
                    }
                    String path = sourceEntry.getName();
                    if (this.diffFile == sourceFile && this.callback != null) {
                        this.callback.onUpdatedJarDiff(path);
                    }
                    if (path.endsWith(".removed")) {
                        RemovedJarFile removedJarFile;
                        FilterInputStream is = new FilterInputStream(zis){

                            @Override
                            public void close() throws IOException {
                            }
                        };
                        try {
                            removedJarFile = RemovedJarFile.readZipEntry(is);
                        }
                        finally {
                            ((InputStream)is).close();
                        }
                        if (!sourceIsDiff) continue;
                        pathBytes = removedJarFile.getPath().getBytes(this.UTF8);
                        ByteArrayWrapper wrapper = new ByteArrayWrapper((byte[])pathBytes, 0, ((byte[])pathBytes).length, false, removedJarFile.getPath().hashCode());
                        switch (removedJarFile.getMode()) {
                            case FILE: {
                                this.removeFile.add(wrapper);
                                continue block17;
                            }
                            case DIRECTORY: {
                                this.removeDirectory.add(wrapper);
                                continue block17;
                            }
                            case RECURSIVE: {
                                this.removeRecursive.add((byte[])pathBytes);
                                continue block17;
                            }
                        }
                        throw new IOException("Unsupported Mode:" + (Object)((Object)removedJarFile.getMode()) + "|Path:" + path);
                    }
                    if ("META-INF/MANIFEST.MF".equals(path)) continue;
                    byte[] pathBytes2 = path.getBytes(this.UTF8);
                    ByteArrayWrapper wrapper = new ByteArrayWrapper(pathBytes2, 0, pathBytes2.length, false, path.hashCode());
                    if (sourceIsDiff) {
                        if (sourceEntry.isDirectory()) {
                            this.modifiedFolders.add(wrapper);
                        } else {
                            this.modifiedFiles.add(wrapper);
                        }
                    } else {
                        if (sourceEntry.isDirectory() ? this.removeDirectory.contains(wrapper) || this.modifiedFolders.contains(wrapper) : this.removeFile.contains(wrapper) || this.modifiedFiles.contains(wrapper)) continue;
                        pathBytes = this.removeRecursive.iterator();
                        while (pathBytes.hasNext()) {
                            byte[] purgePath = (byte[])pathBytes.next();
                            if (!JarDeltaMerge.startsWith(pathBytes2, purgePath)) continue;
                            continue block18;
                        }
                    }
                    if (this.isLogUpdates()) {
                        if (this.diffFile == sourceFile) {
                            logger.info("update:" + sourceEntry.getName() + "|size:" + sourceEntry.getSize() + "|method:" + sourceEntry.getMethod());
                        } else {
                            logger.info("copy:" + sourceEntry.getName() + "|size:" + sourceEntry.getSize() + "|method:" + sourceEntry.getMethod());
                        }
                    }
                    JarEntry destEntry = new JarEntry(sourceEntry.getName());
                    destEntry.setTime(sourceEntry.getTime());
                    destEntry.setExtra(sourceEntry.getExtra());
                    boolean bl = isFileEntry = !sourceEntry.isDirectory();
                    if (isFileEntry) {
                        switch (sourceEntry.getMethod()) {
                            case 0: {
                                destEntry.setMethod(0);
                                destEntry.setSize(sourceEntry.getSize());
                                destEntry.setCompressedSize(sourceEntry.getCompressedSize());
                                destEntry.setCrc(sourceEntry.getCrc());
                                break;
                            }
                            default: {
                                destEntry.setMethod(8);
                            }
                        }
                        dest.putNextEntry(destEntry);
                        FilterInputStream is = new FilterInputStream(zis){

                            @Override
                            public void close() throws IOException {
                            }
                        };
                        try {
                            int len = -1;
                            while ((len = ((InputStream)is).read(this.buffer)) != -1) {
                                if (len <= 0) continue;
                                dest.write(this.buffer, 0, len);
                            }
                        }
                        finally {
                            ((InputStream)is).close();
                        }
                        ++ret;
                        dest.closeEntry();
                        continue;
                    }
                    dest.putNextEntry(destEntry);
                    dest.closeEntry();
                }
                break;
            }
            finally {
                fis.close();
            }
        }
        return ret;
    }

    public boolean isLogUpdates() {
        return this.logUpdates;
    }

    public void setLogUpdates(boolean logUpdates) {
        this.logUpdates = logUpdates;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeJarDelta(UpdateClient updateClient) throws IOException, InterruptedException {
        LogInterface logger = updateClient.getLogger();
        logger.info("Merge Jar " + this.localFile + " + " + this.diffFile + " = " + this.resultFile);
        FileOutputStream stream = null;
        ZipOutputStream out = null;
        FileAccessHandler fileSystem = updateClient.getFileSystem();
        try {
            fileSystem.deleteFileIfExists(this.resultFile);
            fileSystem.mkdirs(this.resultFile.getParentFile());
            stream = fileSystem.openFileOutputStream(this.resultFile, false);
            int bufferSize = this.getOutputBufferSize();
            out = bufferSize > 0 ? new JarOutputStream(new BufferedOutputStream(stream, bufferSize)) : new JarOutputStream(stream);
            if (!this.writeManifest(logger, (JarOutputStream)out, this.diffFile)) {
                this.writeManifest(logger, (JarOutputStream)out, this.localFile);
            }
            int files = this.copyJarEntries(updateClient, this.diffFile, (JarOutputStream)out, true);
            logger.info("Merge Jar:apply delta: " + files);
            files = this.copyJarEntries(updateClient, this.localFile, (JarOutputStream)out, false);
            logger.info("Merge Jar:copy rest: " + files);
            try {
                fileSystem.deleteFileIfExists(this.diffFile);
            }
            catch (ExtIOException e) {
                LogAndIgnoreException.logTo(e, logger);
            }
            logger.info("Merge Jar delete ok");
        }
        finally {
            try {
                this.modifiedFiles.clear();
                this.modifiedFolders.clear();
                this.removeDirectory.clear();
                this.removeFile.clear();
                this.removeRecursive.clear();
            }
            catch (Throwable throwable) {}
            try {
                if (out != null) {
                    out.close();
                    logger.info("close(1)JarOutputStream:" + this.resultFile);
                }
            }
            catch (IOException iOException) {}
            try {
                if (stream != null) {
                    stream.close();
                    logger.info("close(2)FileOutputStream:" + this.resultFile);
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setOutputBufferSize(int outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeManifest(LogInterface logger, JarOutputStream dest, File sourceJar) throws IOException {
        ZipFile source = new ZipFile(sourceJar);
        try {
            ZipEntry sourceEntry = source.getEntry("META-INF/MANIFEST.MF");
            if (sourceEntry != null) {
                boolean bl;
                if (this.diffFile == sourceJar) {
                    logger.info("Update Manifest: " + sourceJar);
                    if (this.callback != null) {
                        this.callback.onUpdatedJarDiff("META-INF/MANIFEST.MF");
                    }
                }
                InputStream input = source.getInputStream(sourceEntry);
                try {
                    int len;
                    ZipEntry destEntry = new ZipEntry(sourceEntry.getName());
                    destEntry.setMethod(8);
                    destEntry.setTime(sourceEntry.getTime());
                    destEntry.setExtra(sourceEntry.getExtra());
                    dest.putNextEntry(destEntry);
                    while ((len = input.read(this.buffer)) != -1) {
                        if (len <= 0) continue;
                        dest.write(this.buffer, 0, len);
                    }
                    dest.closeEntry();
                    bl = true;
                }
                catch (Throwable throwable) {
                    input.close();
                    throw throwable;
                }
                input.close();
                return bl;
            }
        }
        finally {
            source.close();
        }
        return false;
    }
}

