/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.lastchance;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.appwork.updatesys.client.lastchance.LastChanceFailedException;
import org.appwork.updatesys.client.lastchance.LastChanceInterface;
import org.appwork.updatesys.client.lastchance.RemovableClassLoader;
import org.appwork.updatesys.client.locale.UpdTrans;
import org.appwork.utils.Application;
import org.appwork.utils.extioexceptions.CouldNotDeleteFileExtIOException;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.os.CrossSystem;

public class LastChanceUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decryptLastChanceJar(File srcFile, File dstFile, PublicKey publicKey) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        boolean deleteDst = true;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(dstFile);
            byte[] wrappedKey = new byte[256];
            byte[] wrappedIV = new byte[256];
            byte[] readDigest = new byte[32];
            int done = 0;
            int read = 0;
            while (done < 256 && (read = fis.read()) != -1) {
                wrappedKey[done++] = (byte)read;
            }
            done = 0;
            while (done < 256 && (read = fis.read()) != -1) {
                wrappedIV[done++] = (byte)read;
            }
            done = 0;
            while (done < 32 && (read = fis.read()) != -1) {
                readDigest[done++] = (byte)read;
            }
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, publicKey);
            SecretKeySpec key = new SecretKeySpec(cipher.doFinal(wrappedKey), "AES");
            cipher.init(2, publicKey);
            byte[] iv = cipher.doFinal(wrappedIV);
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)key, new IvParameterSpec(iv));
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            CipherInputStream cis = new CipherInputStream(fis, cipher);
            byte[] buffer = new byte[Short.MAX_VALUE];
            int maxReadSize = buffer.length;
            while ((read = cis.read(buffer, 0, maxReadSize)) != -1) {
                if (read <= 0) continue;
                fos.write(buffer, 0, read);
                md.update(buffer, 0, read);
            }
            byte[] generatedDigest = md.digest();
            if (!Arrays.equals(generatedDigest, readDigest)) {
                throw new IOException("Digest Mismatch");
            }
            fos.close();
            deleteDst = false;
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
            if (deleteDst) {
                dstFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lastChanceBasicDownload(String lastChanceURL, File dstFile, int connectTimeout, int readTimeout, HTTPProxy proxy) throws IOException {
        FileOutputStream fos = null;
        boolean deleteDst = true;
        HttpURLConnection conn = null;
        try {
            if (dstFile.exists() && !dstFile.delete()) {
                throw new CouldNotDeleteFileExtIOException(UpdTrans.I().getErrorCouldNotDeleteFILE(dstFile), null, dstFile);
            }
            fos = new FileOutputStream(dstFile);
            URL url = new URL(lastChanceURL);
            Proxy nativeProxy = proxy != null ? proxy.toNativeProxy() : null;
            conn = nativeProxy != null ? (HttpURLConnection)url.openConnection(nativeProxy) : (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Cache-Control", "no-cache, no-store");
            conn.setRequestProperty("Pragma", "no-cache");
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setInstanceFollowRedirects(true);
            byte[] buffer = new byte[Short.MAX_VALUE];
            int read = 0;
            conn.connect();
            if (conn.getResponseCode() == 404) {
                boolean bl = false;
                return bl;
            }
            if (conn.getResponseCode() == 204) {
                boolean bl = false;
                return bl;
            }
            if (conn.getContentType() != null && conn.getContentType().toLowerCase(Locale.ENGLISH).contains("text")) {
                boolean bl = false;
                return bl;
            }
            try {
                while ((read = conn.getInputStream().read(buffer)) != -1) {
                    if (read <= 0) continue;
                    fos.write(buffer, 0, read);
                }
            }
            catch (IOException e) {
                try {
                    while ((read = conn.getErrorStream().read(buffer)) != -1) {
                        if (read <= 0) continue;
                        fos.write(buffer, 0, read);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            deleteDst = false;
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                conn.disconnect();
            }
            catch (Throwable throwable) {}
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
            if (deleteDst) {
                dstFile.delete();
            }
        }
    }

    public static void runLastChanceInterface(File dstFile, Object ... parameters) throws LastChanceFailedException, ClassNotFoundException {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            RemovableClassLoader lastChanceClassLoader = new RemovableClassLoader(dstFile);
            Thread.currentThread().setContextClassLoader(lastChanceClassLoader);
            List<Class<LastChanceInterface>> interfaces = lastChanceClassLoader.listLastChanceInterfaces();
            if (interfaces == null || interfaces.size() == 0) {
                throw new LastChanceFailedException("No Interfaces in Last Chance Jar");
            }
            for (Class<LastChanceInterface> lci : interfaces) {
                lci.newInstance().runInternal(parameters);
            }
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (LastChanceFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new LastChanceFailedException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private static String getJavaBinary() {
        File java;
        String javaHome;
        String osName = System.getProperty("os.name");
        String javaBinary = "java";
        if (osName != null && osName.toLowerCase(Locale.ENGLISH).contains("windows")) {
            javaBinary = "javaw.exe";
        }
        if ((javaHome = System.getProperty("java.home")) != null && (java = new File(new File(javaHome), "/bin/" + javaBinary)).exists() && java.isFile()) {
            return java.getAbsolutePath();
        }
        return javaBinary;
    }

    private static String[] escape(String ... tiny) {
        if (!CrossSystem.isWindows()) {
            return tiny;
        }
        String[] ret = new String[tiny.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = tiny[i].startsWith("\"") && !tiny[i].endsWith("\"") ? "\"" + tiny[i].replace("\"", "\\\"") + "\"" : (!tiny[i].startsWith("\"") && tiny[i].endsWith("\"") ? "\"" + tiny[i].replace("\"", "\\\"") + "\"" : tiny[i]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateExecutableJAR(File file) throws LastChanceFailedException {
        try {
            JarFile jarFile = new JarFile(file);
            try {
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    throw new LastChanceFailedException("JAR(" + file + ") has no manifest!");
                }
                Attributes attributes = manifest.getMainAttributes();
                String mainClass = attributes.getValue("Main-Class");
                if (mainClass == null) {
                    throw new LastChanceFailedException("JAR(" + file + ") has no Main-Class!");
                }
                ZipEntry mainClassFile = jarFile.getEntry(mainClass.replace(".", "/") + ".class");
                if (mainClassFile == null) {
                    throw new LastChanceFailedException("JAR(" + file + ") is missing Main-Class " + mainClass + "!");
                }
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException e) {
            throw new LastChanceFailedException(e);
        }
    }

    public static void runExternal(File dstFile) throws LastChanceFailedException {
        try {
            LastChanceUtils.validateExecutableJAR(dstFile);
            String root = null;
            try {
                root = Application.getTemp().getParent();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ProcessBuilder pb = root != null ? new ProcessBuilder(LastChanceUtils.escape(LastChanceUtils.getJavaBinary(), "-jar", dstFile.getAbsolutePath(), root)) : new ProcessBuilder(LastChanceUtils.escape(LastChanceUtils.getJavaBinary(), "-jar", dstFile.getAbsolutePath()));
            Process process = pb.start();
            System.exit(1);
        }
        catch (LastChanceFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new LastChanceFailedException(e);
        }
    }
}

