/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.servertime;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.servertime.UnsynchronizedStateException;
import org.appwork.updatesys.transport.exchange.SyncProviderInterface;
import org.appwork.updatesys.transport.exchange.SyncedTime;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Time;
import org.appwork.utils.formatter.TimeFormatter;

public class ServerTimeHandler
implements SyncProviderInterface {
    private volatile SyncTimeHolder syncTimeHolder = new SyncTimeHolder(-1L, -1L, -1L);
    private final UpdateClient client;
    private static final long FORCED_RESYNC_INTERVAL = TimeUnit.HOURS.toNanos(6L);
    private boolean unsupportedServer = false;
    private volatile boolean resyncRequested = false;

    public ServerTimeHandler(UpdateClient updateClient) {
        this.client = updateClient;
    }

    public UpdateClient getUpdateClient() {
        return this.client;
    }

    public boolean isUnsupportedServer() {
        return this.unsupportedServer;
    }

    public String toString() {
        SyncTimeHolder now = this.getSyncTime();
        return this.getUpdateClient() + "; Sync Times:\r\nClient: \t" + this.format(now.clientSyncTime) + "\r\nServer: \t" + this.format(now.serverSyncTime) + "(Server ahead: " + this.getMSOffsetServerAheadTime(now) + "ms)\r\nServer Now: \r\n" + this.now(now);
    }

    protected String format(long ms) {
        return new Date(ms) + "." + ms % 1000L;
    }

    public void setUnsupportedServer(boolean unsupportedServer) {
        this.unsupportedServer = unsupportedServer;
    }

    public SyncedTime now() {
        return this.now(this.getSyncTime());
    }

    protected final SyncTimeHolder getSyncTime() {
        return this.syncTimeHolder;
    }

    protected void setSyncTimeHolder(SyncTimeHolder syncTimeHoler) {
        this.syncTimeHolder = syncTimeHoler == null ? new SyncTimeHolder(-1L, -1L, -1L) : syncTimeHoler;
    }

    protected SyncedTime now(SyncTimeHolder syncTimeHolder) {
        if (syncTimeHolder.nanoSecsAtSync != -1L) {
            SyncedTime ret = new SyncedTime(-1L);
            long nanosSinceSync = Time.getNanoSeconds() - syncTimeHolder.nanoSecsAtSync;
            ret._setAtomic(syncTimeHolder.serverSyncTime + TimeUnit.NANOSECONDS.toMillis(nanosSinceSync), SyncedTime.SyncType.SRV);
            return ret;
        }
        if (syncTimeHolder.serverSyncTime > 0L) {
            long timeStamp = Time.timestamp();
            SyncedTime ret = new SyncedTime(Time.getNanoSeconds());
            long offset = this.getMSOffsetServerAheadTime(syncTimeHolder);
            ret._setAtomic(timeStamp + offset, SyncedTime.SyncType.OFF);
            return ret;
        }
        long timeStamp = Time.timestamp();
        SyncedTime ret = new SyncedTime(Time.getNanoSeconds());
        ret._setAtomic(timeStamp, SyncedTime.SyncType.NONE);
        return ret;
    }

    public boolean sync(long referenceLocalTime, long referenceNanos, long serverOffset) {
        SyncTimeHolder before = this.getSyncTime();
        SyncedTime beforeSyncedTime = this.now(before);
        UpdateClient client = this.getUpdateClient();
        client.getLogger().info(client + ": Sync offset: " + serverOffset);
        if (before.isSynced) {
            client.getLogger().info(client + ": Before: " + new Date(before.serverSyncTime) + " +" + TimeFormatter.formatMilliSeconds((Time.getNanoSeconds() - before.nanoSecsAtSync) / 1000000L, 0) + " = " + beforeSyncedTime);
        }
        long offsetBefore = this.getMSOffsetServerAheadTime(before);
        SyncTimeHolder after = new SyncTimeHolder(referenceLocalTime, referenceLocalTime - serverOffset, referenceNanos);
        this.setSyncTimeHolder(after);
        this.resyncRequested = false;
        long offsetAfter = this.getMSOffsetServerAheadTime(after);
        this.onSynced(offsetBefore, offsetAfter);
        SyncedTime afterSyncedTime = this.now(after);
        long diff = beforeSyncedTime.getMs() - afterSyncedTime.getMs();
        client.getLogger().info(client + ": After: " + new Date(after.serverSyncTime) + " +" + TimeFormatter.formatMilliSeconds((Time.getNanoSeconds() - after.nanoSecsAtSync) / 1000000L, 0) + " = " + afterSyncedTime);
        client.getLogger().info(client + ": Diff: " + diff + "/" + offsetAfter);
        return Math.abs(offsetBefore - offsetAfter) > 1000L || !before.isSynced;
    }

    protected void onSynced(long offsetBefore, long offsetAfter) {
    }

    public boolean isSynced() {
        SyncTimeHolder now = this.getSyncTime();
        if (!now.isSynced) {
            return false;
        }
        long timeStamp = Time.timestamp();
        long nano = Time.getNanoSeconds();
        long expectedNow = now.clientSyncTime + TimeUnit.NANOSECONDS.toMillis(nano - now.nanoSecsAtSync);
        long dif = Math.abs(expectedNow - timeStamp);
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            System.out.println(timeStamp - TimeUnit.NANOSECONDS.toMillis(nano - now.nanoSecsAtSync));
            System.out.println(new Date(expectedNow) + "/" + new Date(timeStamp) + " - " + nano / 1000000L);
        }
        return dif <= 1000L;
    }

    public void validateSync(long serverTime, long tolleranceInMS) {
        if (serverTime > 0L) {
            long timeStamp = Time.timestamp();
            long nano = Time.getNanoSeconds();
            SyncTimeHolder now = this.getSyncTime();
            if (!now.isSynced) {
                this.resyncRequested = true;
            } else {
                long dif = serverTime - this.now(now).getMs();
                if (dif > 60000L) {
                    this.resyncRequested = true;
                } else if (dif < -60000L - tolleranceInMS) {
                    this.resyncRequested = true;
                }
            }
            if (this.resyncRequested && this.isUnsupportedServer()) {
                this.sync(timeStamp, nano, timeStamp - serverTime);
            }
        }
    }

    public boolean isResyncRequested() {
        SyncTimeHolder now = this.getSyncTime();
        if (now.isSynced) {
            return this.resyncRequested || Time.getNanoSeconds() - now.nanoSecsAtSync > FORCED_RESYNC_INTERVAL;
        }
        return false;
    }

    protected long getOffset(SyncTimeHolder syncTime) {
        return syncTime.clientSyncTime - syncTime.serverSyncTime;
    }

    public long getOffset() {
        return this.getOffset(this.getSyncTime());
    }

    @Override
    public long getSessionTime(long _ns) {
        SyncTimeHolder now = this.getSyncTime();
        if (now.isSynced) {
            return now.clientSyncTime + TimeUnit.NANOSECONDS.toMillis(_ns - now.nanoSecsAtSync);
        }
        throw new UnsynchronizedStateException(this.getUpdateClient(), this.now(now));
    }

    protected long getMSOffsetServerAheadTime(SyncTimeHolder syncTime) {
        return syncTime.serverSyncTime - syncTime.clientSyncTime;
    }

    @Override
    public long getMSOffsetServerAheadTime() {
        return this.getMSOffsetServerAheadTime(this.getSyncTime());
    }

    private static class SyncTimeHolder {
        private final long clientSyncTime;
        private final long serverSyncTime;
        private final long nanoSecsAtSync;
        private final boolean isSynced;

        private SyncTimeHolder(long clientSyncTime, long serverSyncTime, long nanoSecsAtSync) {
            this.clientSyncTime = clientSyncTime;
            this.serverSyncTime = serverSyncTime;
            this.nanoSecsAtSync = nanoSecsAtSync;
            this.isSynced = nanoSecsAtSync != -1L;
        }
    }
}

