/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange.track;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.appwork.loggingv3.LogV3;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.updatesys.transport.exchange.AbstractTrackDataItem;
import org.appwork.updatesys.transport.exchange.batch.BatchJobType;
import org.appwork.updatesys.transport.exchange.track.TrackDataProviderInterface;
import org.appwork.utils.Application;
import org.appwork.utils.Hash;

public class ExceptionTrackData
extends AbstractTrackDataItem
implements Storable {
    protected String stacktraceID;
    private String threadName;
    private long threadID;
    private Throwable _instance;
    public static final TypeRef<ExceptionTrackData> TYPEREF = new TypeRef<ExceptionTrackData>(ExceptionTrackData.class){};
    private ExceptionStorable exception;

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public long getThreadID() {
        return this.threadID;
    }

    public void setThreadID(long threadID) {
        this.threadID = threadID;
    }

    public String getStacktraceID() {
        return this.stacktraceID;
    }

    public void setStacktraceID(String stacktraceID) {
        this.stacktraceID = stacktraceID;
    }

    public ExceptionTrackData() {
        super(BatchJobType.EXCEPTION);
    }

    public void _setThread(Thread thread) {
        if (thread != null) {
            this.setThreadName(thread.getName());
            this.setThreadID(thread.getId());
        }
    }

    public ExceptionTrackData(Throwable _instance) {
        super(BatchJobType.EXCEPTION);
        this._instance = _instance;
        this.setException(ExceptionTrackData.build(_instance));
        this._setThread(Thread.currentThread());
        this.setStacktraceID(Hash.getSHA256(this.getException().toStackTraceID()));
    }

    public Throwable _getInstance() {
        return this._instance;
    }

    private static ExceptionStorable build(Throwable e) {
        return ExceptionTrackData.buildExceptionStorable(e, new HashSet<Throwable>());
    }

    private static ExceptionStorable buildExceptionStorable(Throwable e, HashSet<Throwable> hashSet) {
        if (!hashSet.add(e)) {
            return null;
        }
        ExceptionStorable ret = new ExceptionStorable();
        if (e instanceof TrackDataProviderInterface) {
            ret.details = ((TrackDataProviderInterface)((Object)e)).getTrackDataMap(ExceptionTrackData.class);
        }
        if (e instanceof OutOfMemoryError) {
            if (ret.details == null) {
                ret.details = new HashMap();
            }
            try {
                MemoryUsage memory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
                if (memory != null) {
                    ret.details.put("heapUsed", memory.getUsed());
                    ret.details.put("heapCommitted", memory.getCommitted());
                    ret.details.put("heapMax", memory.getMax());
                }
            }
            catch (Throwable e2) {
                LogV3.defaultLogger().log(e2);
            }
            try {
                ret.details.put("freeMemory", Runtime.getRuntime().freeMemory());
                ret.details.put("maxMemory", Runtime.getRuntime().maxMemory());
                ret.details.put("totalMemory", Runtime.getRuntime().totalMemory());
            }
            catch (Throwable e2) {
                LogV3.defaultLogger().log(e2);
            }
        }
        ret.clazz = e.getClass().getName();
        ret.message = e.getMessage();
        ret.stacktrace = new ArrayList();
        for (StackTraceElement st : e.getStackTrace()) {
            ret.stacktrace.add(new StackTraceElementStorable(st));
        }
        if (e.getCause() != null) {
            ret.cause = ExceptionTrackData.buildExceptionStorable(e.getCause(), hashSet);
        }
        if (Application.getJavaVersion() >= 17000000L && e.getSuppressed() != null && e.getSuppressed().length > 0) {
            ArrayList<ExceptionStorable> list = new ArrayList<ExceptionStorable>();
            for (Throwable s : e.getSuppressed()) {
                list.add(ExceptionTrackData.build(s));
            }
            ret.suppressed = list;
        }
        return ret;
    }

    public ExceptionStorable getException() {
        return this.exception;
    }

    public void setException(ExceptionStorable exception) {
        this.exception = exception;
    }

    public static class ExceptionStorable
    implements Storable {
        public static final TypeRef<ExceptionStorable> TYPE = new TypeRef<ExceptionStorable>(ExceptionStorable.class){};
        private String clazz;
        private String message;
        private List<StackTraceElementStorable> stacktrace;
        private ExceptionStorable cause;
        private ArrayList<ExceptionStorable> suppressed;
        private HashMap<String, Object> details;

        public String toStackTraceID() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClazz());
            sb.append("\r\n");
            if (this.stacktrace != null) {
                for (StackTraceElementStorable e : this.stacktrace) {
                    sb.append("\r\n");
                    sb.append(e.clazz).append(".").append(e.file).append(".").append(e.line).append(".").append(e.method);
                }
            }
            if (this.cause != null) {
                sb.append(this.cause.toStackTraceID());
            }
            return sb.toString();
        }

        public String getClazz() {
            return this.clazz;
        }

        public void setClazz(String clazz) {
            this.clazz = clazz;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<StackTraceElementStorable> getStacktrace() {
            return this.stacktrace;
        }

        public void setStacktrace(List<StackTraceElementStorable> stacktrace) {
            this.stacktrace = stacktrace;
        }

        public ExceptionStorable getCause() {
            return this.cause;
        }

        public void setCause(ExceptionStorable cause) {
            this.cause = cause;
        }

        @AllowNonStorableObjects
        public HashMap<String, Object> getDetails() {
            return this.details;
        }

        public void setDetails(HashMap<String, Object> details) {
            this.details = details;
        }

        public ArrayList<ExceptionStorable> getSuppressed() {
            return this.suppressed;
        }

        public void setSuppressed(ArrayList<ExceptionStorable> suppressed) {
            this.suppressed = suppressed;
        }
    }

    public static class StackTraceElementStorable
    implements Storable {
        private String file;
        private int line;
        private String method;
        private String clazz;

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getClazz() {
            return this.clazz;
        }

        public void setClazz(String clazz) {
            this.clazz = clazz;
        }

        public StackTraceElementStorable() {
        }

        public StackTraceElementStorable(StackTraceElement st) {
            this.clazz = st.getClassName();
            this.method = st.getMethodName();
            this.line = st.getLineNumber();
            this.file = st.getFileName();
        }
    }
}

