/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.nio.charset.Charset;

public final class ByteArrayWrapper {
    private final byte[] byteArray;
    private final int offset;
    private final int length;
    private final int hashCode;

    public ByteArrayWrapper(byte[] byteArray, boolean clone) {
        this(byteArray, 0, byteArray.length, clone);
    }

    public ByteArrayWrapper(byte[] byteArray, int offset, int length, boolean clone) {
        this(byteArray, offset, length, clone, null);
    }

    public ByteArrayWrapper(byte[] byteArray, int offset, int length, boolean clone, Integer hashCode) {
        if (clone) {
            this.byteArray = new byte[length];
            System.arraycopy(byteArray, offset, this.byteArray, 0, length);
            this.offset = 0;
            this.length = byteArray.length;
        } else {
            this.byteArray = byteArray;
            this.offset = offset;
            this.length = length;
        }
        this.hashCode = hashCode != null ? hashCode.intValue() : this.calcHashCode(this.byteArray, this.offset, this.length);
    }

    private final int calcHashCode(byte[] byteArray, int offset, int length) {
        int result = 1;
        for (int index = offset; index < length; ++index) {
            result = 31 * result + byteArray[index];
        }
        return result;
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ByteArrayWrapper) || this.hashCode() != obj.hashCode()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ByteArrayWrapper other = (ByteArrayWrapper)obj;
        if (other.getLength() != this.getLength()) {
            return false;
        }
        int index2 = other.getOffset();
        for (int index = this.getOffset(); index < this.getLength(); ++index) {
            if (this.getByteArray()[index] != other.getByteArray()[index2]) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    public final byte[] getByteArray() {
        return this.byteArray;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Charset charset) {
        if (charset == null) {
            return new String(this.byteArray, this.offset, this.length);
        }
        return new String(this.byteArray, this.offset, this.length, charset);
    }
}

