/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class CharSequenceUtils {
    public static boolean contentEquals(CharSequence x, CharSequence y) {
        if (x instanceof String) {
            return ((String)x).contentEquals(y);
        }
        if (x == y) {
            return true;
        }
        if (x == null && y != null) {
            return false;
        }
        if (y == null && x != null) {
            return false;
        }
        if (y.length() != x.length()) {
            return false;
        }
        for (int index = 0; index < y.length(); ++index) {
            if (y.charAt(index) == x.charAt(index)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isEmpty(CharSequence value) {
        return value == null || value.length() == 0 || CharSequenceUtils.isEmptyAfterTrim(value);
    }

    public static final boolean isNotEmpty(CharSequence value) {
        return !CharSequenceUtils.isEmpty(value);
    }

    public static int indexOf(CharSequence source, CharSequence target) {
        return CharSequenceUtils.indexOf(source, target, 0);
    }

    public static int indexOf(CharSequence source, CharSequence target, int fromIndex) {
        if (source instanceof String && target instanceof String) {
            return ((String)source).indexOf((String)target, 0);
        }
        return CharSequenceUtils.indexOf(source, 0, target, 0, fromIndex);
    }

    private static int indexOf(CharSequence source, int sourceOffset, CharSequence target, int targetOffset, int fromIndex) {
        int sourceCount = source.length();
        int targetCount = target.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target.charAt(targetOffset);
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source.charAt(i) != first) {
                while (++i <= max && source.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source.charAt(j) == target.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public static CharSequence trim(CharSequence charSequence) {
        int st;
        if (charSequence instanceof String) {
            return ((String)charSequence).trim();
        }
        int len = charSequence.length();
        for (st = 0; st < len && charSequence.charAt(st) <= ' '; ++st) {
        }
        while (st < len && charSequence.charAt(len - 1) <= ' ') {
            --len;
        }
        return st > 0 || len < charSequence.length() ? charSequence.subSequence(st, len) : charSequence;
    }

    public static boolean contains(CharSequence charSequence, CharSequence search) {
        if (charSequence instanceof String && search instanceof String) {
            return ((String)charSequence).contains(search);
        }
        return CharSequenceUtils.indexOf(charSequence, search) != -1;
    }

    public static boolean startsWith(CharSequence charSequence, CharSequence prefix) {
        return CharSequenceUtils.startsWith(charSequence, prefix, 0);
    }

    public static boolean endsWith(CharSequence charSequence, CharSequence suffix) {
        return CharSequenceUtils.startsWith(charSequence, suffix, charSequence.length() - suffix.length());
    }

    public static byte[] getBytes(CharSequence charSequence, Charset cs) {
        if (cs == null) {
            throw new NullPointerException();
        }
        if (charSequence instanceof String) {
            return ((String)charSequence).getBytes(cs);
        }
        CharsetEncoder ce = cs.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        try {
            CharBuffer cb = CharBuffer.wrap(charSequence);
            ByteBuffer bb = ce.encode(cb);
            return bb.array();
        }
        catch (CharacterCodingException e) {
            throw new Error(e);
        }
    }

    public static final boolean isEmptyAfterTrim(CharSequence charSequence) {
        int st;
        int len = charSequence.length();
        if (len == 0) {
            return true;
        }
        for (st = 0; st < len && charSequence.charAt(st) <= ' '; ++st) {
        }
        return st == len;
    }

    public static boolean startsWith(CharSequence charSequence, CharSequence prefix, int toffset) {
        if (charSequence instanceof String && prefix instanceof String) {
            return ((String)charSequence).startsWith((String)prefix, toffset);
        }
        int length = charSequence.length();
        int to = toffset;
        int po = 0;
        int pc = prefix.length();
        if (toffset < 0 || toffset > length - pc) {
            return false;
        }
        while (--pc >= 0) {
            if (charSequence.charAt(to++) == prefix.charAt(po++)) continue;
            return false;
        }
        return true;
    }
}

