/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.appwork.utils.ReflectionUtils;

public class JarHandlerWorkaroundOracle {
    private static final AtomicBoolean INIT = new AtomicBoolean(false);

    public static void init() {
        if (INIT.compareAndSet(false, true)) {
            try {
                final Class<?> oracleWorkaroundJarHandler = Class.forName("org.appwork.utils.OracleWorkaroundJarHandler");
                URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

                    @Override
                    public URLStreamHandler createURLStreamHandler(String protocol) {
                        try {
                            if ("jar".equals(protocol)) {
                                return (URLStreamHandler)oracleWorkaroundJarHandler.newInstance();
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                });
                System.out.println("JarHandlerWorkaroundOracle:setURLStreamHandlerFactory");
                try {
                    Field field = ReflectionUtils.getField("sun.misc.Launcher", "factory", null, URLStreamHandlerFactory.class);
                    final URLStreamHandlerFactory originalFactory = (URLStreamHandlerFactory)field.get(null);
                    URLStreamHandlerFactory workAroundFactory = new URLStreamHandlerFactory(){

                        @Override
                        public URLStreamHandler createURLStreamHandler(String protocol) {
                            try {
                                if ("jar".equals(protocol)) {
                                    return (URLStreamHandler)oracleWorkaroundJarHandler.newInstance();
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                            return originalFactory.createURLStreamHandler(protocol);
                        }
                    };
                    field.set(null, workAroundFactory);
                    System.out.println("JarHandlerWorkaroundOracle:replaceLauncherFactory");
                }
                catch (NoClassDefFoundError field) {
                    // empty catch block
                }
                Object urlClassPath = null;
                ClassLoader cl = JarHandlerWorkaroundOracle.class.getClassLoader();
                try {
                    Field ucp = cl.getClass().getDeclaredField("ucp");
                    ucp.setAccessible(true);
                    urlClassPath = ucp.get(cl);
                }
                catch (NoSuchFieldException e) {
                    try {
                        Field ucp = cl.getClass().getSuperclass().getDeclaredField("ucp");
                        ucp.setAccessible(true);
                        urlClassPath = ucp.get(cl);
                    }
                    catch (NoSuchFieldException e2) {
                        try {
                            Field bcp = ReflectionUtils.getField("sun.misc.Launcher", "bcp", null, null);
                            urlClassPath = bcp.get(null);
                        }
                        catch (NoSuchFieldException bcp) {
                            // empty catch block
                        }
                    }
                }
                if (urlClassPath != null) {
                    System.out.println("JarHandlerWorkaroundOracle:replaceURLClassPath");
                    Field jarHandler = urlClassPath.getClass().getDeclaredField("jarHandler");
                    jarHandler.setAccessible(true);
                    jarHandler.set(urlClassPath, oracleWorkaroundJarHandler.newInstance());
                    System.out.println("JarHandlerWorkaroundOracle:replacejarHandler");
                    Field loadersField = urlClassPath.getClass().getDeclaredField("loaders");
                    loadersField.setAccessible(true);
                    List loaders = (List)loadersField.get(urlClassPath);
                    System.out.println("JarHandlerWorkaroundOracle:replaceLoaders:" + loaders.size());
                    for (int index = 0; index < loaders.size(); ++index) {
                        try {
                            Object loader = loaders.get(index);
                            if (!loader.getClass().getName().endsWith("JarLoader")) continue;
                            Field handlerField = loader.getClass().getDeclaredField("handler");
                            handlerField.setAccessible(true);
                            handlerField.set(loader, oracleWorkaroundJarHandler.newInstance());
                            System.out.println("JarHandlerWorkaroundOracle:replaceLoader:" + index + ":handler");
                            Field baseField = loader.getClass().getSuperclass().getDeclaredField("base");
                            baseField.setAccessible(true);
                            URL base = (URL)baseField.get(loader);
                            handlerField = base.getClass().getDeclaredField("handler");
                            handlerField.setAccessible(true);
                            handlerField.set(base, oracleWorkaroundJarHandler.newInstance());
                            System.out.println("JarHandlerWorkaroundOracle:replaceLoader:" + index + ":handler:" + base);
                            continue;
                        }
                        catch (Throwable ignore) {
                            ignore.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

