/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.event.queue;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.event.queue.QueueThread;

public abstract class Queue {
    protected final Object queueLock = new Object();
    protected boolean debugFlag = false;
    protected final List<QueueAction<?, ? extends Throwable>> queueThreadHistory = new ArrayList(20);
    protected final AtomicReference<QueueThread> thread = new AtomicReference<Object>(null);
    private volatile QueueAction<?, ? extends Throwable> sourceItem = null;
    private volatile QueueAction<?, ?> currentJob;
    protected final AtomicLong addStats = new AtomicLong(0L);
    protected final AtomicLong addWaitStats = new AtomicLong(0L);
    protected final AtomicLong addRunStats = new AtomicLong(0L);
    protected static AtomicInteger QUEUELOOPPREVENTION = new AtomicInteger(0);
    private final String id;
    protected volatile long timeout = 10000L;
    private final ArrayDeque<?>[] queues;
    private final boolean notifyEDT = DebugMode.TRUE_IN_IDE_ELSE_FALSE && Application.isHeadless();

    public Queue(String id) {
        this.id = id;
        QUEUELOOPPREVENTION.incrementAndGet();
        this.queues = new ArrayDeque[QueuePriority.values().length];
        for (int i = 0; i < this.queues.length; ++i) {
            this.queues[i] = new ArrayDeque();
        }
    }

    public <E, T extends Throwable> void add(QueueAction<?, T> action) throws T {
        action.reset();
        action.setCallerThread(this, Thread.currentThread());
        action.onEnqueu(this);
        if (this.isQueueThread(action)) {
            QueueAction<?, Throwable> source = ((QueueThread)Thread.currentThread()).getSourceQueueAction();
            if (source != null) {
                action.setQueuePrio(source.getQueuePrio());
            }
            this.addRunStats.incrementAndGet();
            this.startItem(action, false);
        } else {
            this.addStats.incrementAndGet();
            this.internalAdd(action);
        }
    }

    public <E, T extends Throwable> void addAsynch(QueueAction<?, T> action) {
        if (!action.allowAsync() && this.isQueueThread(action)) {
            throw new RuntimeException("called addAsynch from the queue itself");
        }
        this.addStats.incrementAndGet();
        action.reset();
        action.setCallerThread(this, Thread.currentThread());
        action.onEnqueu(this);
        this.internalAdd(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <E, T extends Throwable> E addWait(QueueAction<E, T> item) throws T {
        block10: {
            if (this.notifyEDT && SwingUtilities.isEventDispatchThread()) {
                new Exception("Inside EDT:" + item).printStackTrace();
            }
            item.reset();
            item.setCallerThread(this, Thread.currentThread());
            item.onEnqueu(this);
            if (this.isQueueThread(item)) {
                QueueAction<?, Throwable> source = ((QueueThread)Thread.currentThread()).getSourceQueueAction();
                if (source != null) {
                    item.setQueuePrio(source.getQueuePrio());
                }
                this.addRunStats.incrementAndGet();
                this.startItem(item, false);
                return item.getResult();
            }
            this.addWaitStats.incrementAndGet();
            this.internalAdd(item);
            try {
                while (!item.isFinished()) {
                    QueueAction<E, T> source = item;
                    synchronized (source) {
                        if (!item.isFinished()) {
                            item.wait(1000L);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                if (item.handleException(e)) break block10;
                Thread.currentThread().interrupt();
            }
        }
        if (item.getExeption() != null && !item.callExceptionHandler()) {
            if (!(item.getExeption() instanceof RuntimeException)) throw item.getExeption();
            throw (RuntimeException)item.getExeption();
        }
        if (!item.gotKilled()) return item.getResult();
        if (item.gotStarted()) return item.getResult();
        item.handleException(new InterruptedException("Queue got killed!"));
        return item.getResult();
    }

    public void enqueue(QueueAction<?, ?> action) {
        action.reset();
        action.setCallerThread(this, Thread.currentThread());
        action.onEnqueu(this);
        this.internalAdd(action);
    }

    protected QueueAction<?, ?> getCurrentJob() {
        return this.currentJob;
    }

    protected final Object getLock() {
        return this.queueLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueueAction<?, ?>> getEntries() {
        ArrayList ret = new ArrayList();
        Object object = this.getLock();
        synchronized (object) {
            QueueAction<?, ?> lcurrentJob = this.currentJob;
            if (lcurrentJob != null) {
                ret.add(this.currentJob);
            }
            for (int i = 0; i < this.queues.length; ++i) {
                ArrayDeque<?> queue = this.queues[i];
                ret.addAll(queue);
            }
        }
        return ret;
    }

    public String getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueueAction<?, ? extends Throwable> getLastHistoryItem() {
        List<QueueAction<?, Throwable>> lQueueThreadHistory;
        List<QueueAction<?, Throwable>> list = lQueueThreadHistory = this.queueThreadHistory;
        synchronized (list) {
            int size = lQueueThreadHistory.size();
            if (size == 0) {
                return null;
            }
            return lQueueThreadHistory.get(size - 1);
        }
    }

    public QueueThread getQueueThread() {
        return this.thread.get();
    }

    protected QueueAction<?, ? extends Throwable> getSourceQueueAction() {
        return this.sourceItem;
    }

    public long getTimeout() {
        return this.timeout;
    }

    protected void handlePreRun() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalAdd(QueueAction<?, ?> action) {
        if (action != null) {
            Object lock;
            Object object = lock = this.queueLock;
            synchronized (object) {
                try {
                    QueuePriority prio = action.getQueuePrio();
                    if (prio != null) {
                        this.queues[prio.ordinal()].offer(action);
                    } else {
                        this.queues[QueuePriority.NORM.ordinal()].offer(action);
                    }
                }
                finally {
                    try {
                        Thread currentThread = this.thread.get();
                        if (currentThread == null || !currentThread.isAlive()) {
                            QueueThread newThread = new QueueThread(this);
                            this.thread.set(newThread);
                            newThread.start();
                        }
                    }
                    finally {
                        lock.notifyAll();
                    }
                }
            }
        }
    }

    public boolean isDebug() {
        return this.debugFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            for (int i = 0; i < this.queues.length; ++i) {
                ArrayDeque<?> queue = this.queues[i];
                if (queue.isEmpty()) continue;
                return false;
            }
            return true;
        }
    }

    public boolean isQueueThread(QueueAction<?, ? extends Throwable> item) {
        if (Thread.currentThread() == this.thread.get()) {
            return true;
        }
        QueueAction<?, Throwable> last = item;
        Thread t = null;
        int loopprevention = 0;
        while (last != null && (t = last.getCallerThread()) != null && t != null && t instanceof QueueThread) {
            if (t == this.getQueueThread()) {
                if (this.debugFlag) {
                    LogV3.warning("Multiple queues detected-> external synchronization may be required! " + item);
                }
                return true;
            }
            last = ((QueueThread)t).getLastHistoryItem();
            if (loopprevention > QUEUELOOPPREVENTION.get()) {
                if (!this.debugFlag) break;
                LogV3.warning("QueueLoopPrevention!");
                break;
            }
            ++loopprevention;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killQueue() {
        ArrayList killList = new ArrayList();
        Iterator iterator = this.getLock();
        synchronized (iterator) {
            System.out.println("Kill: " + this);
            for (ArrayDeque<?> queue : this.queues) {
                killList.addAll(queue);
                queue.clear();
            }
        }
        for (QueueAction item : killList) {
            item.kill();
        }
    }

    protected void onItemHandled(QueueAction<?, ? extends Throwable> item) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(QueueAction<?, ?> action) {
        QueueAction<?, ?> kill = null;
        Object object = this.getLock();
        synchronized (object) {
            QueuePriority prio = action.getQueuePrio();
            if (prio != null && this.queues[prio.ordinal()].remove(action)) {
                kill = action;
            }
            if (kill == null) {
                for (int i = 0; i < this.queues.length; ++i) {
                    ArrayDeque<?> queue = this.queues[i];
                    if (!queue.remove(action)) continue;
                    kill = action;
                    break;
                }
            }
        }
        if (kill != null) {
            kill.kill();
            return true;
        }
        return false;
    }

    private QueueAction<?, ? extends Throwable> poll() {
        for (int i = 0; i < this.queues.length; ++i) {
            ArrayDeque<?> queue = this.queues[i];
            QueueAction ret = (QueueAction)queue.poll();
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void runQueue() {
        try {
            QueueAction<?, Throwable> item = null;
            while (true) {
                block21: {
                    Object lock;
                    this.handlePreRun();
                    Object object = lock = this.getLock();
                    // MONITORENTER : object
                    item = this.poll();
                    if (item != null) break block21;
                    lock.wait(this.getTimeout());
                    item = this.poll();
                    if (item != null) break block21;
                    Thread lThread = Thread.currentThread();
                    if (lThread instanceof QueueThread) {
                        this.thread.compareAndSet((QueueThread)lThread, null);
                    }
                    // MONITOREXIT : object
                    Object object2 = this.getLock();
                    // MONITORENTER : object2
                    Thread lThread2 = Thread.currentThread();
                    if (lThread2 instanceof QueueThread) {
                        this.thread.compareAndSet((QueueThread)lThread2, null);
                    }
                    // MONITOREXIT : object2
                    return;
                }
                try {
                    // MONITOREXIT : object
                    if (!this.handleItem(item)) continue;
                    try {
                        this.sourceItem = item;
                        this.startItem(item, true);
                    }
                    catch (Throwable throwable) {}
                    continue;
                    finally {
                        this.sourceItem = null;
                        this.onItemHandled(item);
                    }
                }
                catch (Throwable e) {
                    LogV3.info("Queue rescued!");
                    LogV3.log(e);
                }
                continue;
                break;
            }
        }
        catch (Throwable throwable) {
            Object object = this.getLock();
            // MONITORENTER : object
            Thread lThread = Thread.currentThread();
            if (lThread instanceof QueueThread) {
                this.thread.compareAndSet((QueueThread)lThread, null);
            }
            // MONITOREXIT : object
            throw throwable;
        }
    }

    protected boolean handleItem(QueueAction<?, ? extends Throwable> item) {
        return true;
    }

    public void setDebug(boolean b) {
        this.debugFlag = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(long timeout) {
        Object lock;
        timeout = Math.max(0L, timeout);
        Object object = lock = this.getLock();
        synchronized (object) {
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.getLock();
        synchronized (object) {
            int ret = 0;
            for (int i = 0; i < this.queues.length; ++i) {
                ArrayDeque<?> queue = this.queues[i];
                ret += queue.size();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends Throwable> void startItem(QueueAction<?, T> item, boolean callExceptionhandler) throws T {
        List<QueueAction<?, ? extends Throwable>> list;
        try {
            this.currentJob = item;
            if (this.getQueueThread() != item.getCallerThread()) {
                list = this.queueThreadHistory;
                synchronized (list) {
                    this.queueThreadHistory.add(item);
                }
            }
            item.start(this);
        }
        catch (Throwable e) {
            if (!callExceptionhandler || !item.callExceptionHandler()) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw e;
            }
        }
        finally {
            if (this.getQueueThread() != item.getCallerThread()) {
                list = this.queueThreadHistory;
                synchronized (list) {
                    int size = this.queueThreadHistory.size();
                    if (size != 0) {
                        this.queueThreadHistory.remove(size - 1);
                    }
                }
            }
            item.setFinished(true);
            this.currentJob = null;
        }
    }

    public String toString() {
        return this.id + ": add=" + this.addStats.get() + " addWait=" + this.addWaitStats.get() + " addRun=" + this.addRunStats.get();
    }

    public static enum QueuePriority {
        HIGH,
        NORM,
        LOW;

    }
}

