/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.formatter;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.Regex;
import org.appwork.utils.formatter.StringFormatter;
import org.appwork.utils.locale._AWU;

public class TimeFormatter {
    private static final List<SimpleDateFormat> dateformats = new ArrayList<SimpleDateFormat>();
    public static final int HIDE_SECONDS = 2;
    public static final int HIDE_MARKER = 4;
    public static final int CLOCK = 8;

    public static String formatMilliSeconds(long totalSeconds, int flags) {
        return TimeFormatter.formatSeconds(totalSeconds / 1000L, flags);
    }

    public static String formatSeconds(long totalSeconds, int flags) {
        StringBuilder string = new StringBuilder();
        long days = totalSeconds / 86400L;
        long hours = (totalSeconds -= days * 24L * 60L * 60L) / 3600L;
        long minutes = (totalSeconds -= hours * 60L * 60L) / 60L;
        long seconds = totalSeconds - minutes * 60L;
        if (!BinaryLogic.containsAll(flags, 8)) {
            if (days != 0L) {
                string.append(days);
                string.append('d');
            }
        } else if (days != 0L) {
            hours += days * 24L;
        }
        if (hours != 0L || string.length() != 0 || BinaryLogic.containsAll(flags, 8)) {
            if (string.length() != 0) {
                string.append(':');
            }
            string.append(hours);
            if (BinaryLogic.containsNone(flags, 4)) {
                string.append(_AWU.T.Timeformater_short_hours());
            }
        }
        if (minutes != 0L || string.length() != 0 || BinaryLogic.containsAll(flags, 8)) {
            if (string.length() != 0) {
                string.append(':');
            }
            string.append(StringFormatter.fillStart(minutes + "", 2, "0"));
            if (BinaryLogic.containsNone(flags, 4)) {
                string.append(_AWU.T.Timeformater_short_minute());
            }
        }
        if (BinaryLogic.containsNone(flags, 2)) {
            if (string.length() != 0) {
                string.append(':');
            }
            string.append(StringFormatter.fillStart(seconds + "", 2, "0"));
            if (BinaryLogic.containsNone(flags, 4)) {
                string.append(_AWU.T.Timeformater_short_seconds());
            }
        }
        return string.toString();
    }

    public static long formatStringToMilliseconds(String text) {
        String[] found = new Regex(text, "(\\d+)\\w?:(\\d+)").getRow(0);
        if (found == null) {
            return 0L;
        }
        int hours = Integer.parseInt(found[0]);
        int minutes = Integer.parseInt(found[1]);
        if (hours >= 24) {
            hours = 24;
            minutes = 0;
        }
        if (minutes >= 60) {
            ++hours;
            minutes = 0;
        }
        return hours * 60 * 60 * 1000 + minutes * 60 * 1000;
    }

    public static long getMilliSeconds(String wait) {
        String[][] matches = new Regex(wait, "([\\d]+) ?[\\.|\\,|\\:] ?([\\d]+)").getMatches();
        if (matches == null || matches.length == 0) {
            matches = new Regex(wait, Pattern.compile("([\\d]+)")).getMatches();
        }
        if (matches == null || matches.length == 0) {
            return -1L;
        }
        double res = 0.0;
        if (matches[0].length == 1) {
            res = Double.parseDouble(matches[0][0]);
        }
        if (matches[0].length == 2) {
            res = Double.parseDouble(matches[0][0] + "." + matches[0][1]);
        }
        res = Regex.matches((Object)wait, Pattern.compile("(h|st)", 2)) ? (res *= 3600000.0) : (Regex.matches((Object)wait, Pattern.compile("(m)", 2)) ? (res *= 60000.0) : (res *= 1000.0));
        return Math.round(res);
    }

    public static long getMilliSeconds(String dateString, String timeformat, Locale l) {
        if (dateString != null) {
            SimpleDateFormat dateFormat = l != null ? new SimpleDateFormat(timeformat, l) : new SimpleDateFormat(timeformat, Locale.ENGLISH);
            try {
                if (timeformat.contains("'Z'")) {
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                }
                return dateFormat.parse(dateString).getTime();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1L;
    }

    public static Date parseDateString(String date) {
        if (date != null) {
            Date ret = TimeFormatter.parseDateString(date, false);
            if (ret != null) {
                return ret;
            }
            return TimeFormatter.parseDateString(date, true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateString(String date, boolean fix) {
        if (date != null) {
            for (SimpleDateFormat format : dateformats) {
                String parseDate = date.trim();
                if (fix) {
                    DateFormatSymbols symbols = format.getDateFormatSymbols();
                    for (String shortWeekDay : symbols.getShortWeekdays()) {
                        if (shortWeekDay == null || shortWeekDay.length() <= 0 || !parseDate.contains(shortWeekDay)) continue;
                        parseDate = parseDate.replaceAll("(" + Pattern.quote(shortWeekDay) + "[a-zA-Z]+)", shortWeekDay);
                        break;
                    }
                    for (String shortMonth : symbols.getShortMonths()) {
                        if (shortMonth == null || shortMonth.length() <= 0 || !parseDate.contains(shortMonth)) continue;
                        parseDate = parseDate.replaceAll("(" + Pattern.quote(shortMonth) + "[a-zA-Z]+)", shortMonth);
                        break;
                    }
                }
                try {
                    SimpleDateFormat simpleDateFormat = format;
                    synchronized (simpleDateFormat) {
                        return format.parse(parseDate);
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }
        return null;
    }

    public static long getTimestampByGregorianTime(String date) throws DatatypeConfigurationException {
        DatatypeFactory f = DatatypeFactory.newInstance();
        XMLGregorianCalendar xgc = f.newXMLGregorianCalendar(date);
        return xgc.toGregorianCalendar().getTime().getTime();
    }

    static {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.UK);
            dateformats.add(sdf);
            sdf.setLenient(false);
            sdf = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss zzz", Locale.UK);
            dateformats.add(sdf);
            sdf.setLenient(false);
            sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy z", Locale.UK);
            dateformats.add(sdf);
            sdf.setLenient(false);
            sdf = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss z", Locale.UK);
            dateformats.add(sdf);
            sdf.setLenient(false);
            sdf = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.UK);
            dateformats.add(sdf);
            sdf.setLenient(false);
            sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss z", Locale.UK);
            dateformats.add(sdf);
            sdf.setLenient(false);
            sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.UK);
            dateformats.add(sdf);
            sdf.setLenient(false);
            sdf = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z", Locale.UK);
            dateformats.add(sdf);
            sdf.setLenient(false);
            sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.UK);
            dateformats.add(sdf);
            sdf.setLenient(false);
            sdf = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.UK);
            dateformats.add(sdf);
            sdf.setLenient(false);
            sdf = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss z", Locale.UK);
            dateformats.add(sdf);
            sdf.setLenient(false);
            if (JVMVersion.isMinimum(17000000L)) {
                sdf = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'SSSX", Locale.UK);
                dateformats.add(sdf);
                sdf.setLenient(false);
            }
            sdf = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.UK);
            dateformats.add(sdf);
            sdf.setLenient(true);
            sdf = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT+0000'", Locale.UK);
            dateformats.add(sdf);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT+0000"));
            sdf.setLenient(false);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

