/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images.svg;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.parser.SVGLoader;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;

public class WeisjJSVG {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImageFromSVG(InputStream inputStream, int w, int h, Color backgroundColor) throws IOException {
        try {
            SVGLoader loader = new SVGLoader();
            SVGDocument svgDocument = loader.load(inputStream);
            if (svgDocument != null) {
                double scaleWidth;
                FloatSize size = svgDocument.size();
                if (w <= 0) {
                    w = (int)size.getWidth();
                }
                if (h <= 0) {
                    h = (int)size.getHeight();
                }
                double scaleHeight = scaleWidth = 1.0 / Math.max(size.getWidth() / (double)w, size.getHeight() / (double)h);
                int width = Math.max((int)(size.getWidth() * scaleWidth), 1);
                int height = Math.max((int)(size.getHeight() * scaleHeight), 1);
                BufferedImage bi = new BufferedImage(width, height, 6);
                Graphics2D g = bi.createGraphics();
                try {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    if (backgroundColor != null) {
                        g.setComposite(AlphaComposite.Src);
                        g.setColor(backgroundColor);
                        g.fillRect(0, 0, width, height);
                        g.setComposite(AlphaComposite.SrcAtop);
                    }
                    if (scaleWidth != 1.0 || scaleHeight != 1.0) {
                        g.scale(scaleWidth, scaleHeight);
                    }
                    svgDocument.render(null, g);
                }
                finally {
                    g.dispose();
                }
                return bi;
            }
            return null;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }
}

