/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images.svg;

import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.images.svg.SVGFactory;
import org.appwork.utils.images.svg.WeisjJSVG;

public class WeisjJSVGFactory
implements SVGFactory {
    private static Boolean SUPPORTED = null;

    @Override
    public boolean isSupported() {
        try {
            if (SUPPORTED == null) {
                SUPPORTED = JVMVersion.isMinimum(18000000L) && Class.forName("com.github.weisj.jsvg.parser.SVGLoader") != null;
            }
            return SUPPORTED;
        }
        catch (ClassNotFoundException e) {
            SUPPORTED = false;
            return false;
        }
    }

    @Override
    public Image getImageFromSVG(URL url, int w, int h) throws IOException {
        return this.getImageFromSVG(url, w, h, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Image getImageFromSVG(URL url, int w, int h, Color color) throws IOException {
        try {
            InputStream is = null;
            try {
                is = url.openStream();
                if (is == null) throw new IOException("Not found:" + url);
                Image image = this.getImageFromSVG(is, w, h, color);
                return image;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException("URL:" + url, e);
        }
    }

    @Override
    public Image getImageFromSVG(InputStream inputStream, int w, int h, Color color) throws IOException {
        return WeisjJSVG.getImageFromSVG(inputStream, w, h, color);
    }
}

