/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.utils.Application;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;

public class LogSorter {
    public static void main(String[] args) throws DialogClosedException, DialogCanceledException {
        Application.setApplication(".appwork");
        String log = Dialog.getInstance().showInputDialog(64, "Log", null);
        Pattern pattern = Pattern.compile("\\-\\-ID:\\d+TS\\:\\d+\\-");
        Pattern thread = Pattern.compile("^------------------------Thread\\: (\\d)\\:([^\r\n]+?)-----------------------[\r\n]+");
        ArrayList<LogLine> lines = new ArrayList<LogLine>();
        String threadID = null;
        HashMap<String, String> threads = new HashMap<String, String>();
        while (log.length() > 0) {
            Matcher matcher;
            if (log.trim().startsWith("------------------------Thread: ") && (matcher = thread.matcher(log)).find()) {
                String all = matcher.group(0);
                String id = matcher.group(1);
                String name = matcher.group(2);
                threads.put(id.trim(), name.trim());
                threadID = id.trim();
                log = log.substring(all.length());
            }
            matcher = pattern.matcher(log);
            int index = 0;
            index = matcher.find() && matcher.find() ? matcher.start() : log.length();
            String sub = log.substring(0, index);
            lines.add(LogLine.create(sub));
            log = log.substring(index);
        }
        Collections.sort(lines);
        LogLine last = null;
        for (LogLine l : lines) {
            if (l.ts == 1535116136132L) {
                System.out.println();
            }
            if (last == null || !StringUtils.equals(last.clazz, l.clazz)) {
                System.out.println("Origin: " + l.clazz);
            }
            System.out.println(l.thread + " " + l.ts + "/" + new Date(l.ts) + "  " + l.text);
            last = l;
        }
    }

    public static class LogLine
    implements Comparable<LogLine> {
        String text;
        private long ts;
        private String clazz;
        private String thread;

        public static LogLine create(String sub) {
            LogLine ret = new LogLine();
            ret.ts = Long.parseLong(new Regex(sub, "\\-\\-ID\\:\\d+TS\\:(\\d+)\\-").getMatch(0));
            ret.thread = new Regex(sub, "\\-\\-ID\\:(\\d+)").getMatch(0);
            String[] data = new Regex(sub, ".*?\\[([^\\]]+)\\]\\s*\\-\\>\\s*(.*)").getRow(0);
            if (data == null) {
                ret.clazz = null;
                ret.text = sub;
            } else {
                ret.clazz = data[0];
                ret.text = data[1].trim();
            }
            return ret;
        }

        public String toString() {
            return this.ts + " - " + new Date(this.ts) + " " + this.text + "  [" + this.clazz + "]";
        }

        @Override
        public int compareTo(LogLine o) {
            return CompareUtils.compare(this.ts, o.ts);
        }
    }
}

