/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.BasicHTTP;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.appwork.txtresource.TranslationFactory;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Interruptible;
import org.appwork.utils.InterruptibleThread;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.BasicHTTP.BadRangeResponse;
import org.appwork.utils.net.BasicHTTP.BadResponseLengthException;
import org.appwork.utils.net.BasicHTTP.BasicHTTPException;
import org.appwork.utils.net.BasicHTTP.IncompleteResponseException;
import org.appwork.utils.net.BasicHTTP.InvalidRedirectException;
import org.appwork.utils.net.BasicHTTP.InvalidResponseCode;
import org.appwork.utils.net.BasicHTTP.ReadIOException;
import org.appwork.utils.net.BasicHTTP.RedirectTimeoutException;
import org.appwork.utils.net.BasicHTTP.WriteIOException;
import org.appwork.utils.net.ChunkedOutputStream;
import org.appwork.utils.net.CountingConnection;
import org.appwork.utils.net.CountingInputStream;
import org.appwork.utils.net.DownloadProgress;
import org.appwork.utils.net.URLHelper;
import org.appwork.utils.net.UploadProgress;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionFactory;
import org.appwork.utils.net.httpconnection.HTTPOutputStream;
import org.appwork.utils.net.httpconnection.HTTPProxy;

public class BasicHTTP
implements Interruptible {
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected HashSet<Integer> allowedResponseCodes;
    protected final HashMap<String, String> requestHeader;
    protected volatile HTTPConnection connection;
    protected int connectTimeout = 15000;
    protected int readTimeout = 30000;
    protected HTTPProxy proxy = HTTPProxy.NONE;
    protected LogInterface logger = null;
    protected final Object lock = new Object();

    public BasicHTTP() {
        this.requestHeader = new HashMap();
    }

    protected void checkResponseCode(HTTPConnection connection) throws InvalidResponseCode {
        HashSet<Integer> allowedResponseCodes = this.getAllowedResponseCodes();
        if (allowedResponseCodes != null) {
            if (allowedResponseCodes.contains(-1)) {
                return;
            }
            if (!allowedResponseCodes.contains(connection.getResponseCode())) {
                throw this.createInvalidResponseCodeException(connection);
            }
        }
    }

    public void clearRequestHeader() {
        this.getRequestHeader().clear();
    }

    protected InvalidResponseCode createInvalidResponseCodeException(HTTPConnection connection) {
        return new InvalidResponseCode(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(URL url, DownloadProgress progress, File file) throws BasicHTTPException, InterruptedException {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(file, true);
        }
        catch (FileNotFoundException e) {
            throw new BasicHTTPException(null, new WriteIOException(e));
        }
        try {
            HTTPConnection downloadConnection = null;
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.download(url, progress, 0L, fos, file.length());
                    downloadConnection = this.getConnection();
                }
            }
            catch (BasicHTTPException e) {
                throw e;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BasicHTTPException(downloadConnection, e);
            }
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public byte[] download(URL url, DownloadProgress progress, long maxSize) throws BasicHTTPException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.download(url, progress, maxSize, baos, -1L);
        }
        catch (BasicHTTPException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        finally {
            try {
                baos.close();
            }
            catch (Throwable throwable) {}
        }
        return baos.toByteArray();
    }

    protected long getRedirectTimeout(URL url) {
        return 3600000L;
    }

    public void download(URL url, DownloadProgress progress, long maxSize, OutputStream baos, long resumePosition) throws BasicHTTPException, InterruptedException {
        this.download(url, progress, maxSize, baos, resumePosition, System.currentTimeMillis() + this.getRedirectTimeout(url));
    }

    @Override
    public void interrupt(Thread arg0) {
        HTTPConnection con = this.getConnection();
        if (con != null) {
            try {
                con.disconnect();
            }
            catch (Throwable e) {
                this.log(e);
            }
        }
    }

    protected void log(HTTPConnection connection) {
        LogInterface logger = this.getLogger();
        if (logger != null && connection != null) {
            try {
                logger.info(connection.toString());
            }
            catch (Throwable e) {
                this.log(e);
            }
        }
    }

    protected void log(Throwable e) {
        LogInterface logger = this.getLogger();
        if (logger != null && e != null) {
            logger.log(e);
        }
    }

    protected HTTPConnection createHTTPConnection(URL url) {
        HTTPConnection connection;
        this.connection = null;
        this.connection = connection = HTTPConnectionFactory.createHTTPConnection(url, this.getProxy());
        return connection;
    }

    public URL followRedirect(HTTPConnection connection, URL url) throws IOException, InterruptedException {
        if (connection.getResponseCode() == 301 || connection.getResponseCode() == 302 || connection.getResponseCode() == 303 || connection.getResponseCode() == 307) {
            String red = connection.getHeaderField("Location");
            if (red != null) {
                if (connection.getResponseCode() == 302) {
                    Thread.sleep(125L);
                } else {
                    Thread.sleep(250L);
                }
                return new URL(URLHelper.parseLocation(url, red));
            }
            throw new InvalidRedirectException(connection);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download(URL url, DownloadProgress downloadProgress, long maxSize, OutputStream baos, long resumePosition, long redirectTimeoutTimeStamp) throws BasicHTTPException, InterruptedException {
        DownloadProgress progress = downloadProgress == null ? new DownloadProgress() : downloadProgress;
        Object object = this.lock;
        synchronized (object) {
            URL followRedirect;
            block48: {
                followRedirect = null;
                HTTPConnection connection = this.createHTTPConnection(url);
                try {
                    boolean addedInterruptible = Boolean.TRUE.equals(InterruptibleThread.add(this));
                    try {
                        boolean rangeRequest;
                        this.prepareConnection(connection, HTTPConnection.RequestMethod.GET, -1);
                        if (resumePosition > 0L) {
                            connection.setRequestProperty("Range", "bytes=" + resumePosition + "-");
                            rangeRequest = true;
                        } else {
                            rangeRequest = false;
                        }
                        progress.onConnect(connection);
                        connection.connect();
                        progress.onConnected(connection);
                        if (rangeRequest && connection.getResponseCode() == 200) {
                            throw new BadRangeResponse(connection);
                        }
                        followRedirect = this.followRedirect(connection, url);
                        if (followRedirect == null) {
                            this.checkResponseCode(connection);
                            InputStream is = connection.getInputStream();
                            try {
                                long completeLength;
                                if (!(is instanceof CountingConnection)) {
                                    is = new CountingInputStream(is);
                                }
                                if (connection.getCompleteContentLength() >= 0L) {
                                    if (maxSize > 0L && connection.getCompleteContentLength() > maxSize) {
                                        throw new BadResponseLengthException(connection, maxSize);
                                    }
                                    progress.setTotal(connection.getCompleteContentLength());
                                }
                                byte[] b = new byte[1];
                                progress.setLoaded(Math.max(0L, resumePosition));
                                while (true) {
                                    int len;
                                    try {
                                        len = is.read(b);
                                        if (len == -1) {
                                            break;
                                        }
                                    }
                                    catch (IOException e) {
                                        throw new ReadIOException(e);
                                    }
                                    if (Thread.interrupted()) {
                                        throw new InterruptedException();
                                    }
                                    if (len <= 0) continue;
                                    progress.onBytesLoaded(b, len);
                                    try {
                                        baos.write(b, 0, len);
                                    }
                                    catch (IOException e) {
                                        throw new WriteIOException(e);
                                    }
                                    if (maxSize > 0L && ((CountingConnection)((Object)is)).transferedBytes() > maxSize) {
                                        throw new BadResponseLengthException(connection, maxSize);
                                    }
                                    progress.increaseLoaded(len);
                                    if (b.length != 1) continue;
                                    b = new byte[524288];
                                }
                                if (connection.getCompleteContentLength() >= 0L && (completeLength = Math.max(0L, resumePosition) + ((CountingConnection)((Object)is)).transferedBytes()) != connection.getCompleteContentLength()) {
                                    throw new IncompleteResponseException(connection, completeLength);
                                }
                                break block48;
                            }
                            finally {
                                is.close();
                            }
                        }
                        if (redirectTimeoutTimeStamp > 0L && System.currentTimeMillis() >= redirectTimeoutTimeStamp) {
                            throw new RedirectTimeoutException(connection);
                        }
                    }
                    catch (ReadIOException e) {
                        throw this.handleInterrupt(new BasicHTTPException(connection, e));
                    }
                    catch (WriteIOException e) {
                        throw this.handleInterrupt(new BasicHTTPException(connection, e));
                    }
                    catch (BasicHTTPException e) {
                        throw this.handleInterrupt(e);
                    }
                    catch (IOException e) {
                        throw this.handleInterrupt(new BasicHTTPException(connection, new ReadIOException(e)));
                    }
                    finally {
                        if (addedInterruptible) {
                            InterruptibleThread.remove(this);
                        }
                        this.log(connection);
                    }
                }
                catch (InterruptedException e) {
                    progress.onException(connection, e);
                    throw e;
                }
                catch (BasicHTTPException e) {
                    progress.onException(connection, e);
                    throw e;
                }
                finally {
                    try {
                        connection.disconnect();
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        progress.onDisconnected(connection);
                    }
                }
            }
            if (followRedirect != null) {
                this.download(followRedirect, progress, maxSize, baos, resumePosition, redirectTimeoutTimeStamp);
            }
        }
    }

    public HashSet<Integer> getAllowedResponseCodes() {
        return this.allowedResponseCodes;
    }

    public HTTPConnection getConnection() {
        return this.connection;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPage(URL url) throws IOException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            StringBuilder sb;
            URL followRedirect;
            block31: {
                followRedirect = null;
                sb = new StringBuilder();
                HTTPConnection connection = this.createHTTPConnection(url);
                boolean addedInterruptible = Boolean.TRUE.equals(InterruptibleThread.add(this));
                try {
                    this.prepareConnection(connection, HTTPConnection.RequestMethod.GET, -1);
                    this.connect(null, connection, false);
                    followRedirect = this.followRedirect(connection, url);
                    if (followRedirect != null) break block31;
                    this.checkResponseCode(connection);
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), UTF8));
                    try {
                        String str;
                        while ((str = in.readLine()) != null) {
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                            if (sb.length() > 0) {
                                sb.append("\r\n");
                            }
                            sb.append(str);
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                catch (ReadIOException e) {
                    throw this.handleInterrupt(new BasicHTTPException(connection, e));
                }
                catch (WriteIOException e) {
                    throw this.handleInterrupt(new BasicHTTPException(connection, e));
                }
                catch (BasicHTTPException e) {
                    throw this.handleInterrupt(e);
                }
                catch (IOException e) {
                    throw this.handleInterrupt(new BasicHTTPException(connection, new ReadIOException(e)));
                }
                finally {
                    try {
                        if (addedInterruptible) {
                            InterruptibleThread.remove(this);
                        }
                        this.log(connection);
                    }
                    catch (Throwable throwable) {
                        try {
                            connection.disconnect();
                        }
                        catch (Throwable throwable2) {}
                        throw throwable;
                    }
                    try {
                        connection.disconnect();
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (followRedirect != null) {
                return this.getPage(followRedirect);
            }
            return sb.toString();
        }
    }

    public HTTPProxy getProxy() {
        return this.proxy;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public HashMap<String, String> getRequestHeader() {
        return this.requestHeader;
    }

    public String getRequestHeader(String key) {
        return this.getRequestHeader().get(key);
    }

    public String getResponseHeader(String string) {
        HTTPConnection con = this.getConnection();
        return con != null ? con.getHeaderField(string) : null;
    }

    public HTTPConnection openGetConnection(URL url) throws IOException, InterruptedException {
        return this.openGetConnection(url, this.getReadTimeout());
    }

    protected void prepareConnection(HTTPConnection connection, HTTPConnection.RequestMethod method, int readTimeout) {
        this.setAllowedResponseCodes(connection);
        connection.setConnectTimeout(this.getConnectTimeout());
        connection.setReadTimeout(readTimeout < 0 ? this.getReadTimeout() : readTimeout);
        connection.setRequestMethod(method);
        connection.setRequestProperty("Accept-Language", TranslationFactory.getDesiredLanguage());
        connection.setRequestProperty("User-Agent", "AppWork " + Application.getApplication());
        connection.setRequestProperty("Accept-Charset", UTF8.name());
        connection.setRequestProperty("Connection", "Close");
        for (Map.Entry<String, String> next : this.getRequestHeader().entrySet()) {
            connection.setRequestProperty(next.getKey(), next.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HTTPConnection openGetConnection(URL url, int readTimeout) throws BasicHTTPException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            boolean close = true;
            URL followRedirect = null;
            HTTPConnection connection = this.createHTTPConnection(url);
            boolean addedInterruptible = Boolean.TRUE.equals(InterruptibleThread.add(this));
            try {
                this.prepareConnection(connection, HTTPConnection.RequestMethod.GET, -1);
                int lookupTry = 0;
                while (true) {
                    try {
                        connection.connect();
                    }
                    catch (UnknownHostException e) {
                        if (++lookupTry > 3) {
                            throw e;
                        }
                        Thread.sleep(200L);
                        continue;
                    }
                    break;
                }
                followRedirect = this.followRedirect(connection, url);
                if (followRedirect == null) {
                    this.checkResponseCode(connection);
                    close = false;
                }
            }
            catch (ReadIOException e) {
                throw this.handleInterrupt(new BasicHTTPException(connection, e));
            }
            catch (WriteIOException e) {
                throw this.handleInterrupt(new BasicHTTPException(connection, e));
            }
            catch (BasicHTTPException e) {
                throw this.handleInterrupt(e);
            }
            catch (IOException e) {
                throw this.handleInterrupt(new BasicHTTPException(connection, new ReadIOException(e)));
            }
            finally {
                block29: {
                    try {
                        if (addedInterruptible) {
                            InterruptibleThread.remove(this);
                        }
                        this.log(connection);
                        if (!close) break block29;
                    }
                    catch (Throwable throwable) {
                        if (!close) throw throwable;
                        try {
                            connection.disconnect();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {}
                    }
                    try {
                        connection.disconnect();
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (followRedirect == null) return connection;
            return this.openGetConnection(followRedirect, readTimeout);
        }
    }

    public String toString() {
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HTTPConnection openPostConnection(URL url, UploadProgress progress, InputStream is, HashMap<String, String> customHeaders, long contentLength) throws BasicHTTPException, InterruptedException {
        boolean close = true;
        Object object = this.lock;
        synchronized (object) {
            HTTPConnection connection = this.createHTTPConnection(url);
            boolean addedInterruptible = Boolean.TRUE.equals(InterruptibleThread.add(this));
            try {
                block38: {
                    boolean before;
                    this.prepareConnection(connection, HTTPConnection.RequestMethod.POST, -1);
                    if (customHeaders != null) {
                        for (Map.Entry<String, String> next : customHeaders.entrySet()) {
                            if ("Content-Length".equalsIgnoreCase(next.getKey())) continue;
                            connection.setRequestProperty(next.getKey(), next.getValue());
                        }
                    }
                    if (contentLength >= 0L) {
                        connection.setRequestProperty("Content-Length", Long.toString(contentLength));
                    } else {
                        connection.setRequestProperty("Transfer-Encoding", "chunked");
                    }
                    this.onBeforeConnect(connection);
                    HTTPOutputStream directHttpConnectionOuputStream = this.connect(null, connection, true);
                    OutputStream outputStream = this.wrapPostOutputStream(connection, directHttpConnectionOuputStream);
                    byte[] buf = new byte[64000];
                    do {
                        int read;
                        try {
                            read = is.read(buf);
                        }
                        catch (IOException e) {
                            throw new ReadIOException(e);
                        }
                        if (read == -1) {
                            before = directHttpConnectionOuputStream.isClosingAllowed();
                            try {
                                directHttpConnectionOuputStream.setClosingAllowed(false);
                                outputStream.flush();
                                outputStream.close();
                                break block38;
                            }
                            catch (IOException e) {
                                throw new WriteIOException(e);
                            }
                        }
                        try {
                            outputStream.write(buf, 0, read);
                        }
                        catch (IOException e) {
                            throw new WriteIOException(e);
                        }
                        if (progress == null) continue;
                        progress.onBytesUploaded(buf, read);
                        progress.increaseUploaded(read);
                    } while (!Thread.interrupted());
                    throw new InterruptedException();
                    finally {
                        directHttpConnectionOuputStream.setClosingAllowed(before);
                    }
                }
                connection.finalizeConnect();
                this.checkResponseCode(connection);
                close = false;
                HTTPConnection hTTPConnection = connection;
                return hTTPConnection;
            }
            catch (ReadIOException e) {
                throw this.handleInterrupt(new BasicHTTPException(connection, e));
            }
            catch (WriteIOException e) {
                throw this.handleInterrupt(new BasicHTTPException(connection, e));
            }
            catch (BasicHTTPException e) {
                throw this.handleInterrupt(e);
            }
            catch (IOException e) {
                throw this.handleInterrupt(new BasicHTTPException(connection, new ReadIOException(e)));
            }
            finally {
                block39: {
                    try {
                        if (addedInterruptible) {
                            InterruptibleThread.remove(this);
                        }
                        this.log(connection);
                        if (!close) break block39;
                    }
                    catch (Throwable throwable) {
                        if (!close) throw throwable;
                        try {
                            connection.disconnect();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {}
                    }
                    try {
                        connection.disconnect();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    protected void onBeforeConnect(HTTPConnection connection) {
    }

    protected OutputStream wrapPostOutputStream(HTTPConnection connection, OutputStream os) throws IOException {
        if (StringUtils.equalsIgnoreCase(connection.getRequestProperty("Transfer-Encoding"), "chunked")) {
            os = new ChunkedOutputStream(os);
        }
        return os;
    }

    public byte[] postPage(URL url, byte[] byteData) throws BasicHTTPException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.postPage(url, byteData, baos, null, null);
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postPage(URL url, byte[] postData, OutputStream baos, DownloadProgress uploadProgress, DownloadProgress downloadProgress) throws InterruptedException, BasicHTTPException {
        byte[] postBytes = postData == null ? new byte[]{} : postData;
        DownloadProgress finalUploadProgress = uploadProgress == null ? new DownloadProgress() : uploadProgress;
        DownloadProgress finalDownloadProgress = downloadProgress == null ? new DownloadProgress() : downloadProgress;
        Object object = this.lock;
        synchronized (object) {
            URL followRedirect;
            block51: {
                HTTPConnection connection = this.createHTTPConnection(url);
                boolean addedInterruptible = Boolean.TRUE.equals(InterruptibleThread.add(this));
                followRedirect = null;
                try {
                    try {
                        this.prepareConnection(connection, HTTPConnection.RequestMethod.POST, -1);
                        connection.setRequestProperty("Content-Length", String.valueOf(postBytes.length));
                        finalUploadProgress.onConnect(connection);
                        finalDownloadProgress.onConnect(connection);
                        HTTPOutputStream directHTTPConnectionOutputStream = this.connect(finalUploadProgress, connection, true);
                        OutputStream outputStream = this.wrapPostOutputStream(connection, directHTTPConnectionOutputStream);
                        finalUploadProgress.setTotal(postBytes.length);
                        if (postBytes.length > 0) {
                            int offset = 0;
                            while (true) {
                                int toWrite;
                                if ((toWrite = Math.min(51200, postBytes.length - offset)) == 0) {
                                    finalUploadProgress.setLoaded(postBytes.length);
                                    break;
                                }
                                outputStream.write(postBytes, offset, toWrite);
                                if (Thread.interrupted()) {
                                    throw new InterruptedException();
                                }
                                offset += toWrite;
                                finalUploadProgress.increaseLoaded(toWrite);
                            }
                        }
                        boolean before = directHTTPConnectionOutputStream.isClosingAllowed();
                        try {
                            directHTTPConnectionOutputStream.setClosingAllowed(false);
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (IOException e) {
                            throw new WriteIOException(e);
                        }
                        finally {
                            directHTTPConnectionOutputStream.setClosingAllowed(before);
                        }
                        connection.finalizeConnect();
                        finalDownloadProgress.onConnected(connection);
                        if (connection.getCompleteContentLength() >= 0L) {
                            finalDownloadProgress.setTotal(connection.getCompleteContentLength());
                        }
                        if ((followRedirect = this.followRedirect(connection, url)) != null) break block51;
                        this.checkResponseCode(connection);
                        InputStream input = connection.getInputStream();
                        try {
                            long loaded;
                            if (!(input instanceof CountingConnection)) {
                                input = new CountingInputStream(input);
                            }
                            byte[] b = new byte[1];
                            while (true) {
                                int len;
                                try {
                                    len = input.read(b);
                                    if (len == -1) {
                                        break;
                                    }
                                }
                                catch (IOException e) {
                                    throw new ReadIOException(e);
                                }
                                if (Thread.interrupted()) {
                                    throw new InterruptedException();
                                }
                                if (len <= 0) continue;
                                finalDownloadProgress.onBytesLoaded(b, len);
                                try {
                                    baos.write(b, 0, len);
                                }
                                catch (IOException e) {
                                    throw new WriteIOException(e);
                                }
                                finalDownloadProgress.increaseLoaded(len);
                                if (b.length != 1) continue;
                                b = new byte[Short.MAX_VALUE];
                            }
                            if (connection.getCompleteContentLength() >= 0L && (loaded = ((CountingConnection)((Object)input)).transferedBytes()) != connection.getCompleteContentLength()) {
                                throw new IncompleteResponseException(connection, loaded);
                            }
                        }
                        finally {
                            input.close();
                        }
                    }
                    catch (ReadIOException e) {
                        throw this.handleInterrupt(new BasicHTTPException(connection, e));
                    }
                    catch (WriteIOException e) {
                        throw this.handleInterrupt(new BasicHTTPException(connection, e));
                    }
                    catch (BasicHTTPException e) {
                        throw this.handleInterrupt(e);
                    }
                    catch (IOException e) {
                        throw this.handleInterrupt(new BasicHTTPException(connection, new ReadIOException(e)));
                    }
                    finally {
                        if (addedInterruptible) {
                            InterruptibleThread.remove(this);
                        }
                        this.log(connection);
                    }
                }
                catch (InterruptedException e) {
                    finalUploadProgress.onException(connection, e);
                    finalDownloadProgress.onException(connection, e);
                    throw e;
                }
                catch (BasicHTTPException e) {
                    finalUploadProgress.onException(connection, e);
                    finalDownloadProgress.onException(connection, e);
                    throw e;
                }
                finally {
                    try {
                        connection.disconnect();
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        finalUploadProgress.onDisconnected(connection);
                        finalDownloadProgress.onDisconnected(connection);
                    }
                }
            }
            if (followRedirect != null) {
                this.postPage(followRedirect, postData, baos, uploadProgress, downloadProgress);
            }
        }
    }

    protected OutputStream connect(DownloadProgress finalUploadProgress, HTTPConnection connection) throws IOException, InterruptedException, UnknownHostException {
        return this.connect(finalUploadProgress, connection, false);
    }

    protected HTTPOutputStream connect(DownloadProgress finalUploadProgress, HTTPConnection connection, boolean returnOutputStream) throws IOException, InterruptedException, UnknownHostException {
        int lookupTry = 0;
        try {
            while (true) {
                try {
                    connection.connect();
                    if (finalUploadProgress != null) {
                        finalUploadProgress.onConnected(connection);
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                }
                catch (UnknownHostException e) {
                    if (++lookupTry > 3) {
                        throw e;
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    Thread.sleep(200L);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new BasicHTTPException(connection, new ReadIOException(e));
        }
        if (!returnOutputStream) {
            return null;
        }
        HTTPOutputStream raw = connection.getOutputStream();
        return raw;
    }

    private <E extends Throwable> E handleInterrupt(E exception) throws InterruptedException, E {
        if (exception instanceof InterruptedException) {
            throw (InterruptedException)exception;
        }
        if (Thread.interrupted() || exception instanceof InterruptedIOException) {
            throw Exceptions.addSuppressed(new InterruptedException("Connection Closed by Interrupt"), exception);
        }
        return exception;
    }

    public String postPage(URL url, String postString) throws BasicHTTPException, InterruptedException {
        return this.postPage(url, postString, UTF8);
    }

    public String postPage(URL url, String postString, final Charset charset) throws BasicHTTPException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(){

            @Override
            public synchronized String toString() {
                return new String(this.buf, 0, this.count, charset);
            }
        };
        this.postPage(url, postString != null ? postString.getBytes(UTF8) : null, baos, null, null);
        return baos.toString();
    }

    public void putRequestHeader(String key, String value) {
        this.getRequestHeader().put(key, value);
    }

    protected void setAllowedResponseCodes(HTTPConnection connection) {
        HashSet<Integer> allowedResponseCodes = this.getAllowedResponseCodes();
        if (allowedResponseCodes != null) {
            int[] ret = new int[allowedResponseCodes.size()];
            int i = 0;
            for (Integer allowed : allowedResponseCodes) {
                ret[i++] = allowed;
            }
            connection.setAllowedResponseCodes(ret);
        }
    }

    public void setAllowedResponseCodes(int ... codes) {
        HashSet<Integer> allowedResponseCodes = new HashSet<Integer>();
        for (int i : codes) {
            allowedResponseCodes.add(i);
        }
        this.allowedResponseCodes = allowedResponseCodes;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = Math.max(1000, connectTimeout);
    }

    public void setLogger(LogInterface logger) {
        this.logger = logger;
    }

    public void setProxy(HTTPProxy proxy) {
        this.proxy = proxy;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = Math.max(1000, readTimeout);
    }
}

