/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.appwork.utils.net.CountingInputStreamInterface;

public class CountingInputStream
extends FilterInputStream
implements CountingInputStreamInterface {
    private long count = 0L;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public InputStream getInputStream() {
        return this;
    }

    @Override
    public int read() throws IOException {
        int ret = super.read();
        if (ret != -1) {
            this.inc(1);
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = super.read(b, off, len);
        if (ret != -1) {
            this.inc(ret);
        }
        return ret;
    }

    protected void inc(int ret) throws IOException {
        this.count += (long)ret;
    }

    protected void setTransferedBytes(long count) {
        if (count >= 0L) {
            this.count = count;
        }
    }

    @Override
    public long transferedBytes() {
        return this.count;
    }
}

