/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.appwork.utils.Application;
import org.appwork.utils.ByteArrayMapKey;
import org.appwork.utils.ByteArrayWrapper;
import org.appwork.utils.Regex;
import org.appwork.utils.URLStream;

public class PublicSuffixList {
    private static PublicSuffixList INSTANCE;
    private final Map<ByteArrayMapKey, List<ByteArrayWrapper>> map;
    private final Charset UTF8 = Charset.forName("UTF-8");

    public static PublicSuffixList getInstance() {
        return INSTANCE;
    }

    public PublicSuffixList(URL publicSuffixList) throws IOException {
        this.map = this.parse(publicSuffixList);
    }

    private PublicSuffixList() throws IOException {
        this(Application.getRessourceURL("org/appwork/utils/net/effective_tld_names.dat"));
    }

    public String getSubDomain(String fullDomain) {
        String domain = this.getDomain(fullDomain);
        if (domain != null) {
            String pattern = "(.+)\\." + Pattern.quote(domain);
            String subDomain = new Regex(fullDomain, pattern).getMatch(0);
            return subDomain;
        }
        return null;
    }

    public String getDomain(String fullDomain) {
        String topLeveLDomain = this.getTopLevelDomain(fullDomain);
        if (topLeveLDomain != null) {
            String pattern = "([^\\.]+\\." + Pattern.quote(topLeveLDomain) + ")";
            String domain = new Regex(fullDomain, pattern).getMatch(0);
            return domain;
        }
        return null;
    }

    public String getTopLevelDomain(String fullDomain) {
        String tld;
        ByteArrayMapKey tldbA;
        List<ByteArrayWrapper> list;
        int tldIndex;
        if (fullDomain != null && (tldIndex = fullDomain.lastIndexOf(46)) > 0 && tldIndex + 1 < fullDomain.length() && (list = this.map.get(tldbA = new ByteArrayMapKey((tld = fullDomain.substring(tldIndex + 1)).getBytes(this.UTF8)))) != null) {
            if (list.size() == 0) {
                return tld;
            }
            ArrayList<String> hits = new ArrayList<String>();
            hits.add(tld);
            for (ByteArrayWrapper entry : list) {
                String item = entry.toString(this.UTF8);
                if (item.startsWith("*")) {
                    String pattern = "([^\\.]+" + Pattern.quote(item.substring(1)) + ")";
                    String domain = new Regex(fullDomain, pattern).getMatch(0);
                    if (domain == null) continue;
                    hits.add(domain);
                    continue;
                }
                if (item.startsWith("!") && fullDomain.contains(item.substring(1))) {
                    return item.substring(item.indexOf(46) + 1);
                }
                if (!fullDomain.contains(item)) continue;
                hits.add(item);
            }
            Collections.sort(hits, new Comparator<String>(){

                @Override
                public int compare(int x, int y) {
                    return x < y ? 1 : (x == y ? 0 : -1);
                }

                @Override
                public int compare(String o1, String o2) {
                    return this.compare(o1.length(), o2.length());
                }
            });
            return (String)hits.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<ByteArrayMapKey, List<ByteArrayWrapper>> parse(URL publicSuffixList) throws IOException {
        InputStream is;
        HashMap<ByteArrayMapKey, List<ByteArrayWrapper>> map = new HashMap<ByteArrayMapKey, List<ByteArrayWrapper>>();
        if (publicSuffixList != null && (is = URLStream.openStream(publicSuffixList)) != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                ArrayList<ByteArrayWrapper> emptyList = new ArrayList<ByteArrayWrapper>(0);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("//") || line.length() <= 0) continue;
                    int tldIndex = line.lastIndexOf(46);
                    String tld = tldIndex == -1 ? line : line.substring(tldIndex + 1);
                    ByteArrayMapKey tldbA = new ByteArrayMapKey(tld.getBytes(this.UTF8));
                    List<ByteArrayWrapper> list = map.get(tldbA);
                    if (list == null) {
                        list = emptyList;
                        map.put(tldbA, list);
                    }
                    if (tldIndex <= 0) continue;
                    if (list == emptyList) {
                        list = new ArrayList<ByteArrayWrapper>();
                        map.put(tldbA, list);
                    }
                    list.add(new ByteArrayWrapper(line.getBytes(this.UTF8), false));
                }
                for (List<ByteArrayWrapper> list : map.values()) {
                    if (list == emptyList || !(list instanceof ArrayList)) continue;
                    ((ArrayList)list).trimToSize();
                }
            }
            finally {
                is.close();
            }
        }
        return map;
    }

    static {
        try {
            INSTANCE = new PublicSuffixList();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

