/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.appwork.utils.net.httpconnection.HTTPOutputStream;
import org.appwork.utils.net.httpconnection.HTTPProxy;

public interface HTTPConnection {
    public void setLegacyConnectEnabled(boolean var1);

    public boolean isLegacyConnectEnabled();

    public void connect() throws IOException;

    public void disconnect();

    public void finalizeConnect() throws IOException;

    public int[] getAllowedResponseCodes();

    public String getCharset();

    public long getCompleteContentLength();

    public long getContentLength();

    public String getContentType();

    public String getHeaderField(String var1);

    public Map<String, List<String>> getHeaderFields();

    public List<String> getHeaderFields(String var1);

    public InputStream getInputStream() throws IOException;

    public HTTPOutputStream getOutputStream() throws IOException;

    public long[] getRange();

    public RequestMethod getRequestMethod();

    public Map<String, String> getRequestProperties();

    public String getRequestProperty(String var1);

    public long getRequestTime();

    public int getResponseCode();

    public String getResponseMessage();

    public URL getURL();

    public boolean isConnected();

    public boolean isContentDecoded();

    public boolean isContentDisposition();

    public boolean isOK();

    public HTTPProxy getProxy();

    public void setAllowedResponseCodes(int[] var1);

    public void setCharset(String var1);

    public void setConnectTimeout(int var1);

    public void setContentDecoded(boolean var1);

    public void setReadTimeout(int var1);

    public void setRequestMethod(RequestMethod var1);

    public void setRequestProperty(String var1, String var2);

    public void setSSLTrustALL(boolean var1);

    public boolean isSSLTrustALL();

    public static enum RequestMethod {
        NOTIFY(false),
        MSEARCH(false),
        SUBSCRIBE(false),
        UNSUBSCRIBE(false),
        PUT(true),
        DELETE(true),
        OPTIONS(false),
        GET(false),
        POST(true),
        HEAD(false),
        PROPFIND(true);

        public final boolean requiresOutputStream;

        private RequestMethod(boolean requiresOutputStream) {
            this.requiresOutputStream = requiresOutputStream;
        }
    }
}

