/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.net.httpconnection.HTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.HTTPConnectionProfilerInterface;

public class HTTPConnectionProfiler
implements HTTPConnectionProfilerInterface {
    protected Long socketConnectedNanos;
    protected Long firstHeaderByteReadNanos;
    protected Long allResponseHeadersReadNanos;
    protected Long inputStreamConnectedNanos;
    protected Long requestSentInclPostNanos;
    private Long allRequestHeadersSentNanos;
    private Long connectionFinalizedNanos;
    private Long start;

    public Long getSocketConnectedNanos() {
        return this.socketConnectedNanos;
    }

    public String toString() {
        ArrayList<Field> fields = new ArrayList<Field>();
        int length = 0;
        for (Field f : this.getClass().getDeclaredFields()) {
            if (f.getType() != Long.class) continue;
            f.setAccessible(true);
            fields.add(f);
            length = Math.max(length, f.getName().length());
        }
        Collections.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                try {
                    Long l1 = o1.get(HTTPConnectionProfiler.this) != null ? (Long)o1.get(HTTPConnectionProfiler.this) : null;
                    Long l2 = o2.get(HTTPConnectionProfiler.this) != null ? (Long)o2.get(HTTPConnectionProfiler.this) : null;
                    return CompareUtils.compare(l1, l2);
                }
                catch (IllegalArgumentException e) {
                    return 0;
                }
                catch (IllegalAccessException e) {
                    return 0;
                }
            }
        });
        StringBuilder sb = new StringBuilder();
        Field last = null;
        for (Field f : fields) {
            try {
                if (last != null) {
                    sb.append("\r\n");
                }
                sb.append(StringUtils.fillPost(f.getName(), " ", length + 1));
                Long nanos = (Long)f.get(this);
                if (nanos == null) {
                    sb.append("-not set-");
                } else {
                    sb.append(nanos + " ");
                    if (last == null) {
                        sb.append(0);
                    } else {
                        long ns = nanos - (Long)last.get(this);
                        long sinceStart = nanos - this.start;
                        sb.append(StringUtils.fillPost(this.formatNStoMS(sinceStart), " ", 10)).append("+ " + this.formatNStoMS(ns));
                    }
                }
                last = f;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    protected String formatNStoMS(long sinceStart) {
        return TimeUnit.NANOSECONDS.toMillis(sinceStart) + "." + sinceStart % TimeUnit.MILLISECONDS.toNanos(1L);
    }

    public Long getFirstHeaderByteReadNanos() {
        return this.firstHeaderByteReadNanos;
    }

    public Long getAllResponseHeadersReadNanos() {
        return this.allResponseHeadersReadNanos;
    }

    public Long getInputStreamConnectedNanos() {
        return this.inputStreamConnectedNanos;
    }

    public Long getRequestSentInclPostNanos() {
        return this.requestSentInclPostNanos;
    }

    public Long getStart() {
        return this.start;
    }

    @Override
    public void onConnected(HTTPConnectionImpl httpConnectionImp) {
        this.socketConnectedNanos = Time.getNanoSeconds();
    }

    @Override
    public void onDisconnected(HTTPConnectionImpl httpConnectionImp) {
    }

    @Override
    public void onDisconnect(HTTPConnectionImpl httpConnectionImp) {
    }

    @Override
    public void onBeforeSocketGetInputStream(HTTPConnectionImpl httpConnectionImp) {
        if (this.requestSentInclPostNanos == null) {
            this.requestSentInclPostNanos = Time.getNanoSeconds();
        }
    }

    @Override
    public void onAfterSocketGetInputStream(HTTPConnectionImpl httpConnectionImp) {
        this.inputStreamConnectedNanos = Time.getNanoSeconds();
    }

    @Override
    public void onFirstHeaderByteRead(HTTPConnectionImpl httpConnectionImp) {
        this.firstHeaderByteReadNanos = Time.getNanoSeconds();
    }

    @Override
    public void onAllResponseHeadersRead(HTTPConnectionImpl httpConnectionImp) {
        this.allResponseHeadersReadNanos = Time.getNanoSeconds();
    }

    @Override
    public void onBeforeRequestHeadersSent(HTTPConnectionImpl httpConnectionImp, CharSequence request) {
    }

    @Override
    public void onAfterRequestHeadersSent(HTTPConnectionImpl httpConnectionImp) {
        this.allRequestHeadersSentNanos = Time.getNanoSeconds();
    }

    public Long getAllRequestHeadersSentNanos(HTTPConnectionImpl httpConnectionImp) {
        return this.allRequestHeadersSentNanos;
    }

    @Override
    public void onFinalizeConnection(HTTPConnectionImpl httpConnectionImpl) {
        this.connectionFinalizedNanos = Time.getNanoSeconds();
    }

    public Long getConnectionFinalizedNanos() {
        return this.connectionFinalizedNanos;
    }

    @Override
    public void onConnect(HTTPConnectionImpl httpConnectionImpl) {
        if (this.start == null) {
            this.start = Time.getNanoSeconds();
        }
    }

    @Override
    public void onSendRequest(HTTPConnectionImpl httpConnectionImp) {
    }
}

