/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class HTTPHeaderMap<V>
implements Map<String, V> {
    protected final LinkedHashMap<HTTPHeaderMapEntry, V> internalMap;

    public static void main(String[] args) {
        HTTPHeaderMap<String> map = new HTTPHeaderMap<String>();
        map.put("Abc", "abc");
        map.put("xyz", "xyz");
        map.put("xyz1", "xyz");
        map.put("ABC", "ABC");
        map.put(null, "BC");
        System.out.println(map);
        map.remove("AbC");
        System.out.println(map);
        map.put("ABC", "ABC");
        map.put(null, "Bs");
        System.out.println(map);
        System.out.println((String)map.get("aBc"));
        System.out.println((String)map.get("xyZ"));
        System.out.println((String)map.get(""));
        System.out.println((String)map.get(null));
        System.out.println(map.values());
        System.out.println(map.keySet());
        Iterator it = map.entrySet().iterator();
        Map.Entry next = null;
        ArrayList retain = new ArrayList();
        while (it.hasNext()) {
            next = it.next();
            System.out.println((String)next.getKey() + " = " + (String)next.getValue());
        }
        System.out.println("next round");
        System.out.println(map);
        retain.add(next);
        System.out.println(new ArrayList(map.values()));
        System.out.println(new ArrayList(map.keySet()));
        System.out.println(new ArrayList(map.entrySet()));
        System.out.println("entry " + map.entrySet().retainAll(retain));
        System.out.println(map);
    }

    public HTTPHeaderMap() {
        this.internalMap = new LinkedHashMap();
    }

    public HTTPHeaderMap(int initialCapacity) {
        this.internalMap = new LinkedHashMap(initialCapacity);
    }

    public HTTPHeaderMap(int initialCapacity, float loadFactor) {
        this.internalMap = new LinkedHashMap(initialCapacity, loadFactor);
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key != null && key instanceof String) {
            return this.internalMap.containsKey(new HTTPHeaderMapEntry((String)key));
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    private Map.Entry<String, V> convertFromEntry(final Map.Entry<HTTPHeaderMapEntry, V> e) {
        final String key = e.getKey() == null ? null : e.getKey().getHttpHeaderFieldName();
        Map.Entry entry = new Map.Entry<String, V>(){
            V value;
            {
                this.value = e.getValue();
            }

            @Override
            public final boolean equals(Object o) {
                Object v2;
                Object v1;
                Object k2;
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e2 = (Map.Entry)o;
                String k1 = this.getKey();
                return (k1 == (k2 = e2.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e2.getValue()) || v1 != null && v1.equals(v2));
            }

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public final int hashCode() {
                return this.hashCode(this.getKey()) ^ this.hashCode(this.getValue());
            }

            private int hashCode(Object o) {
                return o != null ? o.hashCode() : 0;
            }

            @Override
            public V setValue(V value) {
                Object old = value;
                this.value = value;
                return old;
            }

            public final String toString() {
                return this.getKey() + "=" + this.getValue();
            }
        };
        return entry;
    }

    private Map.Entry<HTTPHeaderMapEntry, V> convertToEntry(final Map.Entry<String, V> e) {
        final HTTPHeaderMapEntry key = e.getKey() == null ? null : new HTTPHeaderMapEntry(e.getKey());
        Map.Entry entry = new Map.Entry<HTTPHeaderMapEntry, V>(){
            V value;
            {
                this.value = e.getValue();
            }

            @Override
            public final boolean equals(Object o) {
                Object v2;
                Object v1;
                Object k2;
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e2 = (Map.Entry)o;
                HTTPHeaderMapEntry k1 = this.getKey();
                return (k1 == (k2 = e2.getKey()) || k1 != null && ((Object)k1).equals(k2)) && ((v1 = this.getValue()) == (v2 = e2.getValue()) || v1 != null && v1.equals(v2));
            }

            @Override
            public HTTPHeaderMapEntry getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public final int hashCode() {
                return this.hashCode(this.getKey()) ^ this.hashCode(this.getValue());
            }

            private int hashCode(Object o) {
                return o != null ? o.hashCode() : 0;
            }

            @Override
            public V setValue(V value) {
                Object old = value;
                this.value = value;
                return old;
            }

            public final String toString() {
                return this.getKey() + "=" + this.getValue();
            }
        };
        return entry;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        final Set<Map.Entry<HTTPHeaderMapEntry, V>> set = this.internalMap.entrySet();
        return new Set<Map.Entry<String, V>>(){

            @Override
            public boolean add(Map.Entry<String, V> e) {
                return set.add(HTTPHeaderMap.this.convertToEntry(e));
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<String, V>> c) {
                boolean changed = false;
                for (Map.Entry entry : c) {
                    if (!this.add(entry)) continue;
                    changed = true;
                }
                return changed;
            }

            @Override
            public void clear() {
                HTTPHeaderMap.this.internalMap.clear();
            }

            @Override
            public boolean contains(Object o) {
                return this.get(o) != null;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object o : c) {
                    if (this.contains(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Set)) {
                    return false;
                }
                Collection c = (Collection)o;
                if (c.size() != this.size()) {
                    return false;
                }
                try {
                    return this.containsAll(c);
                }
                catch (ClassCastException unused) {
                    return false;
                }
                catch (NullPointerException unused) {
                    return false;
                }
            }

            private Map.Entry<HTTPHeaderMapEntry, V> get(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return null;
                }
                Map.Entry e = (Map.Entry)o;
                if (e.getKey() != null && !(e.getKey() instanceof String)) {
                    return null;
                }
                for (Map.Entry next : HTTPHeaderMap.this.internalMap.entrySet()) {
                    HTTPHeaderMapEntry key = next.getKey();
                    if ((key != null || e.getKey() != null) && !key.getHttpHeaderFieldName().equalsIgnoreCase((String)e.getKey()) || next.getValue() != e.getKey() && (next.getValue() == null || !next.getValue().equals(e.getValue()))) continue;
                    return next;
                }
                return null;
            }

            @Override
            public int hashCode() {
                int h = 0;
                for (Map.Entry obj : this) {
                    if (obj == null) continue;
                    h += ((Object)obj).hashCode();
                }
                return h;
            }

            @Override
            public boolean isEmpty() {
                return set.isEmpty();
            }

            @Override
            public Iterator<Map.Entry<String, V>> iterator() {
                final Iterator it = HTTPHeaderMap.this.internalMap.entrySet().iterator();
                return new Iterator<Map.Entry<String, V>>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Map.Entry<String, V> next() {
                        Map.Entry next = (Map.Entry)it.next();
                        if (next != null) {
                            return HTTPHeaderMap.this.convertFromEntry(next);
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                Map.Entry entry = this.get(o);
                if (entry != null) {
                    return HTTPHeaderMap.this.internalMap.entrySet().remove(entry);
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean changed = false;
                for (Object o : c) {
                    if (!this.remove(o)) continue;
                    changed = true;
                }
                return changed;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean modified = false;
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    if (c.contains(it.next())) continue;
                    it.remove();
                    modified = true;
                }
                return modified;
            }

            @Override
            public int size() {
                return set.size();
            }

            @Override
            public Object[] toArray() {
                ArrayList ret = new ArrayList();
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    ret.add(it.next());
                }
                return ret.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                ArrayList ret = new ArrayList();
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    ret.add(it.next());
                }
                return ret.toArray(a);
            }

            public String toString() {
                return HTTPHeaderMap.this.internalMap.entrySet().toString();
            }
        };
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.internalMap.get(null);
        }
        if (key instanceof String) {
            return this.internalMap.get(new HTTPHeaderMapEntry((String)key));
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return new HTTPHeaderKeySet();
    }

    @Override
    public V put(String key, V value) {
        if (key == null) {
            return this.internalMap.put(null, value);
        }
        return this.internalMap.put(new HTTPHeaderMapEntry(key), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        if (m.size() == 0) {
            return;
        }
        for (Map.Entry<String, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            return this.internalMap.remove(null);
        }
        if (key instanceof String) {
            return this.internalMap.remove(new HTTPHeaderMapEntry((String)key));
        }
        return null;
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    public String toString() {
        return this.internalMap.toString();
    }

    @Override
    public Collection<V> values() {
        return this.internalMap.values();
    }

    protected static class HTTPHeaderMapEntry {
        private final String httpHeaderFieldName;
        private final int lowerCaseHash;

        protected HTTPHeaderMapEntry(String httpHeaderFieldName) {
            this.httpHeaderFieldName = httpHeaderFieldName;
            this.lowerCaseHash = httpHeaderFieldName.toLowerCase(Locale.ENGLISH).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof HTTPHeaderMapEntry)) {
                return false;
            }
            HTTPHeaderMapEntry other = (HTTPHeaderMapEntry)obj;
            return other.getHttpHeaderFieldName().equalsIgnoreCase(this.getHttpHeaderFieldName());
        }

        public String getHttpHeaderFieldName() {
            return this.httpHeaderFieldName;
        }

        public int hashCode() {
            return this.lowerCaseHash;
        }

        public String toString() {
            return this.httpHeaderFieldName;
        }
    }

    private final class HTTPHeaderKeySet
    extends AbstractSet<String> {
        private HTTPHeaderKeySet() {
        }

        @Override
        public void clear() {
            HTTPHeaderMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return HTTPHeaderMap.this.containsKey(o);
        }

        @Override
        public Iterator<String> iterator() {
            final Iterator<HTTPHeaderMapEntry> it = HTTPHeaderMap.this.internalMap.keySet().iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    HTTPHeaderMapEntry next = (HTTPHeaderMapEntry)it.next();
                    if (next != null) {
                        return next.getHttpHeaderFieldName();
                    }
                    return null;
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            return HTTPHeaderMap.this.containsKey(o);
        }

        @Override
        public int size() {
            return HTTPHeaderMap.this.size();
        }
    }
}

