/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.io.InputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.net.httpconnection.HTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.HTTPConnectionProfilerInterface;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.HTTPProxyException;
import org.appwork.utils.net.httpconnection.ProxyAuthException;
import org.appwork.utils.net.httpconnection.ProxyConnectException;
import org.appwork.utils.net.httpconnection.SSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.SSLSocketStreamInterface;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptions;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;

public class HTTPProxyHTTPConnectionImpl
extends HTTPConnectionImpl {
    private StringBuilder proxyRequest;
    private final boolean preferConnectMethod;
    protected InetSocketAddress proxyInetSocketAddress = null;
    protected volatile SocketStreamInterface proxySocket = null;
    protected volatile InetAddress customEndPointInetAddress = null;

    protected SocketStreamInterface getProxySocket() {
        return this.proxySocket;
    }

    public HTTPProxyHTTPConnectionImpl(URL url, HTTPProxy p) {
        super(url, p);
        this.preferConnectMethod = p.isConnectMethodPrefered();
        this.setRequestProperty("Proxy-Connection", "close");
        if (!url.getProtocol().startsWith("https") && !this.preferConnectMethod) {
            this.httpPath = this.getRequestPath(url, true);
        }
    }

    @Override
    protected HTTPProxy isProxySupported(HTTPProxy proxy) {
        if (proxy != null) {
            switch (proxy.getType()) {
                case HTTP: 
                case HTTPS: {
                    return proxy;
                }
            }
            throw new IllegalArgumentException("proxy must be of type http(s):" + proxy);
        }
        throw new IllegalArgumentException("proxy must be of type http(s):" + proxy);
    }

    protected boolean appendPortToHostHeader(HTTPProxy p) {
        return false;
    }

    protected String getConnectHostname() {
        InetAddress customEndPointInetAddress = this.getCustomEndPointInetAddress();
        if (customEndPointInetAddress != null) {
            if (customEndPointInetAddress instanceof Inet6Address) {
                return "[" + customEndPointInetAddress.getHostAddress() + "]";
            }
            return customEndPointInetAddress.getHostAddress();
        }
        return this.getHostname();
    }

    protected InetAddress[] getRemoteIPs(HTTPProxy proxy, boolean resolve) throws IOException {
        if (StringUtils.isEmpty(proxy.getHost())) {
            throw new ProxyConnectException(new UnknownHostException("Could not resolve: -empty host-"), proxy);
        }
        return this.getRemoteIPs(proxy.getHost(), resolve);
    }

    protected InetAddress getCustomEndPointInetAddress() {
        return this.customEndPointInetAddress;
    }

    protected void setCustomEndPointInetAddress(InetAddress customEndPointInetAddress) {
        this.customEndPointInetAddress = customEndPointInetAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        HTTPConnectionProfilerInterface profiler = this.getProfiler();
        if (profiler != null) {
            profiler.onConnect(this);
        }
        SSLSocketStreamOptions sslSocketStreamEndPointOptions = null;
        SSLSocketStreamOptions sslSocketStreamProxyOptions = null;
        SSLSocketStreamFactory factory = null;
        while (!this.isConnectionSocketValid()) {
            this.resetConnection();
            if (!this.isHostnameResolved()) {
                this.setHostname(this.resolveHostname(this.httpURL.getHost()));
            }
            HTTPConnectionImpl.SSL_STATE state = HTTPConnectionImpl.SSL_STATE.NA;
            try {
                if (StringUtils.isNotEmpty(this.proxy.getUser()) || StringUtils.isNotEmpty(this.proxy.getPass())) {
                    String user = StringUtils.valueOrEmpty(this.proxy.getUser());
                    String pass = StringUtils.valueOrEmpty(this.proxy.getPass());
                    String basicAuth = "Basic " + new String(Base64.encodeToByte((user + ":" + pass).getBytes(), false));
                    this.requestProperties.put("Proxy-Authorization", basicAuth);
                }
                IOException ee = null;
                InetAddress[] proxyIPs = this.getRemoteIPs(this.getProxy(), true);
                long startTime = Time.systemIndependentCurrentJVMTimeMillis();
                for (InetAddress host : proxyIPs) {
                    this.resetConnection();
                    startTime = Time.systemIndependentCurrentJVMTimeMillis();
                    this.connectionSocket = this.createConnectionSocket(null);
                    try {
                        InetSocketAddress connectedInetSocketAddress;
                        this.proxyInetSocketAddress = connectedInetSocketAddress = new InetSocketAddress(host, this.proxy.getPort());
                        this.connectionSocket.getSocket().connect(this.proxyInetSocketAddress, this.getConnectTimeout());
                        this.setReadTimeout(this.getReadTimeout());
                        ee = null;
                        break;
                    }
                    catch (IOException e) {
                        this.disconnect();
                        this.connectExceptions.add(this.proxyInetSocketAddress + "|" + this.getExceptionMessage(e));
                        ee = e;
                    }
                }
                if (ee != null) {
                    throw new ProxyConnectException(ee, this.proxy);
                }
                this.proxySocket = this.connectionSocket;
                if (HTTPProxy.TYPE.HTTPS.equals(this.proxy.getType())) {
                    if (sslSocketStreamProxyOptions == null) {
                        sslSocketStreamProxyOptions = this.getSSLSocketStreamOptions(this.proxy.getHost(), this.proxy.getPort(), this.isSSLTrustALL());
                    }
                    factory = this.getSSLSocketStreamFactory(sslSocketStreamProxyOptions);
                    state = HTTPConnectionImpl.SSL_STATE.PROXY;
                    this.proxySocket = this.connectionSocket = factory.create(this.connectionSocket, this.proxy.getHost(), this.proxy.getPort(), true, sslSocketStreamProxyOptions);
                }
                this.connectTime = Time.systemIndependentCurrentJVMTimeMillis() - startTime;
                if (this.httpURL.getProtocol().startsWith("https") || this.isConnectMethodPrefered()) {
                    int hostPort = this.httpURL.getPort() != -1 ? this.httpURL.getPort() : this.httpURL.getDefaultPort();
                    boolean addHostPort = this.appendPortToHostHeader(this.getProxy());
                    this.proxyRequest = new StringBuilder();
                    this.proxyRequest.append("CONNECT ");
                    this.proxyRequest.append(this.getConnectHostname() + ":" + hostPort);
                    this.proxyRequest.append(" HTTP/1.1\r\n");
                    if (this.requestProperties.get("User-Agent") != null) {
                        this.proxyRequest.append("User-Agent: " + (String)this.requestProperties.get("User-Agent") + "\r\n");
                    }
                    if (this.requestProperties.get("Host") != null) {
                        String host = (String)this.requestProperties.get("Host");
                        if (!host.contains(":") && addHostPort) {
                            this.proxyRequest.append("Host: " + host + ":" + hostPort + "\r\n");
                        } else {
                            this.proxyRequest.append("Host: " + host + "\r\n");
                        }
                    } else if (addHostPort) {
                        this.proxyRequest.append("Host: " + this.httpURL.getHost() + ":" + hostPort + "\r\n");
                    } else {
                        this.proxyRequest.append("Host: " + this.httpURL.getHost() + "\r\n");
                    }
                    if (this.requestProperties.get("Proxy-Connection") != null) {
                        this.proxyRequest.append("Proxy-Connection: " + (String)this.requestProperties.remove("Proxy-Connection") + "\r\n");
                    }
                    if (this.requestProperties.get("Proxy-Authorization") != null) {
                        this.proxyRequest.append("Proxy-Authorization: " + (String)this.requestProperties.remove("Proxy-Authorization") + "\r\n");
                    }
                    this.proxyRequest.append("\r\n");
                    this.connectionSocket.getOutputStream().write(this.proxyRequest.toString().getBytes("UTF-8"));
                    this.connectionSocket.getOutputStream().flush();
                    ByteBuffer header = HTTPConnectionUtils.readheader(this.connectionSocket.getInputStream(), true);
                    byte[] bytes = new byte[header.limit()];
                    header.get(bytes);
                    String proxyResponseStatus = new String(bytes, "ISO-8859-1").trim();
                    this.proxyRequest.append(proxyResponseStatus + "\r\n");
                    String proxyCode = null;
                    if (proxyResponseStatus.startsWith("HTTP")) {
                        proxyCode = new Regex(proxyResponseStatus, "HTTP.*? (\\d+)").getMatch(0);
                    }
                    if (!"200".equals(proxyCode)) {
                        try {
                            this.connectionSocket.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if ("407".equals(proxyCode)) {
                            throw new ProxyAuthException(this.proxy);
                        }
                        throw new ProxyConnectException(this.proxy);
                    }
                    while ((header = HTTPConnectionUtils.readheader(this.connectionSocket.getInputStream(), true)).limit() > 2) {
                        bytes = new byte[header.limit()];
                        header.get(bytes);
                        String temp = this.fromBytes(bytes, -1, -1);
                        this.proxyRequest.append(temp + "\r\n");
                    }
                    if (this.httpURL.getProtocol().startsWith("https")) {
                        String hostName = this.getHostname();
                        if (sslSocketStreamEndPointOptions == null) {
                            sslSocketStreamEndPointOptions = this.getSSLSocketStreamOptions(hostName, this.getPort(), this.isSSLTrustALL());
                        }
                        factory = this.getSSLSocketStreamFactory(sslSocketStreamEndPointOptions);
                        state = HTTPConnectionImpl.SSL_STATE.ENDPOINT;
                        this.connectionSocket = factory.create(this.connectionSocket, hostName, this.getPort(), true, sslSocketStreamEndPointOptions);
                    }
                } else {
                    this.proxyRequest = new StringBuilder("DIRECT\r\n");
                }
                if (profiler != null) {
                    profiler.onConnected(this);
                }
                this.sendRequest();
                return;
            }
            catch (IOException e) {
                String retrySSL = null;
                try {
                    if (HTTPConnectionImpl.SSL_STATE.ENDPOINT.equals((Object)state) && sslSocketStreamEndPointOptions != null) {
                        sslSocketStreamEndPointOptions = sslSocketStreamEndPointOptions.clone();
                        retrySSL = sslSocketStreamEndPointOptions.retry(factory, e);
                        this.setSSLSocketStreamOptions(sslSocketStreamEndPointOptions);
                    }
                    if (HTTPConnectionImpl.SSL_STATE.PROXY.equals((Object)state) && sslSocketStreamProxyOptions != null) {
                        sslSocketStreamProxyOptions = sslSocketStreamProxyOptions.clone();
                        retrySSL = sslSocketStreamProxyOptions.retry(factory, e);
                        this.setSSLSocketStreamOptions(sslSocketStreamProxyOptions);
                    }
                    this.connectExceptions.add((Object)((Object)state) + ":" + this.getExceptionMessage(e) + "|retrySSL:" + retrySSL);
                    continue;
                }
                finally {
                    this.disconnect();
                }
                if (retrySSL != null) continue;
                if (e instanceof HTTPProxyException) {
                    throw e;
                }
                throw new ProxyConnectException(e, this.proxy);
            }
            break;
        }
        return;
    }

    @Override
    public void disconnect() {
        try {
            super.disconnect();
        }
        finally {
            this.proxySocket = null;
        }
    }

    @Override
    protected boolean isKeepAlivedEnabled() {
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        this.connectInputStream();
        if (this.getResponseCode() == 405) {
            throw new ProxyConnectException(this.getResponseCode() + " " + this.getResponseMessage(), this.getProxy());
        }
        if (this.getResponseCode() == 407) {
            throw new ProxyAuthException(this.proxy);
        }
        if (this.getResponseCode() == 502 && StringUtils.containsIgnoreCase(this.getResponseMessage(), "ISA Server denied the specified")) {
            throw new ProxyConnectException(this.getResponseCode() + " " + this.getResponseMessage(), this.getProxy());
        }
        if (this.getResponseCode() == 504) {
            throw new ProxyConnectException(this.getResponseCode() + " " + this.getResponseMessage(), this.getProxy());
        }
        return super.getInputStream();
    }

    @Override
    protected String getRequestInfo() {
        if (this.proxyRequest != null) {
            InetAddress customEndPointInetAddress;
            StringBuilder sb = new StringBuilder();
            if (HTTPProxy.TYPE.HTTPS.equals(this.proxy.getType())) {
                sb.append("-->HTTPSProxy:").append(this.proxy.getHost()).append(":").append(this.proxy.getPort()).append("\r\n");
            } else {
                sb.append("-->HTTPProxy:").append(this.proxy.getHost()).append(":").append(this.proxy.getPort()).append("\r\n");
            }
            if (this.proxyInetSocketAddress != null && this.proxyInetSocketAddress.getAddress() != null) {
                if (HTTPProxy.TYPE.HTTPS.equals(this.proxy.getType())) {
                    sb.append("-->HTTPSProxyIP:").append(this.proxyInetSocketAddress.getAddress().getHostAddress()).append("\r\n");
                } else {
                    sb.append("-->HTTPProxyIP:").append(this.proxyInetSocketAddress.getAddress().getHostAddress()).append("\r\n");
                }
            }
            if ((customEndPointInetAddress = this.getCustomEndPointInetAddress()) != null) {
                sb.append("-->CustomEndPointInetAddress:").append(customEndPointInetAddress).append("\r\n");
            }
            if (HTTPProxy.TYPE.HTTPS.equals(this.proxy.getType())) {
                Socket proxySocket;
                sb.append("----------------CONNECTRequest(HTTPS)------------\r\n");
                SocketStreamInterface proxySocketStream = this.getProxySocket();
                if (proxySocketStream != null && (proxySocket = proxySocketStream.getSocket()) != null && proxySocket.isConnected() && proxySocketStream instanceof SSLSocketStreamInterface) {
                    SSLSocketStreamInterface sslSocketStream = (SSLSocketStreamInterface)proxySocketStream;
                    SSLSocketStreamOptions options = sslSocketStream.getOptions();
                    if (options != null && options.getRetryReasons().size() > 0) {
                        sb.append("SSLCipher: ").append(sslSocketStream.getCipherSuite() + "|" + options.getRetryReasons().toString()).append("\r\n");
                    } else {
                        sb.append("SSLCipher: ").append(sslSocketStream.getCipherSuite()).append("\r\n");
                    }
                }
            } else {
                sb.append("----------------CONNECTRequest(HTTP)------------\r\n");
            }
            sb.append(this.proxyRequest.toString());
            sb.append("------------------------------------------------\r\n");
            sb.append(super.getRequestInfo());
            return sb.toString();
        }
        return super.getRequestInfo();
    }

    public boolean isConnectMethodPrefered() {
        return this.preferConnectMethod;
    }
}

