/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.UnsupportedEncodingException;
import java.net.IDN;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.appwork.utils.Exceptions;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptions;

public class SSLSocketStreamFactory18 {
    public static void setSNIServerName(SSLSocketStreamOptions options, SSLSocket sslSocket, String sniHostName) {
        if (options.isSNIEnabled() && StringUtils.isNotEmpty(sniHostName)) {
            SSLParameters sslParams = sslSocket.getSSLParameters();
            List<SNIServerName> serverNames = sslParams.getServerNames();
            if (serverNames == null || serverNames.size() == 0) {
                try {
                    SNIHostName sniServerName = null;
                    try {
                        sniServerName = new SNIHostName(sniHostName);
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            sniServerName = new SNIHostName(IDN.toASCII(sniHostName).getBytes("UTF-8"));
                        }
                        catch (UnsupportedEncodingException e2) {
                            throw Exceptions.addSuppressed(e, e2);
                        }
                    }
                    serverNames = Arrays.asList(sniServerName);
                    sslParams.setServerNames(serverNames);
                    sslSocket.setSSLParameters(sslParams);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else if (!options.isSNIEnabled()) {
            SSLParameters sslParams = sslSocket.getSSLParameters();
            sslParams.setServerNames(Arrays.asList(new SNIServerName[0]));
            sslSocket.setSSLParameters(sslParams);
        }
    }
}

