/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.net.SocketException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpconnection.SSLSocketStreamFactory;
import org.appwork.utils.os.CrossSystem;

public class SSLSocketStreamOptions
implements Cloneable {
    protected final boolean trustAllFlag;
    protected final AtomicBoolean sniEnabled = new AtomicBoolean(true);
    protected final AtomicBoolean valid = new AtomicBoolean(true);
    protected final String id;
    protected final List<String> retryReasons = new CopyOnWriteArrayList<String>();
    protected final List<String> preferredCipherSuites = new CopyOnWriteArrayList<String>();
    protected final List<String> avoidedCipherSuites = new CopyOnWriteArrayList<String>();
    protected final Set<String> disabledCipherSuites = new CopyOnWriteArraySet<String>();
    protected final Set<String> enabledCipherSuites = new CopyOnWriteArraySet<String>();
    protected final Set<String> customFactorySettings = new CopyOnWriteArraySet<String>();
    protected final SSLSocketStreamFactory sslSocketStreamFactory;
    protected final long JAVA_1_8_261 = JVMVersion.parseJavaVersionString("1.8.0_261");
    protected final long JAVA_1_8_272 = JVMVersion.parseJavaVersionString("1.8.0_272");
    protected final long JAVA_11_12 = JVMVersion.parseJavaVersionString("11.0.12");

    public List<String> getRetryReasons() {
        return this.retryReasons;
    }

    public boolean isValid() {
        return this.valid.get();
    }

    public boolean isSNIEnabled() {
        return this.sniEnabled.get();
    }

    public List<String> getPreferredCipherSuites() {
        return this.preferredCipherSuites;
    }

    public List<String> getAvoidedCipherSuites() {
        return this.avoidedCipherSuites;
    }

    public Set<String> getCustomFactorySettings() {
        return this.customFactorySettings;
    }

    public Set<String> getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public String getId() {
        return this.id;
    }

    public SSLSocketStreamOptions(String id, boolean trustFlag) {
        this.id = id;
        this.trustAllFlag = trustFlag;
        this.sslSocketStreamFactory = null;
        this.initCipherSuitesLists();
    }

    public SSLSocketStreamOptions(SSLSocketStreamOptions importFrom) {
        this.id = importFrom.getId();
        this.trustAllFlag = importFrom.isTrustAll();
        this.sniEnabled.set(importFrom.isSNIEnabled());
        this.valid.set(importFrom.isValid());
        this.preferredCipherSuites.addAll(importFrom.getPreferredCipherSuites());
        this.avoidedCipherSuites.addAll(importFrom.getAvoidedCipherSuites());
        this.disabledCipherSuites.addAll(importFrom.getDisabledCipherSuites());
        this.enabledCipherSuites.addAll(importFrom.getEnabledCipherSuites());
        this.customFactorySettings.addAll(importFrom.getCustomFactorySettings());
        this.retryReasons.addAll(importFrom.getRetryReasons());
        this.sslSocketStreamFactory = importFrom.getSSLSocketStreamFactory();
    }

    public boolean hasCipherSuitesPreferences() {
        return this.getAvoidedCipherSuites().size() > 0 || this.getPreferredCipherSuites().size() > 0;
    }

    public String[] sortCipherSuites(String[] cipherSuites) {
        return cipherSuites;
    }

    public SSLSocketStreamFactory getSSLSocketStreamFactory() {
        return this.sslSocketStreamFactory;
    }

    protected void initCipherSuitesLists() {
        boolean hardwareAESSupport;
        boolean gcmFixed = JVMVersion.isMinimum(18000000L) && JVMVersion.get() < 9000000000000L ? (StringUtils.containsIgnoreCase(System.getProperty("java.runtime.name"), "OpenJDK") ? JVMVersion.isMinimum(this.JAVA_1_8_272) : (StringUtils.containsIgnoreCase(System.getProperty("java.runtime.name"), "Java(TM)") ? JVMVersion.isMinimum(this.JAVA_1_8_261) : false)) : JVMVersion.isMinimum(this.JAVA_11_12);
        CrossSystem.ARCHFamily arch = CrossSystem.getARCHFamily();
        boolean bl = hardwareAESSupport = CrossSystem.ARCHFamily.X86.equals((Object)arch) || CrossSystem.ARCHFamily.ARM.equals((Object)arch) && Application.is64BitJvm();
        if (!gcmFixed || !hardwareAESSupport) {
            this.disabledCipherSuites.add("AES_128_GCM");
            this.disabledCipherSuites.add("GCM");
            this.avoidedCipherSuites.add("AES_128_GCM");
            this.avoidedCipherSuites.add("GCM");
            switch (arch) {
                case ARM: {
                    this.preferredCipherSuites.add("CHACHA20");
                    break;
                }
            }
        }
    }

    public Set<String> getDisabledCipherSuites() {
        return this.disabledCipherSuites;
    }

    public boolean isTrustAll() {
        return this.trustAllFlag;
    }

    public SSLSocketStreamOptions clone() {
        return new SSLSocketStreamOptions(this);
    }

    public String enableNextDisabledCipher(String cipher) {
        for (String next : this.disabledCipherSuites) {
            if (!StringUtils.containsIgnoreCase(next, cipher) || !this.disabledCipherSuites.remove(next)) continue;
            this.enabledCipherSuites.add(next);
            return next;
        }
        return null;
    }

    public String addRetryReason(String reason) {
        this.retryReasons.add(reason);
        return reason;
    }

    protected void removeRetryReason(String reason) {
        this.retryReasons.remove(reason);
    }

    public boolean isHandshakeException(Exception e) {
        return e != null && (Exceptions.containsInstanceOf(e, SSLHandshakeException.class) || StringUtils.containsIgnoreCase(e.getMessage(), "Received close_notify during handshake") || StringUtils.containsIgnoreCase(e.getMessage(), "handshake_failure") || StringUtils.containsIgnoreCase(e.getMessage(), "Remote host terminated the handshake") || StringUtils.containsIgnoreCase(e.getMessage(), "Remote host closed connection during handshake"));
    }

    public boolean isTLSConfigurationException(Exception e) {
        return e != null && (StringUtils.containsIgnoreCase(e.getMessage(), "protocol_version") || StringUtils.containsIgnoreCase(e.getMessage(), "cipher suites are inappropriate") || StringUtils.containsIgnoreCase(e.getMessage(), "No appropriate protocol"));
    }

    public boolean isConnectionResetException(Exception e) {
        return e != null && Exceptions.containsInstanceOf(e, SSLException.class, SocketException.class) && StringUtils.containsIgnoreCase(e.getMessage(), "reset");
    }

    public String retry(SSLSocketStreamFactory factory, Exception e) {
        if (this.valid.get()) {
            String enabledCipher;
            String factoryRetry;
            String eMessage;
            String string = eMessage = e != null ? e.getMessage() : null;
            if (StringUtils.containsIgnoreCase(eMessage, "unrecognized_name") && this.sniEnabled.compareAndSet(true, false)) {
                return this.addRetryReason("disable SNI");
            }
            String string2 = factoryRetry = factory != null ? factory.retry(this, e) : null;
            if (factoryRetry != null) {
                this.removeRetryReason(factoryRetry);
                return this.addRetryReason("Factory:" + factory + "=" + factoryRetry);
            }
            if (this.isTLSConfigurationException(e) && (enabledCipher = this.enableNextDisabledCipher("GCM")) != null) {
                return this.addRetryReason("(TLS)enable cipher:" + enabledCipher);
            }
            if (this.isHandshakeException(e) && (enabledCipher = this.enableNextDisabledCipher("GCM")) != null) {
                return this.addRetryReason("(Handshake)enable cipher:" + enabledCipher);
            }
            if (this.isConnectionResetException(e) && (enabledCipher = this.enableNextDisabledCipher("GCM")) != null) {
                return this.addRetryReason("(Reset)enable cipher:" + enabledCipher);
            }
            if (StringUtils.containsIgnoreCase(eMessage, "Could not generate DH keypair") && this.disabledCipherSuites.addAll(Arrays.asList("_DHE", "_ECDHE"))) {
                return this.addRetryReason("disable cipher:DHE,ECDHE");
            }
            this.valid.set(false);
        }
        return null;
    }
}

